/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.manager.am.converter.MetricsConverter;
import org.apache.linkis.manager.am.manager.EMNodeManager;
import org.apache.linkis.manager.am.pointer.NodePointerBuilder;
import org.apache.linkis.manager.common.entity.metrics.NodeMetrics;
import org.apache.linkis.manager.common.entity.node.AMEMNode;
import org.apache.linkis.manager.common.entity.node.AMNode;
import org.apache.linkis.manager.common.entity.node.EMNode;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.entity.node.Node;
import org.apache.linkis.manager.common.entity.node.RMNode;
import org.apache.linkis.manager.common.entity.node.ScoreServiceInstance;
import org.apache.linkis.manager.common.entity.persistence.PersistenceNodeEntity;
import org.apache.linkis.manager.common.protocol.em.ECMOperateRequest;
import org.apache.linkis.manager.common.protocol.em.ECMOperateResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineStopRequest;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnLaunchRequest;
import org.apache.linkis.manager.exception.NodeInstanceDuplicateException;
import org.apache.linkis.manager.persistence.NodeManagerPersistence;
import org.apache.linkis.manager.persistence.NodeMetricManagerPersistence;
import org.apache.linkis.manager.rm.ResourceInfo;
import org.apache.linkis.manager.rm.service.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultEMNodeManager
implements EMNodeManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEMNodeManager.class);
    @Autowired
    private NodeManagerPersistence nodeManagerPersistence;
    @Autowired
    private NodeMetricManagerPersistence nodeMetricManagerPersistence;
    @Autowired
    private MetricsConverter metricsConverter;
    @Autowired
    private NodePointerBuilder nodePointerBuilder;
    @Autowired
    private ResourceManager resourceManager;

    @Override
    public void emRegister(EMNode emNode) {
        this.nodeManagerPersistence.addNodeInstance((Node)emNode);
        this.nodeMetricManagerPersistence.addOrupdateNodeMetrics(this.metricsConverter.getInitMetric(emNode.getServiceInstance()));
    }

    @Override
    public void addEMNodeInstance(EMNode emNode) {
        try {
            this.nodeManagerPersistence.addNodeInstance((Node)emNode);
        }
        catch (NodeInstanceDuplicateException e) {
            logger.warn("em instance had exists, {}.", (Object)emNode);
            this.nodeManagerPersistence.updateEngineNode(emNode.getServiceInstance(), (Node)emNode);
        }
    }

    @Override
    public void initEMNodeMetrics(EMNode emNode) {
        this.nodeMetricManagerPersistence.addOrupdateNodeMetrics(this.metricsConverter.getInitMetric(emNode.getServiceInstance()));
    }

    @Override
    public List<EngineNode> listEngines(EMNode emNode) {
        ArrayList<EngineNode> result = new ArrayList<EngineNode>();
        List nodes = this.nodeManagerPersistence.getEngineNodeByEM(emNode.getServiceInstance());
        HashMap<String, NodeMetrics> metricses = new HashMap<String, NodeMetrics>();
        for (NodeMetrics m : this.nodeMetricManagerPersistence.getNodeMetrics(nodes)) {
            metricses.put(m.getServiceInstance().toString(), m);
        }
        for (EngineNode node : nodes) {
            NodeMetrics metrics = (NodeMetrics)metricses.get(node.getServiceInstance().toString());
            if (metrics != null) {
                this.metricsConverter.fillMetricsToNode((AMNode)node, metrics);
            }
            result.add(node);
        }
        return result;
    }

    @Override
    public List<EngineNode> listUserEngines(EMNode emNode, String user) {
        ArrayList<EngineNode> result = new ArrayList<EngineNode>();
        for (EngineNode node : this.listEngines(emNode)) {
            if (!node.getOwner().equals(user)) continue;
            result.add(node);
        }
        return result;
    }

    @Override
    public List<Node> listUserNodes(String user) {
        return this.nodeManagerPersistence.getNodes(user);
    }

    @Override
    public EMNode[] getEMNodes(ScoreServiceInstance[] scoreServiceInstances) {
        if (null == scoreServiceInstances || scoreServiceInstances.length == 0) {
            return null;
        }
        EMNode[] emNodes = (EMNode[])Arrays.stream(scoreServiceInstances).map(scoreServiceInstance -> {
            AMEMNode emNode = new AMEMNode();
            emNode.setScore(scoreServiceInstance.getScore());
            emNode.setServiceInstance(scoreServiceInstance.getServiceInstance());
            return emNode;
        }).toArray(EMNode[]::new);
        ResourceInfo resourceInfo = this.resourceManager.getResourceInfo((ServiceInstance[])Arrays.stream(scoreServiceInstances).map(ScoreServiceInstance::getServiceInstance).toArray(ServiceInstance[]::new));
        List nodeMetrics = this.nodeMetricManagerPersistence.getNodeMetrics(Arrays.asList(emNodes));
        for (EMNode emNode : emNodes) {
            Optional<NodeMetrics> optionMetrics = nodeMetrics.stream().filter(metrics -> metrics.getServiceInstance().equals((Object)emNode.getServiceInstance())).findFirst();
            Optional<RMNode> optionRMNode = resourceInfo.resourceInfo().stream().filter(rmNode -> rmNode.getServiceInstance().equals((Object)emNode.getServiceInstance())).findFirst();
            optionMetrics.ifPresent(metrics -> this.metricsConverter.fillMetricsToNode((AMNode)emNode, (NodeMetrics)metrics));
            optionRMNode.ifPresent(rmNode -> emNode.setNodeResource(rmNode.getNodeResource()));
        }
        return emNodes;
    }

    @Override
    public EMNode getEM(ServiceInstance serviceInstance) {
        Node node = this.nodeManagerPersistence.getNode(serviceInstance);
        if (null == node) {
            logger.info("This em of " + serviceInstance + " not exists in db");
            return null;
        }
        AMEMNode emNode = new AMEMNode();
        emNode.setOwner(node.getOwner());
        emNode.setServiceInstance(node.getServiceInstance());
        if (node instanceof PersistenceNodeEntity) {
            emNode.setStartTime(node.getStartTime());
        }
        emNode.setMark(emNode.getMark());
        this.metricsConverter.fillMetricsToNode((AMNode)emNode, this.nodeMetricManagerPersistence.getNodeMetrics((Node)emNode));
        return emNode;
    }

    @Override
    public void stopEM(EMNode emNode) {
        this.nodePointerBuilder.buildEMNodePointer(emNode).stopNode();
    }

    @Override
    public void deleteEM(EMNode emNode) {
        this.nodeManagerPersistence.removeNodeInstance((Node)emNode);
        logger.info("Finished to clear emNode instance(" + emNode.getServiceInstance() + ") info ");
        this.nodeMetricManagerPersistence.deleteNodeMetrics((Node)emNode);
        logger.info("Finished to clear emNode(" + emNode.getServiceInstance() + ") metrics info");
    }

    @Override
    public void pauseEM(ServiceInstance serviceInstance) {
    }

    @Override
    public EngineNode createEngine(EngineConnLaunchRequest engineConnLaunchRequest, EMNode emNode) {
        return this.nodePointerBuilder.buildEMNodePointer(emNode).createEngine(engineConnLaunchRequest);
    }

    @Override
    public void stopEngine(EngineStopRequest engineStopRequest, EMNode emNode) {
        this.nodePointerBuilder.buildEMNodePointer(emNode).stopEngine(engineStopRequest);
    }

    @Override
    public ECMOperateResponse executeOperation(EMNode ecmNode, ECMOperateRequest request) {
        return this.nodePointerBuilder.buildEMNodePointer(ecmNode).executeOperation(request);
    }
}

