/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.service.engine;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.utils.JsonUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.service.em.EMInfoService;
import org.apache.linkis.manager.am.service.engine.AbstractEngineService;
import org.apache.linkis.manager.am.service.engine.EngineInfoService;
import org.apache.linkis.manager.am.service.engine.EngineStopService;
import org.apache.linkis.manager.am.service.engine.EngineStopService$;
import org.apache.linkis.manager.common.entity.enumeration.NodeHealthy;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.node.AMEMNode;
import org.apache.linkis.manager.common.entity.node.EMNode;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.protocol.engine.EngineConnReleaseRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineStopRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineSuicideRequest;
import org.apache.linkis.manager.dao.NodeMetricManagerMapper;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.service.NodeLabelService;
import org.apache.linkis.manager.label.service.impl.DefaultNodeLabelRemoveService;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.manager.rm.service.impl.DefaultResourceManager;
import org.apache.linkis.protocol.label.NodeLabelRemoveRequest;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0001\t]d\u0001B\u0012%\u0001MBQa\u0011\u0001\u0005\u0002\u0011C\u0011B\u0012\u0001A\u0002\u0003\u0007I\u0011B$\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0006\"C-\u0001\u0001\u0004\u0005\t\u0015)\u0003I\u0011%9\u0007\u00011AA\u0002\u0013%\u0001\u000eC\u0005s\u0001\u0001\u0007\t\u0019!C\u0005g\"IQ\u000f\u0001a\u0001\u0002\u0003\u0006K!\u001b\u0005\no\u0002\u0001\r\u00111A\u0005\naD\u0011B \u0001A\u0002\u0003\u0007I\u0011B@\t\u0015\u0005\r\u0001\u00011A\u0001B\u0003&\u0011\u0010C\u0006\u0002\b\u0001\u0001\r\u00111A\u0005\n\u0005%\u0001bCA\t\u0001\u0001\u0007\t\u0019!C\u0005\u0003'A1\"a\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\f!Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000f\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%I!!\t\t\u0015\u0005\u0015\u0002\u00011A\u0001B\u0003&\u0001\bC\u0006\u0002*\u0001\u0001\r\u00111A\u0005\n\u0005-\u0002bCA\u001d\u0001\u0001\u0007\t\u0019!C\u0005\u0003wA1\"a\u0010\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002.!Y\u00111\t\u0001A\u0002\u0003\u0007I\u0011BA#\u0011-\t\u0019\u0006\u0001a\u0001\u0002\u0004%I!!\u0016\t\u0017\u0005e\u0003\u00011A\u0001B\u0003&\u0011q\t\u0005\n\u0003;\u0002!\u0019!C\u0006\u0003?B\u0001\"!\u001c\u0001A\u0003%\u0011\u0011\r\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\t9\u000b\u0001C!\u0003SCq!a8\u0001\t\u0003\n\t\u000fC\u0004\u0002x\u0002!\t%!?\t\u000f\t%\u0001\u0001\"\u0011\u0003\f!9!1\u0004\u0001\u0005B\tu\u0001b\u0002B\u0011\u0001\u0011\u0005#1\u0005\u0005\b\u0005O\u0001A\u0011\tB\u0015\u0011\u001d\u00119\u0004\u0001C\u0005\u0005sAqA!\u0014\u0001\t\u0013\u0011yE\u0001\rEK\u001a\fW\u000f\u001c;F]\u001eLg.Z*u_B\u001cVM\u001d<jG\u0016T!!\n\u0014\u0002\r\u0015tw-\u001b8f\u0015\t9\u0003&A\u0004tKJ4\u0018nY3\u000b\u0005%R\u0013AA1n\u0015\tYC&A\u0004nC:\fw-\u001a:\u000b\u00055r\u0013A\u00027j].L7O\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<7\u0001A\n\u0005\u0001QB4\b\u0005\u00026m5\tA%\u0003\u00028I\t)\u0012IY:ue\u0006\u001cG/\u00128hS:,7+\u001a:wS\u000e,\u0007CA\u001b:\u0013\tQDEA\tF]\u001eLg.Z*u_B\u001cVM\u001d<jG\u0016\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0001c\u0013AB2p[6|g.\u0003\u0002C{\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001F!\t)\u0004!\u0001\to_\u0012,G*\u00192fYN+'O^5dKV\t\u0001\n\u0005\u0002J\u001b6\t!J\u0003\u0002(\u0017*\u0011AJK\u0001\u0006Y\u0006\u0014W\r\\\u0005\u0003\u001d*\u0013\u0001CT8eK2\u000b'-\u001a7TKJ4\u0018nY3\u0002)9|G-\u001a'bE\u0016d7+\u001a:wS\u000e,w\fJ3r)\t\tv\u000b\u0005\u0002S+6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16K\u0001\u0003V]&$\bb\u0002-\u0004\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0014!\u00058pI\u0016d\u0015MY3m'\u0016\u0014h/[2fA!\u0012Aa\u0017\t\u00039\u0016l\u0011!\u0018\u0006\u0003=~\u000b!\"\u00198o_R\fG/[8o\u0015\t\u0001\u0017-A\u0004gC\u000e$xN]=\u000b\u0005\t\u001c\u0017!\u00022fC:\u001c(B\u000131\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017B\u00014^\u0005%\tU\u000f^8xSJ,G-A\bsKN|WO]2f\u001b\u0006t\u0017mZ3s+\u0005I\u0007C\u00016q\u001b\u0005Y'B\u00017n\u0003\u0011IW\u000e\u001d7\u000b\u0005\u001dr'BA8+\u0003\t\u0011X.\u0003\u0002rW\n1B)\u001a4bk2$(+Z:pkJ\u001cW-T1oC\u001e,'/A\nsKN|WO]2f\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002Ri\"9\u0001LBA\u0001\u0002\u0004I\u0017\u0001\u0005:fg>,(oY3NC:\fw-\u001a:!Q\t91,\u0001\fo_\u0012,G*\u00192fYJ+Wn\u001c<f'\u0016\u0014h/[2f+\u0005I\bC\u0001>}\u001b\u0005Y(B\u00017K\u0013\ti8PA\u000fEK\u001a\fW\u000f\u001c;O_\u0012,G*\u00192fYJ+Wn\u001c<f'\u0016\u0014h/[2f\u0003iqw\u000eZ3MC\n,GNU3n_Z,7+\u001a:wS\u000e,w\fJ3r)\r\t\u0016\u0011\u0001\u0005\b1&\t\t\u00111\u0001z\u0003]qw\u000eZ3MC\n,GNU3n_Z,7+\u001a:wS\u000e,\u0007\u0005\u000b\u0002\u000b7\u0006\tRM\\4j]\u0016LeNZ8TKJ4\u0018nY3\u0016\u0005\u0005-\u0001cA\u001b\u0002\u000e%\u0019\u0011q\u0002\u0013\u0003#\u0015sw-\u001b8f\u0013:4wnU3sm&\u001cW-A\u000bf]\u001eLg.Z%oM>\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0007E\u000b)\u0002\u0003\u0005Y\u0019\u0005\u0005\t\u0019AA\u0006\u0003I)gnZ5oK&sgm\\*feZL7-\u001a\u0011)\u00055Y\u0016!E3oO&tWm\u0015;paN+'O^5dKV\t\u0001(A\u000bf]\u001eLg.Z*u_B\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0007E\u000b\u0019\u0003C\u0004Y\u001f\u0005\u0005\t\u0019\u0001\u001d\u0002%\u0015tw-\u001b8f'R|\u0007oU3sm&\u001cW\r\t\u0015\u0003!m\u000bqC\\8eK6+GO]5d\u001b\u0006t\u0017mZ3s\u001b\u0006\u0004\b/\u001a:\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\"&A\u0002eC>LA!a\u000e\u00022\t9bj\u001c3f\u001b\u0016$(/[2NC:\fw-\u001a:NCB\u0004XM]\u0001\u001c]>$W-T3ue&\u001cW*\u00198bO\u0016\u0014X*\u00199qKJ|F%Z9\u0015\u0007E\u000bi\u0004\u0003\u0005Y%\u0005\u0005\t\u0019AA\u0017\u0003aqw\u000eZ3NKR\u0014\u0018nY'b]\u0006<WM]'baB,'\u000f\t\u0015\u0003'm\u000bQ\"Z7J]\u001a|7+\u001a:wS\u000e,WCAA$!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'M\u0005\u0011Q-\\\u0005\u0005\u0003#\nYEA\u0007F\u001b&sgm\\*feZL7-Z\u0001\u0012K6LeNZ8TKJ4\u0018nY3`I\u0015\fHcA)\u0002X!A\u0001,FA\u0001\u0002\u0004\t9%\u0001\bf[&sgm\\*feZL7-\u001a\u0011)\u0005YY\u0016\u0001C3yK\u000e,Ho\u001c:\u0016\u0005\u0005\u0005\u0004\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001d4+\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u001b\u0002f\tyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013AC:u_B,enZ5oKR)\u0011+a\u001d\u0002\b\"9\u0011QO\rA\u0002\u0005]\u0014!E3oO&tWm\u0015;paJ+\u0017/^3tiB!\u0011\u0011PAB\u001b\t\tYHC\u0002&\u0003{RA!a \u0002\u0002\u0006A\u0001O]8u_\u000e|GN\u0003\u0002AU%!\u0011QQA>\u0005E)enZ5oKN#x\u000e\u001d*fcV,7\u000f\u001e\u0005\b\u0003\u0013K\u0002\u0019AAF\u0003\u0019\u0019XM\u001c3feB!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u00122\n1A\u001d9d\u0013\u0011\t)*a$\u0003\rM+g\u000eZ3sQ\rI\u0012\u0011\u0014\t\u0005\u00037\u000b\u0019+\u0004\u0002\u0002\u001e*\u0019a,a(\u000b\t\u0005\u0005\u0016qR\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t)+!(\u0003\u0011I+7-Z5wKJ\fQc\u001d;paVsGn\\2l\u000b:<\u0017N\\3Cs\u0016\u001bU\n\u0006\u0004\u0002,\u0006]\u00171\u001c\t\t\u0003[\u000b9,a/\u0002R6\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,\u0001\u0003vi&d'BAA[\u0003\u0011Q\u0017M^1\n\t\u0005e\u0016q\u0016\u0002\u0004\u001b\u0006\u0004\b\u0003BA_\u0003\u0017tA!a0\u0002HB\u0019\u0011\u0011Y*\u000e\u0005\u0005\r'bAAce\u00051AH]8pizJ1!!3T\u0003\u0019\u0001&/\u001a3fM&!\u0011QZAh\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011Z*\u0011\u0007I\u000b\u0019.C\u0002\u0002VN\u00131!\u00118z\u0011\u001d\tIN\u0007a\u0001\u0003w\u000b1\"Z2n\u0013:\u001cH/\u00198dK\"9\u0011Q\u001c\u000eA\u0002\u0005m\u0016\u0001D8qKJ\fGo\u001c:OC6,\u0017aE3oO&tWmQ8o]&sgm\\\"mK\u0006\u0014HcA)\u0002d\"9\u0011Q]\u000eA\u0002\u0005\u001d\u0018AB3d\u001d>$W\r\u0005\u0003\u0002j\u0006MXBAAv\u0015\u0011\ti/a<\u0002\t9|G-\u001a\u0006\u0005\u0003c\f\t)\u0001\u0004f]RLG/_\u0005\u0005\u0003k\fYO\u0001\u0006F]\u001eLg.\u001a(pI\u0016\fQ\"\u001a8hS:,7+^5dS\u0012,G#B)\u0002|\n\u0015\u0001bBA\u007f9\u0001\u0007\u0011q`\u0001\u0015K:<\u0017N\\3Tk&\u001c\u0017\u000eZ3SKF,Xm\u001d;\u0011\t\u0005e$\u0011A\u0005\u0005\u0005\u0007\tYH\u0001\u000bF]\u001eLg.Z*vS\u000eLG-\u001a*fcV,7\u000f\u001e\u0005\b\u0003\u0013c\u0002\u0019AAFQ\ra\u0012\u0011T\u0001\u0012I\u0016\fG.\u00128hS:,'+\u001a7fCN,G#B)\u0003\u000e\t]\u0001b\u0002B\b;\u0001\u0007!\u0011C\u0001\u0019K:<\u0017N\\3D_:t'+\u001a7fCN,'+Z9vKN$\b\u0003BA=\u0005'IAA!\u0006\u0002|\tARI\\4j]\u0016\u001cuN\u001c8SK2,\u0017m]3SKF,Xm\u001d;\t\u000f\u0005%U\u00041\u0001\u0002\f\"\u001aQ$!'\u0002\u001f\u0005\u001c\u0018P\\2Ti>\u0004XI\\4j]\u0016$2!\u0015B\u0010\u0011\u001d\t)H\ba\u0001\u0003o\n\u0001%Y:z]\u000e\u001cFo\u001c9F]\u001eLg.Z,ji\",\u0006\u000fZ1uK6+GO]5dgR\u0019\u0011K!\n\t\u000f\u0005Ut\u00041\u0001\u0002x\u0005\u00113\u000f^8q+:dwnY6F\u0007\nKXk]3s\u0007J,\u0017\r^8s\u0003:$Wi\u0011+za\u0016$r!\u0015B\u0016\u0005_\u0011\u0019\u0004C\u0004\u0003.\u0001\u0002\r!a/\u0002\u0011U\u001cXM\u001d(b[\u0016DqA!\r!\u0001\u0004\tY,A\u0004de\u0016\fGo\u001c:\t\u000f\tU\u0002\u00051\u0001\u0002<\u0006QQM\\4j]\u0016$\u0016\u0010]3\u0002+\u001d,G/\u00128hS:,gj\u001c3f\u0019&\u001cHOQ=F\u001bR!!1\bB&!\u0019\u0011iDa\u0012\u0002h6\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%A\u0004nkR\f'\r\\3\u000b\u0007\t\u00153+\u0001\u0006d_2dWm\u0019;j_:LAA!\u0013\u0003@\t1!)\u001e4gKJDq!!7\"\u0001\u0004\tY,\u0001\feK\u0006dWI\\4j]\u0016\u0014\u00150\u00128hS:,gj\u001c3f)\u0015\t&\u0011\u000bB4\u0011\u001d\u0011\u0019F\ta\u0001\u0005+\na\"\u001a8hS:,gj\u001c3f\u0019&\u001cH\u000f\u0005\u0004\u0003X\t\u0005\u0014q\u001d\b\u0005\u00053\u0012iF\u0004\u0003\u0002B\nm\u0013\"\u0001+\n\u0007\t}3+A\u0004qC\u000e\\\u0017mZ3\n\t\t\r$Q\r\u0002\u0005\u0019&\u001cHOC\u0002\u0003`MCqA!\f#\u0001\u0004\tY\fK\u0002\u0001\u0005W\u0002BA!\u001c\u0003t5\u0011!q\u000e\u0006\u0004\u0005c\u001a\u0017AC:uKJ,w\u000e^=qK&!!Q\u000fB8\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DefaultEngineStopService
extends AbstractEngineService
implements EngineStopService,
Logging {
    @Autowired
    private NodeLabelService nodeLabelService;
    @Autowired
    private DefaultResourceManager resourceManager;
    @Autowired
    private DefaultNodeLabelRemoveService nodeLabelRemoveService;
    @Autowired
    private EngineInfoService engineInfoService;
    @Autowired
    private EngineStopService engineStopService;
    @Autowired
    private NodeMetricManagerMapper nodeMetricManagerMapper;
    @Autowired
    private EMInfoService emInfoService;
    private final ExecutionContextExecutorService executor;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultEngineStopService defaultEngineStopService = this;
        synchronized (defaultEngineStopService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private NodeLabelService nodeLabelService() {
        return this.nodeLabelService;
    }

    private void nodeLabelService_$eq(NodeLabelService x$1) {
        this.nodeLabelService = x$1;
    }

    private DefaultResourceManager resourceManager() {
        return this.resourceManager;
    }

    private void resourceManager_$eq(DefaultResourceManager x$1) {
        this.resourceManager = x$1;
    }

    private DefaultNodeLabelRemoveService nodeLabelRemoveService() {
        return this.nodeLabelRemoveService;
    }

    private void nodeLabelRemoveService_$eq(DefaultNodeLabelRemoveService x$1) {
        this.nodeLabelRemoveService = x$1;
    }

    private EngineInfoService engineInfoService() {
        return this.engineInfoService;
    }

    private void engineInfoService_$eq(EngineInfoService x$1) {
        this.engineInfoService = x$1;
    }

    private EngineStopService engineStopService() {
        return this.engineStopService;
    }

    private void engineStopService_$eq(EngineStopService x$1) {
        this.engineStopService = x$1;
    }

    private NodeMetricManagerMapper nodeMetricManagerMapper() {
        return this.nodeMetricManagerMapper;
    }

    private void nodeMetricManagerMapper_$eq(NodeMetricManagerMapper x$1) {
        this.nodeMetricManagerMapper = x$1;
    }

    private EMInfoService emInfoService() {
        return this.emInfoService;
    }

    private void emInfoService_$eq(EMInfoService x$1) {
        this.emInfoService = x$1;
    }

    private ExecutionContextExecutorService executor() {
        return this.executor;
    }

    @Override
    @Receiver
    public void stopEngine(EngineStopRequest engineStopRequest, Sender sender) {
        engineStopRequest.getServiceInstance().setApplicationName((String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_SPRING_NAME().getValue());
        this.logger().info(new StringBuilder(30).append(" user ").append(engineStopRequest.getUser()).append(" prepare to stop engine ").append(engineStopRequest.getServiceInstance()).toString());
        EngineNode node = this.getEngineNodeManager().getEngineNode(engineStopRequest.getServiceInstance());
        if (node == null) {
            this.logger().info(new StringBuilder(35).append(" engineConn does not exist in db: ").append(engineStopRequest).append(" ").toString());
            return;
        }
        java.util.List<Label<?>> labels = this.nodeLabelService().getNodeLabels(engineStopRequest.getServiceInstance());
        node.setLabels(labels);
        this.logger().info(new StringBuilder(42).append("Start to kill engine invoke enginePointer ").append(node.getServiceInstance()).toString());
        Utils$.MODULE$.tryAndErrorMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.getEMService().stopEngine(node, node.getEMNode());
            this.logger().info(new StringBuilder(45).append("Finished to kill engine invoke enginePointer ").append(node.getServiceInstance()).toString());
        }, new StringBuilder(22).append("Failed to stop engine ").append(node.getServiceInstance()).toString(), this.logger());
        if (node.getNodeStatus() == null) {
            node.setNodeStatus(NodeStatus.ShuttingDown);
        }
        this.engineConnInfoClear(node);
        this.logger().info(new StringBuilder(31).append(" user ").append(engineStopRequest.getUser()).append(" finished to stop engine ").append(engineStopRequest.getServiceInstance()).toString());
    }

    @Override
    public Map<String, Object> stopUnlockEngineByECM(String ecmInstance, String operatorName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        IntRef killEngineNum = IntRef.create((int)0);
        Buffer<EngineNode> engineNodes = this.getEngineNodeListByEM(ecmInstance);
        Buffer unlockEngineNodes = (Buffer)((TraversableLike)engineNodes.filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)NodeStatus.Unlock.equals((Object)node.getNodeStatus())))).filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineStopService.$anonfun$stopUnlockEngineByECM$2(node)));
        this.logger().info(new StringBuilder(52).append("get ec node total num:").append(engineNodes.size()).append(" and unlock node num:").append(unlockEngineNodes.size()).append(" of ecm:").append(ecmInstance).append(" ").toString());
        ObjectRef loadInstanceResourceTotal = ObjectRef.create((Object)new LoadInstanceResource(0L, 0, 0));
        unlockEngineNodes.foreach((Function1 & Serializable & scala.Serializable)node -> {
            DefaultEngineStopService.$anonfun$stopUnlockEngineByECM$3(this, loadInstanceResourceTotal, killEngineNum, operatorName, node);
            return BoxedUnit.UNIT;
        });
        resultMap.put("killEngineNum", BoxesRunTime.boxToInteger((int)killEngineNum.elem));
        resultMap.put("memory", BoxesRunTime.boxToLong((long)((LoadInstanceResource)loadInstanceResourceTotal.elem).getMemory()));
        resultMap.put("cores", BoxesRunTime.boxToInteger((int)((LoadInstanceResource)loadInstanceResourceTotal.elem).getCores()));
        resultMap.put("batchKillEngineType", AMConfiguration.ALLOW_BATCH_KILL_ENGINE_TYPES.getValue());
        return resultMap;
    }

    @Override
    public void engineConnInfoClear(EngineNode ecNode) {
        this.logger().info(new StringBuilder(23).append("Start to clear ec info ").append(ecNode).toString());
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.resourceManager().resourceReleased(ecNode), this.logger());
        NodeLabelRemoveRequest instanceLabelRemoveRequest = new NodeLabelRemoveRequest(ecNode.getServiceInstance(), true);
        this.nodeLabelRemoveService().removeNodeLabel(instanceLabelRemoveRequest);
        this.getEngineNodeManager().deleteEngineNode(ecNode);
        this.logger().info(new StringBuilder(26).append("Finished to clear ec info ").append(ecNode).toString());
    }

    @Override
    @Receiver
    public void engineSuicide(EngineSuicideRequest engineSuicideRequest, Sender sender) {
        this.logger().info(new StringBuilder(41).append("Will ask engine : ").append(engineSuicideRequest.getServiceInstance().toString()).append(" of user : ").append(engineSuicideRequest.getUser()).append(" to suicide.").toString());
        EngineStopService$.MODULE$.askEngineToSuicide(engineSuicideRequest);
    }

    @Override
    @Receiver
    public void dealEngineRelease(EngineConnReleaseRequest engineConnReleaseRequest, Sender sender) {
        this.logger().info(new StringBuilder(36).append("Start to kill engine , with msg : ").append(engineConnReleaseRequest.getMsg()).append(", ").append(engineConnReleaseRequest.getServiceInstance().toString()).toString());
        if (engineConnReleaseRequest.getServiceInstance() == null) {
            this.logger().warn("Invalid empty serviceInstance, will not kill engine.");
            return;
        }
        EngineNode engineNode = this.getEngineNodeManager().getEngineNode(engineConnReleaseRequest.getServiceInstance());
        if (engineNode != null) {
            this.logger().info(new StringBuilder(26).append("Send stop  engine request ").append(engineConnReleaseRequest.getServiceInstance().toString()).toString());
            engineNode.setLabels(this.nodeLabelService().getNodeLabels(engineNode.getServiceInstance()));
            engineNode.setNodeStatus(engineConnReleaseRequest.getNodeStatus());
            this.engineConnInfoClear(engineNode);
            return;
        }
        this.logger().warn(new StringBuilder(52).append("Cannot find valid engineNode from serviceInstance : ").append(engineConnReleaseRequest.getServiceInstance().toString()).toString());
    }

    @Override
    public void asyncStopEngine(EngineStopRequest engineStopRequest) {
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().info(new StringBuilder(33).append("Start to async stop engineFailed ").append(engineStopRequest).toString());
            Utils$.MODULE$.tryAndErrorMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopEngine(engineStopRequest, Sender$.MODULE$.getSender(Sender$.MODULE$.getThisServiceInstance())), new StringBuilder(24).append("async stop engineFailed ").append(engineStopRequest).toString(), this.logger());
        }, (ExecutionContext)this.executor());
    }

    @Override
    public void asyncStopEngineWithUpdateMetrics(EngineStopRequest engineStopRequest) {
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().info(new StringBuilder(32).append("Start to async stop engine node:").append(engineStopRequest).toString());
            String instance = engineStopRequest.getServiceInstance().getInstance();
            this.logger().info(new StringBuilder(53).append("Try to update ec node:").append(engineStopRequest).append(" status Unlock --> ShuttingDown").toString());
            int ok = this.nodeMetricManagerMapper().updateNodeStatus(instance, NodeStatus.ShuttingDown.ordinal(), NodeStatus.Unlock.ordinal());
            if (ok > 0) {
                this.logger().info(new StringBuilder(30).append("Try to do stop ec node ").append(engineStopRequest).append(" action").toString());
                this.stopEngine(engineStopRequest, Sender$.MODULE$.getSender(Sender$.MODULE$.getThisServiceInstance()));
                return;
            }
            this.logger().info(new StringBuilder(93).append("ec node:").append(instance).append(" status update failed! maybe the status is not unlock. will skip to kill this ec node").toString());
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            DefaultEngineStopService.$anonfun$asyncStopEngineWithUpdateMetrics$3(this, x0$1);
            return BoxedUnit.UNIT;
        }), (ExecutionContext)this.executor());
    }

    @Override
    public void stopUnlockECByUserCreatorAndECType(String userName, String creator, String engineType) {
        NodeLabelService qual$1 = this.nodeLabelService();
        String x$1 = userName;
        boolean x$22 = qual$1.getEngineNodesWithResourceByUser$default$2();
        EngineNode[] engineNodes = qual$1.getEngineNodesWithResourceByUser(x$1, x$22);
        if (StringUtils.isEmpty((CharSequence)engineType) && creator.equals(Configuration$.MODULE$.GLOBAL_CONF_SYMBOL())) {
            this.dealEngineByEngineNode((List<EngineNode>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])engineNodes)).toList(), userName);
        }
        if (StringUtils.isNotBlank((CharSequence)engineType) && !creator.equals(Configuration$.MODULE$.GLOBAL_CONF_SYMBOL())) {
            List filterEngineNode = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])engineNodes)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineStopService.$anonfun$stopUnlockECByUserCreatorAndECType$1(userName, x$2))))).filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineStopService.$anonfun$stopUnlockECByUserCreatorAndECType$2(userName, creator, engineType, node))))).toList();
            this.dealEngineByEngineNode((List<EngineNode>)filterEngineNode, userName);
            return;
        }
    }

    private Buffer<EngineNode> getEngineNodeListByEM(String ecmInstance) {
        ServiceInstance ecmInstanceService = new ServiceInstance();
        ecmInstanceService.setInstance(ecmInstance);
        ecmInstanceService.setApplicationName((String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_MANAGER_SPRING_NAME().getValue());
        AMEMNode emNode = new AMEMNode();
        emNode.setServiceInstance(ecmInstanceService);
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.engineInfoService().listEMEngines((EMNode)emNode)).asScala();
    }

    private void dealEngineByEngineNode(List<EngineNode> engineNodeList, String userName) {
        engineNodeList.foreach((Function1 & Serializable & scala.Serializable)node -> {
            DefaultEngineStopService.$anonfun$dealEngineByEngineNode$1(this, userName, node);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$stopUnlockEngineByECM$2(EngineNode node) {
        return !node.getLabels().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$stopUnlockEngineByECM$4(Label x$1) {
        return x$1 instanceof EngineTypeLabel;
    }

    public static final /* synthetic */ void $anonfun$stopUnlockEngineByECM$3(DefaultEngineStopService $this, ObjectRef loadInstanceResourceTotal$1, IntRef killEngineNum$1, String operatorName$1, EngineNode node) {
        Label engineTypeLabel;
        String engineTypeStr;
        boolean isAllowKill;
        if ($this.logger().isDebugEnabled()) {
            try {
                $this.logger().debug(new StringBuilder(8).append("ec node:").append(JsonUtils$.MODULE$.jackson().writeValueAsString((Object)node)).toString());
            }
            catch (JsonProcessingException e) {
                $this.logger().debug(new StringBuilder(36).append("convert jobReq to string with error:").append(e.getMessage()).toString());
            }
        }
        if (!(isAllowKill = AMConfiguration.isAllowKilledEngineType(engineTypeStr = ((EngineTypeLabel)(engineTypeLabel = (Label)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(node.getLabels()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineStopService.$anonfun$stopUnlockEngineByECM$4(x$1))).orNull(Predef$.MODULE$.$conforms()))).getEngineType()))) {
            $this.logger().info(new StringBuilder(41).append("skipped to kill engine node:").append(node.getServiceInstance().getInstance()).append(",engine type:").append(engineTypeStr).toString());
            return;
        }
        if (node.getNodeResource().getUsedResource() != null) {
            Resource resource;
            Resource resource2 = node.getNodeResource().getUsedResource();
            if (resource2 instanceof DriverAndYarnResource) {
                DriverAndYarnResource driverAndYarnResource = (DriverAndYarnResource)resource2;
                resource = driverAndYarnResource.getLoadInstanceResource();
            } else {
                resource = node.getNodeResource().getUsedResource();
            }
            Resource realResource = resource;
            loadInstanceResourceTotal$1.elem = ((LoadInstanceResource)loadInstanceResourceTotal$1.elem).add(node.getNodeResource().getUsedResource());
        }
        $this.logger().info(new StringBuilder(29).append("try to asyn kill engine node:").append(node.getServiceInstance().getInstance()).toString());
        ++killEngineNum$1.elem;
        EngineStopRequest stopEngineRequest = new EngineStopRequest(node.getServiceInstance(), operatorName$1);
        $this.asyncStopEngineWithUpdateMetrics(stopEngineRequest);
    }

    public static final /* synthetic */ void $anonfun$asyncStopEngineWithUpdateMetrics$3(DefaultEngineStopService $this, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().error(new StringBuilder(46).append("asyncStopEngineWithUpdateMetrics with error:, ").append(exception.getMessage()).toString(), (Throwable)exception);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ boolean $anonfun$stopUnlockECByUserCreatorAndECType$1(String userName$1, EngineNode x$2) {
        return x$2.getOwner().equals(userName$1);
    }

    public static final /* synthetic */ boolean $anonfun$stopUnlockECByUserCreatorAndECType$2(String userName$1, String creator$1, String engineType$1, EngineNode node) {
        boolean filterResult;
        block1: {
            filterResult = false;
            if (node.getLabels().isEmpty()) break block1;
            UserCreatorLabel userCreator = LabelUtil$.MODULE$.getUserCreatorLabel(node.getLabels());
            String engineTypeLabel = LabelUtil$.MODULE$.getEngineTypeLabel(node.getLabels()).getStringValue();
            if (userCreator.getUser().equals(userName$1) && userCreator.getCreator().equals(creator$1) && engineTypeLabel.equals(engineType$1)) {
                filterResult = true;
            }
        }
        return filterResult;
    }

    public static final /* synthetic */ void $anonfun$dealEngineByEngineNode$1(DefaultEngineStopService $this, String userName$2, EngineNode node) {
        if (NodeStatus.Unlock.equals((Object)node.getNodeStatus()) && AMConfiguration.isAllowKilledEngineType(LabelUtil$.MODULE$.getEngineType(node.getLabels()))) {
            EngineStopRequest stopEngineRequest = new EngineStopRequest(node.getServiceInstance(), userName$2);
            $this.asyncStopEngineWithUpdateMetrics(stopEngineRequest);
            return;
        }
        $this.engineInfoService().updateEngineHealthyStatus(node.getServiceInstance(), NodeHealthy.UnHealthy);
    }

    public DefaultEngineStopService() {
        Logging.$init$((Logging)this);
        this.executor = Utils$.MODULE$.newCachedExecutionContext(AMConfiguration.ASYNC_STOP_ENGINE_MAX_THREAD_SIZE, "AsyncStopEngineService-Thread-", Utils$.MODULE$.newCachedExecutionContext$default$3());
    }
}

