/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.rm.utils;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestKerberosUrlUtils {
    public static Logger logger = LoggerFactory.getLogger(RequestKerberosUrlUtils.class);
    private String principal;
    private String keyTabLocation;

    public RequestKerberosUrlUtils(String principal, String keyTabLocation) {
        this.principal = principal;
        this.keyTabLocation = keyTabLocation;
    }

    public RequestKerberosUrlUtils(String principal, String keyTabLocation, boolean isDebug) {
        this(principal, keyTabLocation);
        if (isDebug) {
            System.setProperty("sun.security.spnego.debug", "true");
            System.setProperty("sun.security.krb5.debug", "true");
        }
    }

    public RequestKerberosUrlUtils(String principal, String keyTabLocation, String krb5Location, boolean isDebug) {
        this(principal, keyTabLocation, isDebug);
        System.setProperty("java.security.krb5.conf", krb5Location);
    }

    private static HttpClient buildSpengoHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build();
        builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1, null), new Credentials(){

            public Principal getUserPrincipal() {
                return null;
            }

            public String getPassword() {
                return null;
            }
        });
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        CloseableHttpClient httpClient = builder.build();
        return httpClient;
    }

    public HttpResponse callRestUrl(final String url, String userId) {
        logger.warn(String.format("Calling KerberosHttpClient %s %s %s", this.principal, this.keyTabLocation, url));
        Configuration config = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap<String, Object>(){
                    {
                        this.put("useTicketCache", "false");
                        this.put("useKeyTab", "true");
                        this.put("keyTab", RequestKerberosUrlUtils.this.keyTabLocation);
                        this.put("refreshKrb5Config", "true");
                        this.put("principal", RequestKerberosUrlUtils.this.principal);
                        this.put("storeKey", "true");
                        this.put("doNotPrompt", "true");
                        this.put("isInitiator", "true");
                        this.put("debug", "false");
                    }
                })};
            }
        };
        HashSet<KerberosPrincipal> princ = new HashSet<KerberosPrincipal>(1);
        princ.add(new KerberosPrincipal(userId));
        Subject sub = new Subject(false, princ, new HashSet(), new HashSet());
        try {
            LoginContext lc = new LoginContext("Krb5Login", sub, null, config);
            lc.login();
            Subject serviceSubject = lc.getSubject();
            return Subject.doAs(serviceSubject, new PrivilegedAction<HttpResponse>(){
                HttpResponse httpResponse = null;

                @Override
                public HttpResponse run() {
                    try {
                        HttpGet request = new HttpGet(url);
                        HttpClient spnegoHttpClient = RequestKerberosUrlUtils.buildSpengoHttpClient();
                        this.httpResponse = spnegoHttpClient.execute((HttpUriRequest)request);
                        return this.httpResponse;
                    }
                    catch (IOException ioe) {
                        logger.error("request yarn url:{} failed", (Object)url, (Object)ioe);
                        return this.httpResponse;
                    }
                }
            });
        }
        catch (Exception le) {
            logger.error("Krb5Login login failed", (Throwable)le);
            return null;
        }
    }
}

