/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.apache.commons.io.FileUtils;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.apache.linkis.server.socket.ControllerServer;
import org.apache.linkis.server.socket.controller.ServerEventService;
import org.apache.linkis.server.socket.controller.ServerListenerEventBus;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class BDPJettyServerHelper$
implements Logging {
    public static BDPJettyServerHelper$ MODULE$;
    private ServerListenerEventBus serverListenerEventBus;
    private ControllerServer controllerServer;
    private final Buffer<ServerEventService> services;
    private final String TMP_FOLDER;
    private final int MAX_UPLOAD_SIZE;
    private final Gson gson;
    private final ObjectMapper jacksonJson;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BDPJettyServerHelper$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        BDPJettyServerHelper$ bDPJettyServerHelper$ = this;
        synchronized (bDPJettyServerHelper$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ServerListenerEventBus serverListenerEventBus() {
        return this.serverListenerEventBus;
    }

    private void serverListenerEventBus_$eq(ServerListenerEventBus x$1) {
        this.serverListenerEventBus = x$1;
    }

    private ControllerServer controllerServer() {
        return this.controllerServer;
    }

    private void controllerServer_$eq(ControllerServer x$1) {
        this.controllerServer = x$1;
    }

    private Buffer<ServerEventService> services() {
        return this.services;
    }

    private String TMP_FOLDER() {
        return this.TMP_FOLDER;
    }

    private int MAX_UPLOAD_SIZE() {
        return this.MAX_UPLOAD_SIZE;
    }

    public ControllerServer getControllerServer() {
        return this.controllerServer();
    }

    private void createServerListenerEventBus() {
        this.serverListenerEventBus_$eq(new ServerListenerEventBus(BoxesRunTime.unboxToInt((Object)ServerConfiguration$.MODULE$.BDP_SERVER_EVENT_QUEUE_SIZE().getValue()), "WebSocket-Server-Event-ListenerBus", BoxesRunTime.unboxToInt((Object)ServerConfiguration$.MODULE$.BDP_SERVER_EVENT_CONSUMER_THREAD_SIZE().getValue()), ((TimeType)ServerConfiguration$.MODULE$.BDP_SERVER_EVENT_CONSUMER_THREAD_FREE_MAX().getValue()).toLong()));
        ServerListenerEventBus serverListenerEventBus = this.serverListenerEventBus();
        this.services().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            serverListenerEventBus.addListener(listener);
            return BoxedUnit.UNIT;
        });
        this.serverListenerEventBus().start();
    }

    public void addServerEventService(ServerEventService serverEventService) {
        if (this.serverListenerEventBus() != null) {
            this.serverListenerEventBus().addListener(serverEventService);
            return;
        }
        this.services().$plus$eq((Object)serverEventService);
    }

    private Class<Filter> getSecurityFilter() {
        return Class.forName((String)ServerConfiguration$.MODULE$.BDP_SERVER_SECURITY_FILTER().getValue());
    }

    public void setupSpringRestApiContextHandler(ServletContextHandler webApp) {
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        String CONFIG_LOCATION = "";
        context.setConfigLocation(CONFIG_LOCATION);
        DispatcherServlet serlvet = new DispatcherServlet((WebApplicationContext)context);
        ServletHolder servletHolder = new ServletHolder((Servlet)serlvet);
        servletHolder.setName("springrestful");
        servletHolder.setForcedPath("springrestful");
        MultipartConfigElement multipartConfigElement = (MultipartConfigElement)DataWorkCloudApplication.getApplicationContext().getBean(MultipartConfigElement.class);
        servletHolder.getRegistration().setMultipartConfig(multipartConfigElement);
        String p = (String)ServerConfiguration$.MODULE$.BDP_SERVER_RESTFUL_URI().getValue();
        String restfulPath = p.endsWith("/*") ? p : (p.endsWith("/") ? new StringBuilder(1).append(p).append("*").toString() : new StringBuilder(2).append(p).append("/*").toString());
        webApp.addServlet(servletHolder, restfulPath);
        FilterHolder filterHolder = new FilterHolder(this.getSecurityFilter());
        webApp.addFilter(filterHolder, restfulPath, EnumSet.allOf(DispatcherType.class));
        webApp.setSessionHandler(new SessionHandler());
    }

    public ControllerServer setupControllerServer(ServletContextHandler webApp) {
        ControllerServer controllerServer;
        block6: {
            if (this.controllerServer() != null) {
                return this.controllerServer();
            }
            BDPJettyServerHelper$ bDPJettyServerHelper$ = this;
            synchronized (bDPJettyServerHelper$) {
                ControllerServer controllerServer2;
                block5: {
                    if (this.controllerServer() != null) {
                        controllerServer2 = this.controllerServer();
                        break block5;
                    }
                    this.createServerListenerEventBus();
                    this.controllerServer_$eq(new ControllerServer(this.serverListenerEventBus()));
                    String maxTextMessageSize = (String)ServerConfiguration$.MODULE$.BDP_SERVER_SOCKET_TEXT_MESSAGE_SIZE_MAX().getValue();
                    ServletHolder servletHolder = new ServletHolder((Servlet)this.controllerServer());
                    servletHolder.setInitParameter("maxTextMessageSize", maxTextMessageSize);
                    String p = (String)ServerConfiguration$.MODULE$.BDP_SERVER_SOCKET_URI().getValue();
                    String socketPath = p.endsWith("/*") ? p : (p.endsWith("/") ? new StringBuilder(1).append(p).append("*").toString() : new StringBuilder(2).append(p).append("/*").toString());
                    webApp.addServlet(servletHolder, socketPath);
                    controllerServer = this.controllerServer();
                    break block6;
                }
                return controllerServer2;
            }
        }
        return controllerServer;
    }

    public void setupWebAppContext(WebAppContext webApp) {
        webApp.setContextPath((String)ServerConfiguration$.MODULE$.BDP_SERVER_SERVER_CONTEXT_PATH().getValue());
        ObjectRef warPath = ObjectRef.create((Object)new File((String)ServerConfiguration$.MODULE$.BDP_SERVER_WAR().getValue()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((File)warPath.elem).listFiles())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BDPJettyServerHelper$.$anonfun$setupWebAppContext$1(x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            warPath.elem = x$2;
            return BoxedUnit.UNIT;
        });
        if (((File)warPath.elem).isDirectory()) {
            webApp.setResourceBase(((File)warPath.elem).getPath());
            webApp.setParentLoaderPriority(true);
        } else {
            webApp.setWar(((File)warPath.elem).getAbsolutePath());
            webApp.setExtractWAR(true);
            File warTempDirectory = new File((String)ServerConfiguration$.MODULE$.BDP_SERVER_WAR_TEMPDIR().getValue());
            if (warTempDirectory.exists()) {
                this.logger().warn(new StringBuilder(28).append("delete ").append(warTempDirectory.getPath()).append(", since it is exists.").toString());
                FileUtils.deleteDirectory((File)warTempDirectory);
            }
            warTempDirectory.mkdir();
            this.logger().info(new StringBuilder(30).append("BDPJettyServer Webapps path: ").append(warTempDirectory.getPath()).append(".").toString());
            webApp.setTempDirectory(warTempDirectory);
        }
        webApp.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        webApp.setWelcomeFiles((String[])((Object[])new String[]{"index.html", "index.htm"}));
        webApp.getSessionHandler().setMaxInactiveInterval((int)(((TimeType)ServerConfiguration$.MODULE$.BDP_SERVER_WEB_SESSION_TIMEOUT().getValue()).toLong() / 1000L));
        webApp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", (String)ServerConfiguration$.MODULE$.BDP_SERVER_SERVER_DEFAULT_DIR_ALLOWED().getValue());
    }

    public Gson gson() {
        return this.gson;
    }

    public ObjectMapper jacksonJson() {
        return this.jacksonJson;
    }

    public static final /* synthetic */ boolean $anonfun$setupWebAppContext$1(File x$1) {
        return x$1.getName().endsWith(".war");
    }

    private BDPJettyServerHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.services = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.TMP_FOLDER = "";
        this.MAX_UPLOAD_SIZE = 0xC800000;
        this.gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").serializeNulls().registerTypeAdapter(Double.class, (Object)new JsonSerializer<Double>(){

            public JsonElement serialize(Double t, Type type, JsonSerializationContext jsonSerializationContext) {
                if (BoxesRunTime.equalsNumObject((Number)t, (Object)BoxesRunTime.boxToLong((long)t.longValue()))) {
                    return new JsonPrimitive((Number)Predef$.MODULE$.long2Long(t.longValue()));
                }
                return new JsonPrimitive((Number)t);
            }
        }).create();
        this.jacksonJson = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
    }
}

