/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.ticket;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.linkis.server.conf.SessionHAConfiguration$;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.mutable.ArrayOps;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class RedisClient$ {
    public static RedisClient$ MODULE$;
    private final int RedisTimeOut;
    private final int MaxTotal;
    private final int MaxIdle;
    private final int MinIdle;
    private transient JedisPool org$apache$linkis$server$ticket$RedisClient$$Pool;
    private transient JedisSentinelPool org$apache$linkis$server$ticket$RedisClient$$PoolSentinal;

    static {
        new RedisClient$();
    }

    private int RedisTimeOut() {
        return this.RedisTimeOut;
    }

    private int MaxTotal() {
        return this.MaxTotal;
    }

    private int MaxIdle() {
        return this.MaxIdle;
    }

    private int MinIdle() {
        return this.MinIdle;
    }

    public JedisPool org$apache$linkis$server$ticket$RedisClient$$Pool() {
        return this.org$apache$linkis$server$ticket$RedisClient$$Pool;
    }

    private void org$apache$linkis$server$ticket$RedisClient$$Pool_$eq(JedisPool x$1) {
        this.org$apache$linkis$server$ticket$RedisClient$$Pool = x$1;
    }

    public JedisSentinelPool org$apache$linkis$server$ticket$RedisClient$$PoolSentinal() {
        return this.org$apache$linkis$server$ticket$RedisClient$$PoolSentinal;
    }

    private void org$apache$linkis$server$ticket$RedisClient$$PoolSentinal_$eq(JedisSentinelPool x$1) {
        this.org$apache$linkis$server$ticket$RedisClient$$PoolSentinal = x$1;
    }

    public void makePool(int redisTimeout, int maxTotal, int maxIdle, int minIdle) {
        this.makePool(redisTimeout, maxTotal, maxIdle, minIdle, 10000L);
    }

    public void makePool(int redisTimeout, int maxTotal, int maxIdle, int minIdle, long maxWaitMillis) {
        if (this.org$apache$linkis$server$ticket$RedisClient$$Pool() == null) {
            GenericObjectPoolConfig<Jedis> poolConfig = this.getGenericObjectPoolConfig(maxTotal, maxIdle, minIdle, maxWaitMillis);
            if (StringUtils.isNotBlank((CharSequence)SessionHAConfiguration$.MODULE$.RedisSentinalMaster()) && StringUtils.isNotBlank((CharSequence)SessionHAConfiguration$.MODULE$.RedisSentinalServer())) {
                scala.collection.immutable.Set nodes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SessionHAConfiguration$.MODULE$.RedisSentinalServer().split(","))).toSet();
                this.org$apache$linkis$server$ticket$RedisClient$$PoolSentinal_$eq(new JedisSentinelPool(SessionHAConfiguration$.MODULE$.RedisSentinalMaster(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)nodes).asJava(), poolConfig, redisTimeout, SessionHAConfiguration$.MODULE$.RedisPassword()));
            } else {
                this.org$apache$linkis$server$ticket$RedisClient$$Pool_$eq(new JedisPool(poolConfig, SessionHAConfiguration$.MODULE$.RedisHost(), SessionHAConfiguration$.MODULE$.RedisPort(), redisTimeout, SessionHAConfiguration$.MODULE$.RedisPassword()));
            }
            this.shutdownHooks();
            return;
        }
    }

    public void shutdownHooks() {
        Thread hook = new Thread(){

            public void run() {
                if (RedisClient$.MODULE$.org$apache$linkis$server$ticket$RedisClient$$Pool() != null) {
                    RedisClient$.MODULE$.org$apache$linkis$server$ticket$RedisClient$$Pool().destroy();
                }
                if (RedisClient$.MODULE$.org$apache$linkis$server$ticket$RedisClient$$PoolSentinal() != null) {
                    RedisClient$.MODULE$.org$apache$linkis$server$ticket$RedisClient$$PoolSentinal().destroy();
                    return;
                }
            }
        };
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> hook.run());
    }

    public GenericObjectPoolConfig<Jedis> getGenericObjectPoolConfig(int maxTotal, int maxIdle, int minIdle, long maxWaitMillis) {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(maxTotal);
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMinIdle(minIdle);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        poolConfig.setMaxWaitMillis(maxWaitMillis);
        return poolConfig;
    }

    public Jedis getResource() {
        if (this.org$apache$linkis$server$ticket$RedisClient$$Pool() != null) {
            return this.org$apache$linkis$server$ticket$RedisClient$$Pool().getResource();
        }
        return this.org$apache$linkis$server$ticket$RedisClient$$PoolSentinal().getResource();
    }

    public void closeResource(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
            return;
        }
    }

    private RedisClient$() {
        MODULE$ = this;
        this.RedisTimeOut = 30000;
        this.MaxTotal = 300;
        this.MaxIdle = 100;
        this.MinIdle = 1;
        this.makePool(this.RedisTimeOut(), this.MaxTotal(), this.MaxIdle(), this.MinIdle());
    }
}

