/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.interceptor.impl;

import java.util.regex.Pattern;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.interceptor.impl.Explain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class SparkExplain$
extends Explain {
    public static SparkExplain$ MODULE$;
    private final Pattern scStop;
    private final Pattern systemExit;
    private final Pattern sy;
    private final Pattern scCancelAllJobs;
    private final Pattern runtime;
    private final String LINE_BREAK;
    private final Logger LOG;

    static {
        new SparkExplain$();
    }

    private Pattern scStop() {
        return this.scStop;
    }

    private Pattern systemExit() {
        return this.systemExit;
    }

    private Pattern sy() {
        return this.sy;
    }

    private Pattern scCancelAllJobs() {
        return this.scCancelAllJobs;
    }

    private Pattern runtime() {
        return this.runtime;
    }

    private String LINE_BREAK() {
        return this.LINE_BREAK;
    }

    private Logger LOG() {
        return this.LOG;
    }

    @Override
    public boolean authPass(String code, StringBuilder error) {
        if (BoxesRunTime.unboxToBoolean((Object)EntranceConfiguration$.MODULE$.SKIP_AUTH().getHotValue())) {
            return true;
        }
        if (this.scStop().matcher(code).find()) {
            error.append("Authentication error: sc.stop() is not allowed in IDE.");
            return false;
        }
        if (this.systemExit().matcher(code).find()) {
            error.append("Authentication error: System.exit(exitCode) is not allowed in IDE.");
            return false;
        }
        if (this.scCancelAllJobs().matcher(code).find()) {
            error.append("Authentication error: sc.cancelAllJobs() is not allowed in IDE.");
            return false;
        }
        if (this.runtime().matcher(code).find()) {
            error.append("Authentication error: Runtime.getRuntime is not allowed in IDE.");
            return false;
        }
        return true;
    }

    private SparkExplain$() {
        MODULE$ = this;
        this.scStop = Pattern.compile("sc\\.stop(\\s*)");
        this.systemExit = Pattern.compile("System\\.exit");
        this.sy = Pattern.compile("sys\\.");
        this.scCancelAllJobs = Pattern.compile("sc\\.cancelAllJobs(\\s*)");
        this.runtime = Pattern.compile("Runtime\\.getRuntime");
        this.LINE_BREAK = "\n";
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

