/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.interceptor.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.exception.EntranceErrorCode;
import org.apache.linkis.entrance.interceptor.exception.SetTenantLabelException;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.protocol.conf.TenantRequest;
import org.apache.linkis.governance.common.protocol.conf.TenantResponse;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.TenantLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.slf4j.Logger;
import scala.Function0;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class TenantLabelSetUtils$
implements Logging {
    public static TenantLabelSetUtils$ MODULE$;
    private final LoadingCache<String, String> userCreatorTenantCache;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new TenantLabelSetUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        TenantLabelSetUtils$ tenantLabelSetUtils$ = this;
        synchronized (tenantLabelSetUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private LoadingCache<String, String> userCreatorTenantCache() {
        return this.userCreatorTenantCache;
    }

    public JobRequest checkTenantLabel(JobRequest jobRequest, StringBuilder logAppender) {
        block5: {
            JobRequest jobRequest2 = jobRequest;
            if (jobRequest2 == null) break block5;
            JobRequest jobRequest3 = jobRequest2;
            List labels = jobRequest3.getLabels();
            this.logger().debug("check labels contains tenant :{} ", new Object[]{labels});
            if (!labels.contains("tenant")) {
                String userName = jobRequest.getSubmitUser();
                if (StringUtils.isBlank((CharSequence)userName)) {
                    throw new SetTenantLabelException(EntranceErrorCode.USER_NULL_EXCEPTION.getErrCode(), EntranceErrorCode.USER_NULL_EXCEPTION.getDesc());
                }
                String tenant = "";
                tenant = (String)this.userCreatorTenantCache().get((Object)LabelUtil$.MODULE$.getUserCreatorLabel(labels).getStringValue().toLowerCase());
                if (StringUtils.isBlank((CharSequence)tenant)) {
                    tenant = (String)this.userCreatorTenantCache().get((Object)new StringBuilder(2).append("*-").append(LabelUtil$.MODULE$.getUserCreatorLabel(jobRequest.getLabels()).getCreator().toLowerCase()).toString());
                }
                if (StringUtils.isBlank((CharSequence)tenant)) {
                    tenant = (String)this.userCreatorTenantCache().get((Object)new StringBuilder(2).append(LabelUtil$.MODULE$.getUserCreatorLabel(jobRequest.getLabels()).getUser().toLowerCase()).append("-*").toString());
                }
                this.logger().info(new StringBuilder(29).append("get cache tenant:").append(tenant).append(",jobRequest:").append(jobRequest.getId()).toString());
                if (StringUtils.isNotBlank((CharSequence)tenant)) {
                    TenantLabel tenantLabel = (TenantLabel)LabelBuilderFactoryContext.getLabelBuilderFactory().createLabel("tenant");
                    tenantLabel.setTenant(tenant);
                    labels.add(tenantLabel);
                    logAppender.append(new StringBuilder(1).append(LogUtils$.MODULE$.generateInfo(new StringBuilder(40).append("Your task should be to set tenant label ").append(tenant).toString())).append("\n").toString());
                }
            }
        }
        return jobRequest;
    }

    private TenantLabelSetUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.userCreatorTenantCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.USER_PARALLEL_REFLESH_TIME().getValue()), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String userCreatorLabel) {
                String cacheValue;
                block0: {
                    cacheValue = (String)Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> {
                        Sender sender = Sender$.MODULE$.getSender((String)Configuration$.MODULE$.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME().getValue());
                        String user = userCreatorLabel.split("-")[0];
                        String creator = userCreatorLabel.split("-")[1];
                        TenantLabelSetUtils$.MODULE$.logger().info(new StringBuilder(36).append("load tenant data user ").append(user).append(" creator ").append(creator).append(" data").toString());
                        Object object = sender.ask((Object)new TenantRequest(user, creator));
                        if (object instanceof TenantResponse) {
                            TenantResponse tenantResponse = (TenantResponse)object;
                            return tenantResponse.tenant();
                        }
                        TenantLabelSetUtils$.MODULE$.logger().warn(new StringBuilder(46).append("TenantCache user ").append(user).append(" creator ").append(creator).append(" data loading failed").toString());
                        return "";
                    }, TenantLabelSetUtils$.MODULE$.logger());
                    if (!StringUtils.isBlank((CharSequence)cacheValue)) break block0;
                    TenantLabelSetUtils$.MODULE$.logger().warn("TenantCache data loading failed , plaese check warn log");
                    cacheValue = "";
                }
                return cacheValue;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$load$1(java.lang.String )}, serializedLambda);
            }
        });
    }
}

