/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.scheduler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.job.EntranceExecutionJob;
import org.apache.linkis.entrance.scheduler.CreatorECTypeDefaultConf;
import org.apache.linkis.entrance.scheduler.EntranceSchedulerContext;
import org.apache.linkis.entrance.utils.JobHistoryHelper$;
import org.apache.linkis.scheduler.SchedulerContext;
import org.apache.linkis.scheduler.queue.Consumer;
import org.apache.linkis.scheduler.queue.Group;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.fifoqueue.FIFOUserConsumer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0003\u0006\u0001+!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011!9\u0004A!a\u0001\n\u0013A\u0004\u0002C\u001f\u0001\u0005\u0003\u0007I\u0011\u0002 \t\u0011\u001d\u0003!\u0011!Q!\neBQ\u0001\u0013\u0001\u0005\u0002%CQa\u0014\u0001\u0005BACQ!\u0015\u0001\u0005BI\u0013\u0001$\u00128ue\u0006t7-\u001a$J\r>+6/\u001a:D_:\u001cX/\\3s\u0015\tYA\"A\u0005tG\",G-\u001e7fe*\u0011QBD\u0001\tK:$(/\u00198dK*\u0011q\u0002E\u0001\u0007Y&t7.[:\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\r\u0001ac\b\t\u0003/ui\u0011\u0001\u0007\u0006\u00033i\t\u0011BZ5g_F,X-^3\u000b\u0005ma\u0012!B9vKV,'BA\u0006\u000f\u0013\tq\u0002D\u0001\tG\u0013\u001a{Uk]3s\u0007>t7/^7feB\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0006kRLGn\u001d\u0006\u0003I9\taaY8n[>t\u0017B\u0001\u0014\"\u0005\u001daunZ4j]\u001e\f\u0001c]2iK\u0012,H.\u001a:D_:$X\r\u001f;\u0011\u0005%RS\"\u0001\u000f\n\u0005-b\"\u0001E*dQ\u0016$W\u000f\\3s\u0007>tG/\u001a=u\u00039)\u00070Z2vi\u0016\u001cVM\u001d<jG\u0016\u0004\"AL\u001b\u000e\u0003=R!\u0001M\u0019\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00023g\u0005!Q\u000f^5m\u0015\u0005!\u0014\u0001\u00026bm\u0006L!AN\u0018\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\fQa\u001a:pkB,\u0012!\u000f\t\u0003umj\u0011AG\u0005\u0003yi\u0011Qa\u0012:pkB\f\u0011b\u001a:pkB|F%Z9\u0015\u0005}*\u0005C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%\u0001B+oSRDqA\u0012\u0003\u0002\u0002\u0003\u0007\u0011(A\u0002yIE\naa\u001a:pkB\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003K\u00196s\u0005CA&\u0001\u001b\u0005Q\u0001\"B\u0014\u0007\u0001\u0004A\u0003\"\u0002\u0017\u0007\u0001\u0004i\u0003\"B\u001c\u0007\u0001\u0004I\u0014\u0001\u00027p_B$\u0012aP\u0001\u0015eVt7k\u00195fIVdW-\u00138uKJ\u001cW\r\u001d;\u0015\u0003M\u0003\"\u0001\u0011+\n\u0005U\u000b%a\u0002\"p_2,\u0017M\u001c")
public class EntranceFIFOUserConsumer
extends FIFOUserConsumer {
    private final SchedulerContext schedulerContext;
    private Group group;

    private Group group() {
        return this.group;
    }

    private void group_$eq(Group x$1) {
        this.group = x$1;
    }

    public void loop() {
        SchedulerContext schedulerContext = this.schedulerContext;
        if (schedulerContext instanceof EntranceSchedulerContext) {
            EntranceSchedulerContext entranceSchedulerContext = (EntranceSchedulerContext)schedulerContext;
            if (entranceSchedulerContext.getOfflineFlag() && BoxesRunTime.unboxToBoolean((Object)EntranceConfiguration$.MODULE$.ENTRANCE_FAILOVER_RETRY_JOB_ENABLED().getValue())) {
                Object object;
                List jobs = this.scanAllRetryJobsAndRemove();
                if (!jobs.isEmpty()) {
                    ArrayList<Object> ids = new ArrayList<Object>();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)jobs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Job job = x0$1;
                        if (job instanceof EntranceExecutionJob) {
                            EntranceExecutionJob entranceExecutionJob = (EntranceExecutionJob)job;
                            entranceExecutionJob.getLogWriter().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                                x$1.close();
                                return BoxedUnit.UNIT;
                            });
                            return BoxesRunTime.boxToBoolean((boolean)ids.add(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(entranceExecutionJob.getJobRequest().getId()))));
                        }
                        return BoxedUnit.UNIT;
                    });
                    object = JobHistoryHelper$.MODULE$.updateBatchInstancesEmpty(ids);
                } else {
                    object = BoxedUnit.UNIT;
                }
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(5000L));
                return;
            }
        }
        super.loop();
    }

    public boolean runScheduleIntercept() {
        Consumer[] consumers = this.getSchedulerContext().getOrCreateConsumerManager().listConsumers();
        IntRef creatorRunningJobNum = IntRef.create((int)0);
        String groupNameStr = this.getGroup().getGroupName();
        String[] groupNames = groupNameStr.split("_");
        int length = groupNames.length;
        if (length < 3) {
            return true;
        }
        int lastIndex = groupNameStr.lastIndexOf("_");
        int secondLastIndex = groupNameStr.lastIndexOf("_", lastIndex - 1);
        String creatorName = groupNameStr.substring(0, secondLastIndex);
        String ecType = groupNames[length - 1];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])consumers)).foreach((Function1 & Serializable & scala.Serializable)consumer -> {
            EntranceFIFOUserConsumer.$anonfun$runScheduleIntercept$1(creatorName, ecType, creatorRunningJobNum, consumer);
            return BoxedUnit.UNIT;
        });
        int creatorECTypeMaxRunningJobs = CreatorECTypeDefaultConf.getCreatorECTypeMaxRunningJobs(creatorName, ecType);
        if (this.logger().isDebugEnabled()) {
            this.logger().debug(new StringBuilder(67).append("Creator: ").append(creatorName).append(" EC:").append(ecType).append(" there are currently:").append(creatorRunningJobNum.elem).append(" jobs running and maximum limit: ").append(creatorECTypeMaxRunningJobs).toString());
        }
        if (creatorRunningJobNum.elem > creatorECTypeMaxRunningJobs) {
            this.logger().error(new StringBuilder(80).append("Creator: ").append(creatorName).append(" EC:").append(ecType).append(" there are currently:").append(creatorRunningJobNum.elem).append("  jobs running that exceed the maximum limit: ").append(creatorECTypeMaxRunningJobs).toString());
            return false;
        }
        return true;
    }

    public static final /* synthetic */ void $anonfun$runScheduleIntercept$1(String creatorName$1, String ecType$1, IntRef creatorRunningJobNum$1, Consumer consumer) {
        String groupName = consumer.getGroup().getGroupName();
        if (groupName.startsWith(creatorName$1) && groupName.endsWith(ecType$1)) {
            creatorRunningJobNum$1.elem += consumer.getRunningEvents().length;
            return;
        }
    }

    public EntranceFIFOUserConsumer(SchedulerContext schedulerContext, ExecutorService executeService, Group group) {
        this.schedulerContext = schedulerContext;
        this.group = group;
        super(schedulerContext, executeService, group);
    }
}

