/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.scheduler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.errorcode.EntranceErrorCodeSummary;
import org.apache.linkis.entrance.exception.EntranceErrorCode;
import org.apache.linkis.entrance.exception.EntranceErrorException;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.scheduler.EntranceGroupFactory$;
import org.apache.linkis.entrance.utils.EntranceUtils$;
import org.apache.linkis.governance.common.protocol.conf.RequestQueryEngineConfigWithGlobalConfig;
import org.apache.linkis.governance.common.protocol.conf.RequestQueryEngineConfigWithGlobalConfig$;
import org.apache.linkis.governance.common.protocol.conf.ResponseQueryConfig;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.scheduler.queue.Group;
import org.apache.linkis.scheduler.queue.GroupFactory;
import org.apache.linkis.scheduler.queue.SchedulerEvent;
import org.apache.linkis.scheduler.queue.parallelqueue.ParallelGroup;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u000b\u0017\u0001\u0005BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013%a\u0007\u0003\u0004S\u0001\u0001\u0006Ia\u000e\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0011\u0019y\u0006\u0001)A\u0005+\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007B\u00026\u0001A\u0003%!\rC\u0004l\u0001\t\u0007I\u0011\u0002+\t\r1\u0004\u0001\u0015!\u0003V\u0011\u001di\u0007A1A\u0005\nQCaA\u001c\u0001!\u0002\u0013)\u0006bB8\u0001\u0005\u0004%I\u0001\u001d\u0005\u0007s\u0002\u0001\u000b\u0011B9\t\u000bi\u0004A\u0011I>\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u00111\u0002\u0001\u0005\n\u00055qaBA\u000e-!\u0005\u0011Q\u0004\u0004\u0007+YA\t!a\b\t\rE\u0012B\u0011AA\u0014\u0011\u001d\tIC\u0005C\u0001\u0003W\u0011A#\u00128ue\u0006t7-Z$s_V\u0004h)Y2u_JL(BA\f\u0019\u0003%\u00198\r[3ek2,'O\u0003\u0002\u001a5\u0005AQM\u001c;sC:\u001cWM\u0003\u0002\u001c9\u00051A.\u001b8lSNT!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011c\u0001\u0001#SA\u00111eJ\u0007\u0002I)\u0011QEJ\u0001\u0006cV,W/\u001a\u0006\u0003/iI!\u0001\u000b\u0013\u0003\u0019\u001d\u0013x.\u001e9GC\u000e$xN]=\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013!B;uS2\u001c(B\u0001\u0018\u001b\u0003\u0019\u0019w.\\7p]&\u0011\u0001g\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u00025\u00015\ta#A\the>,\bOT1nKR{wI]8vaN,\u0012a\u000e\t\u0005q\u0001\u0013u*D\u0001:\u0015\tQ4(A\u0003dC\u000eDWM\u0003\u0002/y)\u0011QHP\u0001\u0007O>|w\r\\3\u000b\u0003}\n1aY8n\u0013\t\t\u0015HA\u0003DC\u000eDW\r\u0005\u0002D\u0019:\u0011AI\u0013\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u0002\na\u0001\u0010:p_Rt$\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C\u0015A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!a\u0013%\u0011\u0005\r\u0002\u0016BA)%\u0005\u00159%o\\;q\u0003I9'o\\;q\u001d\u0006lW\rV8He>,\bo\u001d\u0011\u0002%\u001d\u0013v*\u0016)`\u001b\u0006CvlQ!Q\u0003\u000eKE+W\u000b\u0002+B\u0019a+W.\u000e\u0003]S!\u0001W\u0017\u0002\t\r|gNZ\u0005\u00035^\u0013!bQ8n[>tg+\u0019:t!\taV,D\u0001I\u0013\tq\u0006JA\u0002J]R\f1c\u0012*P+B{V*\u0011-`\u0007\u0006\u0003\u0016iQ%U3\u0002\n\u0001d\u0015)F\u0007&3\u0015*\u0012#`+N+%KT!N\u000b~\u0013ViR#Y+\u0005\u0011\u0007c\u0001,ZGB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\u0005Y\u0006twMC\u0001i\u0003\u0011Q\u0017M^1\n\u00055+\u0017!G*Q\u000b\u000eKe)S#E?V\u001bVI\u0015(B\u001b\u0016{&+R$F1\u0002\n\u0011e\u0012*P+B{6\u000bU#D\u0013\u001aKU\tR0V'\u0016\u0013v,T!Y?\u000e\u000b\u0005+Q\"J)f\u000b!e\u0012*P+B{6\u000bU#D\u0013\u001aKU\tR0V'\u0016\u0013v,T!Y?\u000e\u000b\u0005+Q\"J)f\u0003\u0013aE$S\u001fV\u0003v,\u0013(J)~\u001b\u0015\tU!D\u0013RK\u0016\u0001F$S\u001fV\u0003v,\u0013(J)~\u001b\u0015\tU!D\u0013RK\u0006%A\u000fta\u0016\u001c\u0017NZ5fIV\u001bXM\u001d8b[\u0016\u0014VmZ3y!\u0006$H/\u001a:o+\u0005\t\bC\u0001:x\u001b\u0005\u0019(B\u0001;v\u0003\u0015\u0011XmZ3y\u0015\t1x-\u0001\u0003vi&d\u0017B\u0001=t\u0005\u001d\u0001\u0016\r\u001e;fe:\fad\u001d9fG&4\u0017.\u001a3Vg\u0016\u0014h.Y7f%\u0016<W\r\u001f)biR,'O\u001c\u0011\u0002!\u001d,Go\u0014:De\u0016\fG/Z$s_V\u0004HCA(}\u0011\u0015ih\u00021\u0001\u007f\u0003\u0015)g/\u001a8u!\t\u0019s0C\u0002\u0002\u0002\u0011\u0012abU2iK\u0012,H.\u001a:Fm\u0016tG/\u0001\u0005hKR<%o\\;q)\ry\u0015q\u0001\u0005\u0007\u0003\u0013y\u0001\u0019\u0001\"\u0002\u0013\u001d\u0014x.\u001e9OC6,\u0017!F4fiV\u001bXM]'bqJ+hN\\5oO*{'m\u001d\u000b\u00047\u0006=\u0001bBA\t!\u0001\u0007\u00111C\u0001\fW\u0016L\u0018I\u001c3WC2,X\r\u0005\u0004\u0002\u0016\u0005]!IQ\u0007\u0002k&\u0019\u0011\u0011D;\u0003\u00075\u000b\u0007/\u0001\u000bF]R\u0014\u0018M\\2f\u000fJ|W\u000f\u001d$bGR|'/\u001f\t\u0003iI\u00192AEA\u0011!\ra\u00161E\u0005\u0004\u0003KA%AB!osJ+g\r\u0006\u0002\u0002\u001e\u0005!r-\u001a;He>,\bOT1nK\nKH*\u00192fYN$2AQA\u0017\u0011\u001d\ty\u0003\u0006a\u0001\u0003c\ta\u0001\\1cK2\u001c\bCBA\u000b\u0003g\t9$C\u0002\u00026U\u0014A\u0001T5tiB\"\u0011\u0011HA)!\u0019\tY$!\u0013\u0002N5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0004f]RLG/\u001f\u0006\u0005\u0003\u0007\n)%A\u0003mC\n,GNC\u0002\u0002Hi\tq!\\1oC\u001e,'/\u0003\u0003\u0002L\u0005u\"!\u0002'bE\u0016d\u0007\u0003BA(\u0003#b\u0001\u0001\u0002\u0007\u0002T\u00055\u0012\u0011!A\u0001\u0006\u0003\t)FA\u0002`IE\nB!a\u0016\u0002^A\u0019A,!\u0017\n\u0007\u0005m\u0003JA\u0004O_RD\u0017N\\4\u0011\u0007q\u000by&C\u0002\u0002b!\u00131!\u00118z\u0001")
public class EntranceGroupFactory
extends GroupFactory
implements Logging {
    private final Cache<String, Group> groupNameToGroups;
    private final CommonVars<Object> GROUP_MAX_CAPACITY;
    private final CommonVars<String> SPECIFIED_USERNAME_REGEX;
    private final CommonVars<Object> GROUP_SPECIFIED_USER_MAX_CAPACITY;
    private final CommonVars<Object> GROUP_INIT_CAPACITY;
    private final Pattern specifiedUsernameRegexPattern;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static String getGroupNameByLabels(List<Label<?>> list) {
        return EntranceGroupFactory$.MODULE$.getGroupNameByLabels(list);
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        EntranceGroupFactory entranceGroupFactory = this;
        synchronized (entranceGroupFactory) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Cache<String, Group> groupNameToGroups() {
        return this.groupNameToGroups;
    }

    private CommonVars<Object> GROUP_MAX_CAPACITY() {
        return this.GROUP_MAX_CAPACITY;
    }

    private CommonVars<String> SPECIFIED_USERNAME_REGEX() {
        return this.SPECIFIED_USERNAME_REGEX;
    }

    private CommonVars<Object> GROUP_SPECIFIED_USER_MAX_CAPACITY() {
        return this.GROUP_SPECIFIED_USER_MAX_CAPACITY;
    }

    private CommonVars<Object> GROUP_INIT_CAPACITY() {
        return this.GROUP_INIT_CAPACITY;
    }

    private Pattern specifiedUsernameRegexPattern() {
        return this.specifiedUsernameRegexPattern;
    }

    public Group getOrCreateGroup(SchedulerEvent event) {
        SchedulerEvent schedulerEvent = event;
        if (!(schedulerEvent instanceof EntranceJob)) {
            throw new EntranceErrorException(EntranceErrorCodeSummary.LABEL_NOT_NULL.getErrorCode(), EntranceErrorCodeSummary.LABEL_NOT_NULL.getErrorDesc());
        }
        EntranceJob entranceJob = (EntranceJob)schedulerEvent;
        List labels = entranceJob.getJobRequest().getLabels();
        String groupName = EntranceGroupFactory$.MODULE$.getGroupNameByLabels(labels);
        Group cacheGroup = (Group)this.groupNameToGroups().getIfPresent((Object)groupName);
        if (cacheGroup == null) {
            ParallelGroup parallelGroup;
            EntranceGroupFactory entranceGroupFactory = this;
            synchronized (entranceGroupFactory) {
                int n;
                long maxAskExecutorTimes = ((TimeType)EntranceConfiguration$.MODULE$.MAX_ASK_EXECUTOR_TIME().getValue()).toLong();
                Sender sender = Sender$.MODULE$.getSender((String)Configuration$.MODULE$.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME().getValue());
                UserCreatorLabel userCreatorLabel = LabelUtil$.MODULE$.getUserCreatorLabel(labels);
                EngineTypeLabel engineTypeLabel = LabelUtil$.MODULE$.getEngineTypeLabel(labels);
                this.logger().info(new StringBuilder(70).append("Getting user configurations for ").append(groupName).append(" userCreatorLabel: ").append(userCreatorLabel.getStringValue()).append(", engineTypeLabel:").append(engineTypeLabel.getStringValue()).append(".").toString());
                Map keyAndValue = (Map)Utils$.MODULE$.tryAndWarnMsg((Function0 & Serializable & scala.Serializable)() -> ((ResponseQueryConfig)sender.ask((Object)new RequestQueryEngineConfigWithGlobalConfig(userCreatorLabel, engineTypeLabel, RequestQueryEngineConfigWithGlobalConfig$.MODULE$.apply$default$3()))).getKeyAndValue(), "Get user configurations from configuration server failed! Next use the default value to continue.", this.logger());
                int maxRunningJobs = this.getUserMaxRunningJobs(keyAndValue);
                int initCapacity = BoxesRunTime.unboxToInt((Object)this.GROUP_INIT_CAPACITY().getValue(keyAndValue));
                if (this.specifiedUsernameRegexPattern() != null) {
                    if (this.specifiedUsernameRegexPattern().matcher(userCreatorLabel.getUser()).find()) {
                        this.logger().info(new StringBuilder(51).append("Set maxCapacity of user ").append(userCreatorLabel.getUser()).append(" to specifiedMaxCapacity : ").append(this.GROUP_SPECIFIED_USER_MAX_CAPACITY().getValue(keyAndValue)).toString());
                        n = BoxesRunTime.unboxToInt((Object)this.GROUP_SPECIFIED_USER_MAX_CAPACITY().getValue(keyAndValue));
                    } else {
                        n = BoxesRunTime.unboxToInt((Object)this.GROUP_MAX_CAPACITY().getValue(keyAndValue));
                    }
                } else {
                    n = BoxesRunTime.unboxToInt((Object)this.GROUP_MAX_CAPACITY().getValue(keyAndValue));
                }
                int maxCapacity = n;
                this.logger().info(new StringBuilder(82).append("Got user configurations: groupName=").append(groupName).append(", maxRunningJobs=").append(maxRunningJobs).append(", initCapacity=").append(initCapacity).append(", maxCapacity=").append(maxCapacity).append(".").toString());
                ParallelGroup group = new ParallelGroup(groupName, initCapacity, maxCapacity);
                group.setMaxRunningJobs(maxRunningJobs);
                group.setMaxAskExecutorTimes(maxAskExecutorTimes);
                this.groupNameToGroups().put((Object)groupName, (Object)group);
                parallelGroup = group;
            }
            return parallelGroup;
        }
        return cacheGroup;
    }

    public Group getGroup(String groupName) {
        Group group = (Group)this.groupNameToGroups().getIfPresent((Object)groupName);
        if (group == null) {
            throw new EntranceErrorException(EntranceErrorCode.GROUP_NOT_FOUND.getErrCode(), new StringBuilder(17).append("group not found: ").append(groupName).toString());
        }
        return group;
    }

    private int getUserMaxRunningJobs(Map<String, String> keyAndValue) {
        int userDefinedRunningJobs = BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.WDS_LINKIS_INSTANCE().getValue(keyAndValue));
        int entranceNum = EntranceUtils$.MODULE$.getRunningEntranceNumber();
        return Math.max(BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.ENTRANCE_INSTANCE_MIN().getValue()), userDefinedRunningJobs / entranceNum);
    }

    public EntranceGroupFactory() {
        Logging.$init$((Logging)this);
        this.groupNameToGroups = CacheBuilder.newBuilder().expireAfterAccess((long)BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.GROUP_CACHE_EXPIRE_TIME().getValue()), TimeUnit.MINUTES).maximumSize((long)BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.GROUP_CACHE_MAX().getValue())).build();
        this.GROUP_MAX_CAPACITY = CommonVars$.MODULE$.apply("wds.linkis.entrance.max.capacity", (Object)BoxesRunTime.boxToInteger((int)1000));
        this.SPECIFIED_USERNAME_REGEX = CommonVars$.MODULE$.apply("wds.linkis.entrance.specified.username.regex", (Object)"hduser.*");
        this.GROUP_SPECIFIED_USER_MAX_CAPACITY = CommonVars$.MODULE$.apply("wds.linkis.entrance.specified.max.capacity", (Object)BoxesRunTime.boxToInteger((int)5000));
        this.GROUP_INIT_CAPACITY = CommonVars$.MODULE$.apply("wds.linkis.entrance.init.capacity", (Object)BoxesRunTime.boxToInteger((int)100));
        this.specifiedUsernameRegexPattern = StringUtils.isNotBlank((CharSequence)((CharSequence)this.SPECIFIED_USERNAME_REGEX().getValue())) ? Pattern.compile((String)this.SPECIFIED_USERNAME_REGEX().getValue()) : null;
    }
}

