/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.command.parser;

import java.util.Arrays;
import org.apache.linkis.cli.application.entity.command.CmdTemplate;
import org.apache.linkis.cli.application.entity.command.Params;
import org.apache.linkis.cli.application.exception.CommandException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.command.fitter.FitterResult;
import org.apache.linkis.cli.application.interactor.command.parser.AbstarctParser;
import org.apache.linkis.cli.application.interactor.command.parser.result.ParseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleCmdParser
extends AbstarctParser {
    private static final Logger logger = LoggerFactory.getLogger(SingleCmdParser.class);

    @Override
    public ParseResult parse(String[] input) {
        this.checkInit();
        if (input == null || input.length == 0) {
            throw new CommandException("CMD0015", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, this.template.getCmdType(), "nothing to parse");
        }
        FitterResult result = this.fitter.fit(input, this.template);
        Object[] remains = result.getRemains();
        if (remains != null && remains.length != 0) {
            throw new CommandException("CMD0022", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, this.template.getCmdType(), "Cannot parse argument(s): " + Arrays.toString(remains) + ". Please check help message");
        }
        CmdTemplate parsedTemplate = result.getParsedTemplate();
        Params param = this.templateToParams(parsedTemplate, this.mapper);
        return new ParseResult(parsedTemplate, param, (String[])remains);
    }
}

