/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.command.parser.transformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.exception.CommandException;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.utils.CliUtils;

public abstract class ParamKeyMapper {
    protected Map<String, String> mapperRules;

    public ParamKeyMapper() {
        this.mapperRules = new HashMap<String, String>();
        this.initMapperRules();
    }

    public ParamKeyMapper(Map<String, String> mapperRules) {
        this.initMapperRules(new HashMap<String, String>());
    }

    public abstract void initMapperRules();

    public void initMapperRules(Map<String, String> mapperRules) {
        this.mapperRules = mapperRules;
    }

    public void updateMapping(String key, String targetKey) {
        if (this.mapperRules.containsKey(key)) {
            throw new CommandException("CMD0020", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, "ParamMapper should not map different keys into same key. Key is: " + targetKey);
        }
        this.mapperRules.put(key, targetKey);
    }

    private void updateMappingbyConfig(String kvString) {
        if (StringUtils.isNotBlank((CharSequence)kvString)) {
            Map<String, String> result = CliUtils.parseKVStringToMap(kvString, ",");
            this.mapperRules.putAll(result);
        }
    }

    public <T> Map<String, T> getMappedMapping(Map<String, T> paramMap) throws LinkisClientRuntimeException {
        HashMap<String, T> resultMap = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : paramMap.entrySet()) {
            String targetKey = this.getMappedKey(entry.getKey());
            if (resultMap.containsKey(targetKey)) {
                throw new CommandException("CMD0020", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, "ParamMapper should not map different keys into same key. Key is: " + targetKey);
            }
            resultMap.put(targetKey, entry.getValue());
        }
        return resultMap;
    }

    public String getMappedKey(String paramKey) {
        if (this.mapperRules.containsKey(paramKey)) {
            return this.mapperRules.get(paramKey);
        }
        return paramKey;
    }
}

