/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.command.template;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.linkis.cli.application.entity.command.CmdOption;
import org.apache.linkis.cli.application.entity.command.CmdTemplate;
import org.apache.linkis.cli.application.entity.command.CmdType;
import org.apache.linkis.cli.application.exception.CommandException;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.command.SpecialMap;
import org.apache.linkis.cli.application.interactor.command.template.converter.AbstractStringConverter;
import org.apache.linkis.cli.application.interactor.command.template.converter.PredefinedStringConverters;
import org.apache.linkis.cli.application.interactor.command.template.option.BaseOption;
import org.apache.linkis.cli.application.interactor.command.template.option.Flag;
import org.apache.linkis.cli.application.interactor.command.template.option.MapOption;
import org.apache.linkis.cli.application.interactor.command.template.option.Parameter;
import org.apache.linkis.cli.application.interactor.command.template.option.SpecialMapOption;
import org.apache.linkis.cli.application.interactor.command.template.option.StdOption;

public abstract class AbstractCmdTemplate
implements CmdTemplate,
Cloneable {
    protected CmdType cmdType;
    protected List<CmdOption<?>> options;
    protected Map<String, CmdOption<?>> optionsMap;

    public AbstractCmdTemplate(CmdType cmdType) {
        this.cmdType = cmdType;
        this.options = new ArrayList();
        this.optionsMap = new HashMap();
    }

    protected final Parameter<String> parameter(String keyPrefix, String key, String paramName, String description, boolean isOptional, String defaultValue) {
        return this.parameter(keyPrefix, key, paramName, description, isOptional, PredefinedStringConverters.NO_CONVERTER, defaultValue);
    }

    protected final Parameter<Integer> parameter(String keyPrefix, String key, String paramName, String description, boolean isOptional, Integer defaultValue) {
        return this.parameter(keyPrefix, key, paramName, description, isOptional, PredefinedStringConverters.INT_CONVERTER, defaultValue);
    }

    protected final Parameter<String[]> parameter(String keyPrefix, String key, String paramName, String description, boolean isOptional, String[] defaultValue) {
        return this.parameter(keyPrefix, key, paramName, description, isOptional, PredefinedStringConverters.STR_ARRAY_CONVERTER, defaultValue);
    }

    protected final <T> Parameter<T> parameter(String keyPrefix, String key, String paramName, String description, boolean isOptional, AbstractStringConverter<T> converter, T defaultValue) {
        Parameter<T> parameter = new Parameter<T>(keyPrefix, key, paramName, description, isOptional, converter, defaultValue);
        this.options.add(parameter);
        return parameter;
    }

    protected final Flag flag(String keyPrefix, String key, String[] paramName, String description, boolean defaultValue) {
        return this.flag(keyPrefix, key, paramName, description, false, defaultValue);
    }

    protected final Flag flag(String keyPrefix, String key, String[] paramName, String description, boolean isOptional, boolean defaultValue) {
        this.checkIllegalOption(paramName);
        Flag flag = new Flag(keyPrefix, key, paramName, description, isOptional, defaultValue);
        this.putOption(paramName, flag);
        return flag;
    }

    protected final StdOption<String> option(String keyPrefix, String key, String[] paramName, String description, boolean isOptional) {
        return this.option(keyPrefix, key, paramName, description, isOptional, null, PredefinedStringConverters.NO_CONVERTER);
    }

    protected final StdOption<String> option(String keyPrefix, String key, String[] paramName, String description, boolean isOptional, String defaultValue) {
        return this.option(keyPrefix, key, paramName, description, isOptional, defaultValue, PredefinedStringConverters.NO_CONVERTER);
    }

    protected final StdOption<String[]> option(String keyPrefix, String key, String[] paramName, String description, boolean isOptional, String[] defaultValue) {
        return this.option(keyPrefix, key, paramName, description, isOptional, defaultValue, PredefinedStringConverters.STR_ARRAY_CONVERTER);
    }

    protected final StdOption<Integer> option(String keyPrefix, String key, String[] paramName, String description, boolean isOptional, Integer defaultValue) {
        return this.option(keyPrefix, key, paramName, description, isOptional, defaultValue, PredefinedStringConverters.INT_CONVERTER);
    }

    protected final StdOption<Boolean> option(String keyPrefix, String key, String[] paramName, String description, boolean isOptional, Boolean defaultValue) {
        return this.option(keyPrefix, key, paramName, description, isOptional, defaultValue, PredefinedStringConverters.BOOLEAN_CONVERTER);
    }

    protected final StdOption<Map<String, String>> option(String keyPrefix, String key, String[] paramName, String description, boolean isOptional, Map<String, String> defaultValue) {
        return this.option(keyPrefix, key, paramName, description, isOptional, defaultValue, PredefinedStringConverters.STRING_MAP_CONVERTER);
    }

    protected final StdOption<SpecialMap<String, String>> option(String keyPrefix, String key, String[] paramName, String description, boolean isOptional, SpecialMap<String, String> defaultValue) {
        return this.option(keyPrefix, key, paramName, description, isOptional, defaultValue, PredefinedStringConverters.STRING_SPECIAL_MAP_CONVERTER);
    }

    protected final <T> StdOption<T> option(String keyPrefix, String key, String[] paramName, String description, boolean isOptional, T defaultValue, AbstractStringConverter<T> converter) {
        this.checkIllegalOption(paramName);
        StdOption<T> stdOption = new StdOption<T>(keyPrefix, key, paramName, description, isOptional, defaultValue, converter);
        this.putOption(paramName, stdOption);
        return stdOption;
    }

    protected final MapOption mapOption(String keyPrefix, String key, String[] paramName, String description, boolean isOptional) {
        this.checkIllegalOption(paramName);
        MapOption option = new MapOption(keyPrefix, key, paramName, description, isOptional);
        this.putOption(paramName, option);
        return option;
    }

    protected final SpecialMapOption speciaMapOption(String keyPrefix, String key, String[] paramName, String description, boolean isOptional) {
        this.checkIllegalOption(paramName);
        SpecialMapOption option = new SpecialMapOption(keyPrefix, key, paramName, description, isOptional);
        this.putOption(paramName, option);
        return option;
    }

    private void checkIllegalOption(String[] names) {
        if (names == null || names.length <= 0) {
            throw new IllegalArgumentException("At least one cmdType should be given to CmdOption.");
        }
        if (names.length > 10) {
            throw new IllegalArgumentException("At most 10 cmdType can be given to CmdOption.");
        }
        for (String name : names) {
            if (name.startsWith("-")) continue;
            throw new IllegalArgumentException(name + " should starts with '-'.");
        }
    }

    private void putOption(String[] names, CmdOption<?> option) {
        this.options.add(option);
        for (String name : names) {
            this.optionsMap.put(name, option);
        }
    }

    @Override
    public CmdType getCmdType() {
        return this.cmdType;
    }

    @Override
    public List<CmdOption<?>> getOptions() {
        return this.options;
    }

    @Override
    public Map<String, CmdOption<?>> getOptionsMap() {
        return this.optionsMap;
    }

    @Override
    public abstract void checkParams() throws LinkisClientRuntimeException;

    protected Object clone() throws CloneNotSupportedException {
        AbstractCmdTemplate ret = (AbstractCmdTemplate)super.clone();
        HashMap tmpMap = new HashMap();
        for (Map.Entry<String, CmdOption<?>> entry : this.optionsMap.entrySet()) {
            String key = entry.getValue().getKey();
            if (!tmpMap.containsKey(key)) {
                tmpMap.put(key, new ArrayList());
            }
            ((List)tmpMap.get(key)).add(entry.getKey());
        }
        ret.options = new ArrayList();
        ret.optionsMap = new HashMap();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = ret.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fields.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        for (Field field : fields) {
            Object fieldObj;
            field.setAccessible(true);
            try {
                fieldObj = field.get(ret);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new CommandException("CMD0018", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, "failed to make deep copy of template: " + this.getCmdType(), e);
            }
            if (fieldObj instanceof StdOption || fieldObj instanceof MapOption || fieldObj instanceof SpecialMapOption) {
                CmdOption opt = ((CmdOption)fieldObj).clone();
                try {
                    field.set(ret, opt);
                }
                catch (Exception e) {
                    throw new CommandException("CMD0018", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, "failed to make deep copy of template: " + this.getCmdType(), e);
                }
                ret.options.add(opt);
                List paraNames = (List)tmpMap.get(opt.getKey());
                for (String paraName : paraNames) {
                    ret.optionsMap.put(paraName, opt);
                }
                continue;
            }
            if (!(fieldObj instanceof Parameter)) continue;
            BaseOption param = ((Parameter)fieldObj).clone();
            try {
                field.set(ret, param);
            }
            catch (Exception e) {
                throw new CommandException("CMD0018", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, "failed to make deep copy of template: " + this.getCmdType(), e);
            }
            ret.options.add(param);
        }
        return ret;
    }

    @Override
    public AbstractCmdTemplate getCopy() {
        AbstractCmdTemplate ret;
        try {
            ret = (AbstractCmdTemplate)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CommandException("CMD0018", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ParserParseErr, "failed to make deep copy of template: " + this.getCmdType(), e);
        }
        return ret;
    }
}

