/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.command.template;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.exception.CommandException;
import org.apache.linkis.cli.application.exception.ValidateException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.command.CliCmdType;
import org.apache.linkis.cli.application.interactor.command.template.AbstractCmdTemplate;
import org.apache.linkis.cli.application.interactor.command.template.option.Flag;
import org.apache.linkis.cli.application.interactor.command.template.option.MapOption;
import org.apache.linkis.cli.application.interactor.command.template.option.Parameter;
import org.apache.linkis.cli.application.interactor.command.template.option.SpecialMapOption;
import org.apache.linkis.cli.application.interactor.command.template.option.StdOption;

public class UniversalCmdTemplate
extends AbstractCmdTemplate
implements Cloneable {
    protected StdOption<String> gatewayUrl = this.option("wds.linkis.client.common", "wds.linkis.client.common.gatewayUrl", new String[]{"--gatewayUrl"}, "specify linkis gateway url", true, "");
    protected StdOption<String> authenticatationStrategy = this.option("wds.linkis.client.common", "wds.linkis.client.common.authStrategy", new String[]{"--authStg"}, "specify linkis authentication strategy", true, "");
    protected StdOption<String> authKey = this.option("wds.linkis.client.common", "wds.linkis.client.common.tokenKey", new String[]{"--authKey"}, "specify linkis authentication key(tokenKey)", true, "");
    protected StdOption<String> authValue = this.option("wds.linkis.client.common", "wds.linkis.client.common.tokenValue", new String[]{"--authVal"}, "specify linkis authentication value(tokenValue)", true, "");
    protected StdOption<String> userConfigPath = this.option("wds.linkis.client.common", "wds.linkis.client.common.user.conf", new String[]{"--userConf"}, "specify user configuration file path(absolute)", true, "");
    protected StdOption<String> killOpt = this.option("wds.linkis.client.common", "wds.linkis.client.common.kill", new String[]{"--kill"}, "specify linkis taskId for job to be killed", true, "");
    protected StdOption<String> logOpt = this.option("wds.linkis.client.common", "wds.linkis.client.common.log", new String[]{"--log"}, "specify linkis taskId for querying job status", true, "");
    protected StdOption<String> resultOpt = this.option("wds.linkis.client.common", "wds.linkis.client.common.result", new String[]{"--result"}, "specify linkis taskId for querying job status", true, "");
    protected StdOption<String> statusOpt = this.option("wds.linkis.client.common", "wds.linkis.client.common.status", new String[]{"--status"}, "specify linkis taskId for querying job status", true, "");
    protected StdOption<Boolean> asyncOpt = this.option("wds.linkis.client.common", "wds.linkis.client.common.async.submit", new String[]{"--async"}, "specify linkis taskId for querying job status", true, false);
    protected StdOption<String> modeOpt = this.option("wds.linkis.client.common", "wds.linkis.client.common.mode", new String[]{"--mode"}, "specify linkis execution mode: ujes/once.", true, "ujes");
    protected Flag helpOpt = this.flag("wds.linkis.client.common", "wds.linkis.client.common.help", new String[]{"--help"}, "specify linkis taskId for querying job status", true, false);
    protected StdOption<String> clusterOP = this.option("wds.linkis.client.label", "wds.linkis.client.label.yarnCluster", new String[]{"-yarnCluster", "-k8sCluster"}, "specify linkis yarn cluster for this job", true, "");
    protected StdOption<String> engineTypeOP = this.option("wds.linkis.client.label", "wds.linkis.client.label.engineType", new String[]{"-engineType"}, "specify linkis engineType for this job", true, "");
    protected StdOption<String> codeTypeOp = this.option("wds.linkis.client.label", "wds.linkis.client.label.codeType", new String[]{"-codeType"}, "specify linkis runType for this job", true, "");
    protected StdOption<String> codePathOp = this.option("wds.linkis.client.common", "wds.linkis.client.common.code.path", new String[]{"-codePath"}, "specify file path that contains code you want to execute", true, "");
    protected StdOption<String> codeOp = this.option("wds.linkis.client.exec", "wds.linkis.client.exec.code", new String[]{"-code"}, "specify code that you want to execute", true, "");
    protected StdOption<String> scriptPathOp = this.option("wds.linkis.client.source", "wds.linkis.client.source.scriptPath", new String[]{"-scriptPath"}, "specify remote path for your uploaded script", true, "");
    protected StdOption<String> submitUser = this.option("wds.linkis.client.common", "wds.linkis.client.common.submitUser", new String[]{"-submitUser"}, "specify submit user for this job", true, "");
    protected StdOption<String> proxyUser = this.option("wds.linkis.client.common", "wds.linkis.client.common.proxyUser", new String[]{"-proxyUser"}, "specify proxy user who executes your code in Linkis server-side", true, "");
    protected StdOption<String> creatorOp = this.option("wds.linkis.client.common", "wds.linkis.client.common.creator", new String[]{"-creator"}, "specify creator for this job", true, "");
    protected StdOption<String> outPathOp = this.option("wds.linkis.client.common", "wds.linkis.client.common.output.path", new String[]{"-outPath"}, "specify output path for resultSet. If not specified, then output reset to screen(stdout)", true, "");
    protected MapOption confMapOp = this.mapOption("wds.linkis.client.param.conf", "wds.linkis.client.param.conf", new String[]{"-confMap"}, "specify configurationMap(startupMap) for your job. You can put any start-up parameters into this Map(e.g. spark.executor.instances). Input format: -confMap key1=value1 -confMap key2=value2", true);
    protected MapOption runtimeMapOp = this.mapOption("wds.linkis.client.param.runtime", "wds.linkis.client.param.runtime", new String[]{"-runtimeMap"}, "specify runtimeMap for your job. You can put any start-up parameters into this Map(e.g. spark.executor.instances). Input format: -runtimeMap key1=value1 -runtimeMap key2=value2", true);
    protected SpecialMapOption varMapOp = this.speciaMapOption("wds.linkis.client.param.var", "wds.linkis.client.param.var", new String[]{"-varMap"}, "specify variables map. Variables is for key-word substitution. Use '${key}' to specify key-word. Input substitution rule as follow: -varMap key1=value1 -varMap key2=value2", true);
    protected MapOption labelMapOp = this.mapOption("wds.linkis.client.label", "wds.linkis.client.label", new String[]{"-labelMap"}, "specify label map. You can put any Linkis into this Map. Input format: -labelMap labelName1=labelValue1 -labelMap labelName2=labelValue2", true);
    protected MapOption sourceMapOp = this.mapOption("wds.linkis.client.source", "wds.linkis.client.source", new String[]{"-sourceMap"}, "specify source map. Input format: -sourceMap key1=value1 -sourceMap key2=value2", true);
    protected MapOption jobContentMapOp = this.mapOption("wds.linkis.client.jobContent", "wds.linkis.client.jobContent", new String[]{"-jobContentMap"}, "specify jobContent map. Input format: -jobContentMap key1=value1 -jobContentMap key2=value2", true);
    protected Flag versionFlag = this.flag("cli.version", "cli.version", new String[]{"--version"}, "show version", true, false);
    protected Parameter<String[]> argumentsParas = this.parameter("wds.linkis.client.common", "wds.linkis.client.common.extraArguments", "arguments", "specify arguments if exist any", true, new String[]{""});

    public UniversalCmdTemplate() {
        super(CliCmdType.UNIVERSAL);
    }

    @Override
    public void checkParams() throws CommandException {
        if (this.versionFlag.hasVal()) {
            return;
        }
        int cnt = 0;
        if (this.statusOpt.hasVal()) {
            ++cnt;
        }
        if (this.killOpt.hasVal()) {
            ++cnt;
        }
        if (this.logOpt.hasVal()) {
            ++cnt;
        }
        if (this.resultOpt.hasVal()) {
            ++cnt;
        }
        if (this.helpOpt.hasVal()) {
            ++cnt;
        }
        if (cnt > 1) {
            throw new ValidateException("VLD0001", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ValidationErr, "Can only specify 1 of: " + this.statusOpt.getParamName() + "/" + this.killOpt.getParamName() + "/" + this.helpOpt.getParamName() + "/");
        }
        if (cnt == 0) {
            int cnt2 = 0;
            if (this.argumentsParas.hasVal()) {
                if (!(this.argumentsParas.getValue() instanceof String[]) || ((String[])this.argumentsParas.getValue()).length == 0) {
                    throw new ValidateException("VLD0001", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ValidationErr, this.argumentsParas.getParamName() + "has raw-value but failed to convert it into String-array. Raw-value: " + this.argumentsParas.getRawVal());
                }
                String firstPara = ((String[])this.argumentsParas.getValue())[0];
                if (StringUtils.startsWith((CharSequence)firstPara, (CharSequence)"-")) {
                    throw new CommandException("CMD0011", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ValidationErr, this.cmdType, "Illegal argument: " + Arrays.toString((Object[])this.argumentsParas.getValue()));
                }
                File file = new File(firstPara);
                if (!file.exists() || !file.isFile()) {
                    throw new ValidateException("VLD0001", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ValidationErr, "Argument: '" + firstPara + "' is not a linkis-cli option. Assume it's script file, but no file named '" + firstPara + "' is found");
                }
                ++cnt2;
            }
            if (this.codeOp.hasVal()) {
                ++cnt2;
            }
            if (this.codePathOp.hasVal()) {
                ++cnt2;
            }
            if (!this.modeOpt.hasVal() || StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)this.modeOpt.getValue()), (CharSequence)"ujes")) {
                if (cnt2 > 1) {
                    throw new ValidateException("VLD0001", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ValidationErr, "Can only specify at most one of linkis-cli option: ''" + this.codeOp.getParamName() + "' or '" + this.codePathOp.getParamName() + "' or 'script-path and script-arguments'");
                }
                if (cnt2 == 0) {
                    throw new ValidateException("VLD0001", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ValidationErr, "Need to specify at least one of linkis-cli option: '" + this.codeOp.getParamName() + "' or '" + this.codePathOp.getParamName() + "' or 'script-path and script-arguments'.");
                }
            }
        }
    }
}

