/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.interactive;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.cli.application.constants.CliConstants;
import org.apache.linkis.cli.application.entity.context.CliCtx;
import org.apache.linkis.cli.application.entity.job.Job;
import org.apache.linkis.cli.application.entity.job.JobResult;
import org.apache.linkis.cli.application.exception.LinkisClientExecutionException;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.job.common.JobKiller;
import org.apache.linkis.cli.application.interactor.job.common.LogRetriever;
import org.apache.linkis.cli.application.interactor.job.common.ResultRetriever;
import org.apache.linkis.cli.application.interactor.job.interactive.InteractiveJobDesc;
import org.apache.linkis.cli.application.interactor.job.interactive.InteractiveJobDescBuilder;
import org.apache.linkis.cli.application.interactor.job.interactive.InteractiveJobResult;
import org.apache.linkis.cli.application.operator.OperManager;
import org.apache.linkis.cli.application.operator.ujes.LinkisJobOper;
import org.apache.linkis.cli.application.operator.ujes.LinkisOperResultAdapter;
import org.apache.linkis.cli.application.present.LogPresenter;
import org.apache.linkis.cli.application.present.ResultPresenter;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractiveJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(InteractiveJob.class);
    private CliCtx ctx;
    private Boolean isAsync = false;
    private LinkisJobOper oper;
    private InteractiveJobDesc desc;
    private String username;
    private String jobId;

    @Override
    public void build(CliCtx ctx) {
        this.ctx = ctx;
        this.isAsync = ctx.getVarAccess().getVarOrDefault(Boolean.class, "wds.linkis.client.common.async.submit", false);
        this.desc = InteractiveJobDescBuilder.build(ctx);
        this.oper = (LinkisJobOper)OperManager.getNew("linkis.oper", ctx);
    }

    @Override
    public JobResult run() {
        StringBuilder infoBuilder = new StringBuilder();
        infoBuilder.append("connecting to linkis gateway:").append(this.oper.getServerUrl());
        LoggerManager.getInformationLogger().info(infoBuilder.toString());
        infoBuilder.setLength(0);
        LinkisOperResultAdapter submitResult = this.oper.submit(this.desc);
        CliUtils.doSleepQuietly(CliConstants.JOB_QUERY_SLEEP_MILLS);
        LinkisOperResultAdapter jobInfoResult = this.oper.queryJobInfo(submitResult.getUser(), submitResult.getJobID());
        this.oper.queryJobStatus(submitResult.getUser(), submitResult.getJobID(), submitResult.getStrongerExecId());
        infoBuilder.setLength(0);
        infoBuilder.append("JobId:").append(submitResult.getJobID()).append(System.lineSeparator()).append("TaskId:").append(submitResult.getJobID()).append(System.lineSeparator()).append("ExecId:").append(submitResult.getStrongerExecId());
        LoggerManager.getPlaintTextLogger().info(infoBuilder.toString());
        infoBuilder.setLength(0);
        if (!jobInfoResult.getJobStatus().isJobSubmitted()) {
            return new InteractiveJobResult(false, "Failed to submit job", new HashMap<String, String>());
        }
        infoBuilder.append("Job is successfully submitted!").append(System.lineSeparator());
        LoggerManager.getInformationLogger().info(infoBuilder.toString());
        infoBuilder.setLength(0);
        this.username = submitResult.getUser();
        this.jobId = submitResult.getJobID();
        if (this.isAsync.booleanValue()) {
            return new InteractiveJobResult(jobInfoResult.getJobStatus().isJobSubmitted(), "Async Submission Success", new HashMap<String, String>());
        }
        CliUtils.doSleepQuietly(2000L);
        LogRetriever logRetriever = new LogRetriever(jobInfoResult.getUser(), jobInfoResult.getJobID(), submitResult.getStrongerExecId(), true, this.oper, new LogPresenter());
        logRetriever.retrieveLogAsync();
        jobInfoResult = this.waitJobComplete(submitResult.getUser(), submitResult.getJobID(), submitResult.getStrongerExecId());
        logRetriever.waitIncLogComplete();
        String outputPath = this.ctx.getVarAccess().getVar(String.class, "wds.linkis.client.common.output.path");
        ResultPresenter presenter = StringUtils.isBlank((CharSequence)outputPath) ? new ResultPresenter() : new ResultPresenter(true, outputPath);
        ResultRetriever resultRetriever = new ResultRetriever(jobInfoResult.getUser(), jobInfoResult.getJobID(), submitResult.getStrongerExecId(), this.oper, presenter);
        JobResult result = this.getResult(jobInfoResult, resultRetriever);
        return result;
    }

    private JobResult getResult(LinkisOperResultAdapter jobInfoResult, ResultRetriever resultRetriever) throws LinkisClientRuntimeException {
        if (!jobInfoResult.getJobStatus().isJobSuccess()) {
            LoggerManager.getInformationLogger().info("Job status is not success but '" + jobInfoResult.getJobStatus() + "'. Will not try to retrieve any Result");
            HashMap<String, String> extraMap = new HashMap<String, String>();
            if (jobInfoResult.getErrCode() != null) {
                extraMap.put("errorCode", String.valueOf(jobInfoResult.getErrCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)jobInfoResult.getErrDesc())) {
                extraMap.put("errorDesc", jobInfoResult.getErrDesc());
            }
            return new InteractiveJobResult(false, "Execute Error!!!", extraMap);
        }
        InteractiveJobResult result = new InteractiveJobResult(true, "Execute Success!!!", new HashMap<String, String>());
        try {
            resultRetriever.retrieveResultSync();
            result.setSuccess(true);
            result.setMessage("execute success!!!");
        }
        catch (LinkisClientExecutionException e) {
            if (e.getCode().equals("EXE0037")) {
                result.setSuccess(true);
                result.setMessage("execute success!!!");
                LoggerManager.getInformationLogger().warn(e.getMessage());
            } else {
                result.setSuccess(false);
                result.setMessage("execute failed!!!\n" + ExceptionUtils.getStackTrace((Throwable)e));
            }
            resultRetriever.setResultFin();
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage("execute failed!!!\n" + ExceptionUtils.getStackTrace((Throwable)e));
            resultRetriever.setResultFin();
        }
        return result;
    }

    private LinkisOperResultAdapter waitJobComplete(String user, String jobId, String execId) throws LinkisClientRuntimeException {
        int retryCnt = 0;
        int MAX_RETRY = 30;
        LinkisOperResultAdapter jobInfoResult = this.oper.queryJobInfo(user, jobId);
        this.oper.queryJobStatus(user, jobId, execId);
        while (!jobInfoResult.getJobStatus().isJobFinishedState()) {
            try {
                jobInfoResult = this.oper.queryJobInfo(user, jobId);
                this.oper.queryJobStatus(jobInfoResult.getUser(), jobInfoResult.getJobID(), execId);
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
                if (++retryCnt >= 30) {
                    throw new LinkisClientExecutionException("EXE0013", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "Cannot get jobStatus from server continuously for {0} seconds. Client aborted! Error message: \n", 150L * CliConstants.JOB_QUERY_SLEEP_MILLS, e);
                }
                CliUtils.doSleepQuietly(5L * CliConstants.JOB_QUERY_SLEEP_MILLS);
                continue;
            }
            retryCnt = 0;
            if (jobInfoResult.getJobStatus().isJobAbnormalStatus()) {
                throw new LinkisClientExecutionException("EXE0006", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "Job is in abnormal status: " + CliUtils.GSON.toJson((Object)jobInfoResult));
            }
            CliUtils.doSleepQuietly(CliConstants.JOB_QUERY_SLEEP_MILLS);
        }
        return jobInfoResult;
    }

    @Override
    public void onDestroy() {
        if (StringUtils.isBlank((CharSequence)this.username) || StringUtils.isBlank((CharSequence)this.jobId)) {
            logger.warn("Failed to kill job username or jobId is blank");
            return;
        }
        if (this.isAsync.booleanValue()) {
            return;
        }
        try {
            new JobKiller(this.oper).doKill(this.username, this.jobId);
        }
        catch (Exception e) {
            logger.error("Failed to kill job", (Throwable)e);
        }
    }
}

