/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.interactive;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.context.CliCtx;
import org.apache.linkis.cli.application.entity.var.VarAccess;
import org.apache.linkis.cli.application.interactor.job.common.KeyParser;
import org.apache.linkis.cli.application.interactor.job.interactive.InteractiveJobDesc;
import org.apache.linkis.cli.application.operator.ujes.LinkisJobOper;
import org.apache.linkis.cli.application.operator.ujes.UJESClientFactory;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.cli.application.utils.LoggerManager;

public class InteractiveJobDescBuilder {
    public static InteractiveJobDesc build(CliCtx ctx) {
        InteractiveJobDesc desc = new InteractiveJobDesc();
        VarAccess stdVarAccess = ctx.getVarAccess();
        Map<String, Object> confMap = stdVarAccess.getVar(Map.class, "wds.linkis.client.param.conf");
        Map<String, Object> runtimeMap = stdVarAccess.getVar(Map.class, "wds.linkis.client.param.runtime");
        Map varMap = stdVarAccess.getVar(Map.class, "wds.linkis.client.param.var");
        Map<String, Object> labelMap = stdVarAccess.getVar(Map.class, "wds.linkis.client.label");
        Map<String, Object> sourceMap = stdVarAccess.getVar(Map.class, "wds.linkis.client.source");
        Map<String, Object> executionMap = stdVarAccess.getVar(Map.class, "wds.linkis.client.exec");
        confMap = confMap == null ? new HashMap() : confMap;
        runtimeMap = runtimeMap == null ? new HashMap() : runtimeMap;
        varMap = varMap == null ? new HashMap() : varMap;
        labelMap = labelMap == null ? new HashMap() : labelMap;
        sourceMap = sourceMap == null ? new HashMap() : sourceMap;
        executionMap = executionMap == null ? new HashMap() : executionMap;
        confMap = KeyParser.removePrefixForKeysInMap(confMap);
        runtimeMap = KeyParser.removePrefixForKeysInMap(runtimeMap);
        labelMap = KeyParser.removePrefixForKeysInMap(labelMap);
        sourceMap = KeyParser.removePrefixForKeysInMap(sourceMap);
        executionMap = KeyParser.removePrefixForKeysInMap(executionMap);
        for (String key : stdVarAccess.getAllVarKeys()) {
            Object val = stdVarAccess.getVar(Object.class, key);
            if (val instanceof Map || val == null) continue;
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.param.conf")) {
                KeyParser.removePrefixAndPutValToMap(confMap, key, val, "wds.linkis.client.param.conf");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.param.var")) {
                KeyParser.removePrefixAndPutValToMap(varMap, key, val, "wds.linkis.client.param.var");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.param.runtime")) {
                KeyParser.removePrefixAndPutValToMap(runtimeMap, key, val, "wds.linkis.client.param.runtime");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.exec")) {
                KeyParser.removePrefixAndPutValToMap(executionMap, key, val, "wds.linkis.client.exec");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.label")) {
                KeyParser.removePrefixAndPutValToMap(labelMap, key, val, "wds.linkis.client.label");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.source")) {
                KeyParser.removePrefixAndPutValToMap(sourceMap, key, val, "wds.linkis.client.source");
                continue;
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.common")) continue;
        }
        Boolean asyncSubmission = stdVarAccess.getVarOrDefault(Boolean.class, "wds.linkis.client.common.async.submit", false);
        String creator = asyncSubmission == false ? stdVarAccess.getVarOrDefault(String.class, "wds.linkis.client.common.creator", "LINKISCLI") : stdVarAccess.getVarOrDefault(String.class, "wds.linkis.client.common.creator", "LINKISCLIASYNC");
        String code = stdVarAccess.getVar(String.class, "wds.linkis.client.exec.code");
        String engineType = stdVarAccess.getVar(String.class, "wds.linkis.client.label.engineType");
        String runType = stdVarAccess.getVar(String.class, "wds.linkis.client.label.codeType");
        String scriptPath = stdVarAccess.getVarOrDefault(String.class, "wds.linkis.client.source.scriptPath", "LinkisCli");
        String osUser = System.getProperty("user.name");
        String[] adminUsers = StringUtils.split((String)"hadoop,root,shangda", (char)',');
        HashSet<String> adminSet = new HashSet<String>();
        for (String admin : adminUsers) {
            adminSet.add(admin);
        }
        String submitUsr = CliUtils.getSubmitUser(stdVarAccess, osUser, adminSet);
        String proxyUsr = CliUtils.getProxyUser(stdVarAccess, submitUsr, adminSet);
        String enableExecuteOnce = stdVarAccess.getVarOrDefault(String.class, "wds.linkis.client.label.executeOnce", "true");
        if (Boolean.parseBoolean(enableExecuteOnce)) {
            labelMap.put("executeOnce", "");
        } else {
            labelMap.remove("executeOnce");
        }
        String codePath = stdVarAccess.getVar(String.class, "wds.linkis.client.common.code.path");
        Object extraArgsObj = stdVarAccess.getVar(Object.class, "wds.linkis.client.common.extraArguments");
        if (extraArgsObj != null && extraArgsObj instanceof String[] && StringUtils.isBlank((CharSequence)code) && StringUtils.isBlank((CharSequence)codePath)) {
            String[] extraArgs = (String[])extraArgsObj;
            codePath = extraArgs[0];
            if (extraArgs.length > 1) {
                runtimeMap.put("extraArguments", Arrays.copyOfRange(extraArgs, 1, extraArgs.length));
            }
        }
        if (StringUtils.isBlank((CharSequence)code) && StringUtils.isNotBlank((CharSequence)codePath)) {
            try {
                code = CliUtils.readFile(codePath);
            }
            catch (Exception e) {
                LoggerManager.getInformationLogger().error("Failed to read file", (Throwable)e);
                throw e;
            }
        }
        executionMap.put("code", code);
        labelMap.put("engineType", engineType);
        labelMap.put("codeType", runType);
        labelMap.put("userCreator", proxyUsr + "-" + creator);
        sourceMap.put("scriptPath", scriptPath);
        if (ctx.getExtraMap().containsKey("cli.version")) {
            sourceMap.put("cli.version", ctx.getExtraMap().get("cli.version"));
        }
        runtimeMap.put("hive.resultset.use.unique.column.names", true);
        desc.setCreator(creator);
        desc.setParamConfMap(confMap);
        desc.setParamRunTimeMap(runtimeMap);
        desc.setParamVarsMap(varMap);
        desc.setLabelMap(labelMap);
        desc.setSourceMap(sourceMap);
        desc.setExecutionMap(executionMap);
        desc.setSubmitUser(submitUsr);
        desc.setProxyUser(proxyUsr);
        return desc;
    }

    public static LinkisJobOper generateOperator(CliCtx ctx) {
        LinkisJobOper linkisJobOperator = new LinkisJobOper();
        linkisJobOperator.setUJESClient(UJESClientFactory.getReusable(ctx.getVarAccess()));
        linkisJobOperator.setServerUrl(ctx.getVarAccess().getVar(String.class, "wds.linkis.client.common.gatewayUrl"));
        return linkisJobOperator;
    }
}

