/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.validate;

import java.text.MessageFormat;
import java.util.List;
import org.apache.linkis.cli.application.entity.command.CmdOption;
import org.apache.linkis.cli.application.entity.command.CmdTemplate;
import org.apache.linkis.cli.application.exception.CommandException;
import org.apache.linkis.cli.application.exception.ValidateException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedTplValidator {
    private static final Logger logger = LoggerFactory.getLogger(ParsedTplValidator.class);

    public void doValidation(CmdTemplate parsedTemplateCopy) throws CommandException {
        String msg = "start validating command \"{0}\", template \"{1}\"";
        logger.info(MessageFormat.format(msg, parsedTemplateCopy.getCmdType().getName(), parsedTemplateCopy.getCmdType()));
        this.checkOptions(parsedTemplateCopy);
        logger.info("Start params-check");
        parsedTemplateCopy.checkParams();
        logger.info("params-check ok.");
    }

    private void checkOptions(CmdTemplate template) throws CommandException {
        List<CmdOption<?>> options = template.getOptions();
        for (CmdOption<?> cmdOption : options) {
            if (cmdOption.hasVal() || cmdOption.isOptional()) continue;
            throw new ValidateException("VLD0003", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ValidationErr, "CmdOption value cannot be empty: paramName:" + cmdOption.getParamName() + "CmdType: " + template.getCmdType());
        }
    }
}

