/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.operator.ujes;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.var.VarAccess;
import org.apache.linkis.cli.application.exception.BuilderException;
import org.apache.linkis.cli.application.exception.LinkisClientExecutionException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.validate.UJESContextValidator;
import org.apache.linkis.cli.application.operator.ujes.UJESClientContext;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.httpclient.authentication.AuthenticationStrategy;
import org.apache.linkis.httpclient.dws.authentication.StaticAuthenticationStrategy;
import org.apache.linkis.httpclient.dws.authentication.TokenAuthenticationStrategy;
import org.apache.linkis.httpclient.dws.config.DWSClientConfig;
import org.apache.linkis.httpclient.dws.config.DWSClientConfigBuilder;
import org.apache.linkis.ujes.client.UJESClient;
import org.apache.linkis.ujes.client.UJESClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UJESClientFactory {
    private static Logger logger = LoggerFactory.getLogger(UJESClientFactory.class);
    private static UJESClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UJESClient getReusable(VarAccess stdVarAccess) {
        if (client != null) return client;
        Class<UJESClientFactory> clazz = UJESClientFactory.class;
        synchronized (UJESClientFactory.class) {
            if (client != null) return client;
            client = UJESClientFactory.getNew(stdVarAccess);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return client;
        }
    }

    public static UJESClient getNew(VarAccess stdVarAccess) {
        try {
            DWSClientConfig config = UJESClientFactory.generateDWSClientConfig(stdVarAccess);
            UJESClientImpl ret = new UJESClientImpl(config);
            logger.info("Linkis ujes client inited.");
            return ret;
        }
        catch (Exception e) {
            throw new LinkisClientExecutionException("EXE0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionInitErr, "Cannot init UJESClient", e);
        }
    }

    public static DWSClientConfig generateDWSClientConfig(VarAccess stdVarAccess) {
        UJESClientContext context = UJESClientFactory.generateContext(stdVarAccess);
        try {
            Object authenticationStrategy = StringUtils.isBlank((CharSequence)context.getAuthenticationStrategyStr()) || !"token".equalsIgnoreCase(context.getAuthenticationStrategyStr()) ? new StaticAuthenticationStrategy() : new TokenAuthenticationStrategy();
            DWSClientConfigBuilder builder = DWSClientConfigBuilder.newBuilder();
            DWSClientConfig config = ((DWSClientConfigBuilder)builder.addServerUrl(context.getGatewayUrl()).connectionTimeout(30000L).discoveryEnabled(false).discoveryFrequency(1L, TimeUnit.MINUTES).loadbalancerEnabled(false).maxConnectionSize(5).retryEnabled(false).readTimeout(context.getReadTimeoutMills().longValue()).setAuthenticationStrategy((AuthenticationStrategy)authenticationStrategy).setAuthTokenKey(context.getTokenKey()).setAuthTokenValue(context.getTokenValue())).setDWSVersion(context.getDwsVersion()).build();
            logger.info("Linkis ujes client inited.");
            return config;
        }
        catch (Exception e) {
            throw new LinkisClientExecutionException("EXE0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionInitErr, "Cannot init DWSClientConfig", e);
        }
    }

    private static UJESClientContext generateContext(VarAccess stdVarAccess) {
        String gatewayUrl = stdVarAccess.getVar(String.class, "wds.linkis.client.common.gatewayUrl");
        if (StringUtils.isBlank((CharSequence)gatewayUrl)) {
            throw new BuilderException("BLD0007", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.BuilderBuildErr, "Cannot build UjesClientDriverContext: gatewayUrl is empty");
        }
        String authKey = stdVarAccess.getVar(String.class, "wds.linkis.client.common.tokenKey");
        String authValue = stdVarAccess.getVar(String.class, "wds.linkis.client.common.tokenValue");
        String authenticationStrategy = stdVarAccess.getVarOrDefault(String.class, "wds.linkis.client.common.authStrategy", "static");
        long connectionTimeout = stdVarAccess.getVarOrDefault(Long.class, "wds.linkis.client.common.connectionTimeout", 30000L);
        boolean discoveryEnabled = stdVarAccess.getVarOrDefault(Boolean.class, "wds.linkis.client.common.discoveryEnabled", false);
        boolean loadBalancerEnabled = stdVarAccess.getVarOrDefault(Boolean.class, "wds.linkis.client.common.loadbalancerEnabled", true);
        int maxConnectionSize = stdVarAccess.getVarOrDefault(Integer.class, "wds.linkis.client.common.maxConnectionSize", 5);
        boolean retryEnabled = stdVarAccess.getVarOrDefault(Boolean.class, "wds.linkis.client.common.retryEnabled", false);
        long readTimeout = stdVarAccess.getVarOrDefault(Long.class, "wds.linkis.client.common.readTimeout", 30000L);
        String dwsVersion = stdVarAccess.getVarOrDefault(String.class, "wds.linkis.client.common.dwsVersion", "v1");
        UJESClientContext context = new UJESClientContext();
        context.setGatewayUrl(gatewayUrl);
        context.setAuthenticationStrategyStr(authenticationStrategy);
        context.setTokenKey(authKey);
        context.setTokenValue(authValue);
        context.setConnectionTimeout(connectionTimeout);
        context.setDiscoveryEnabled(discoveryEnabled);
        context.setLoadBalancerEnabled(loadBalancerEnabled);
        context.setMaxConnectionSize(maxConnectionSize);
        context.setRetryEnabled(retryEnabled);
        context.setReadTimeoutMills(readTimeout);
        context.setDwsVersion(dwsVersion);
        logger.info("==========UJES_CTX============\n" + CliUtils.GSON.toJson((Object)context));
        UJESContextValidator ctxValidator = new UJESContextValidator();
        ctxValidator.doValidation(context);
        return context;
    }
}

