/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.present;

import java.util.ArrayList;
import java.util.List;
import org.apache.linkis.cli.application.entity.command.CmdOption;
import org.apache.linkis.cli.application.entity.command.CmdTemplate;
import org.apache.linkis.cli.application.entity.present.Model;
import org.apache.linkis.cli.application.entity.present.Presenter;
import org.apache.linkis.cli.application.exception.PresenterException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.command.template.option.MapOption;
import org.apache.linkis.cli.application.interactor.command.template.option.Parameter;
import org.apache.linkis.cli.application.interactor.command.template.option.StdOption;
import org.apache.linkis.cli.application.present.model.HelpInfoModel;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpPresenter
implements Presenter {
    private static Logger logger = LoggerFactory.getLogger(HelpPresenter.class);

    @Override
    public void present(Model model) {
        if (!(model instanceof HelpInfoModel)) {
            throw new PresenterException("PST0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PresenterErr, "Input for HelpInfoPresenter is not instance of model");
        }
        HelpInfoModel helpInfoModel = (HelpInfoModel)model;
        String helpInfo = this.getUsage(helpInfoModel.getTemplate());
        LoggerManager.getPlaintTextLogger().info(helpInfo);
    }

    private String getUsage(CmdTemplate template) {
        StringBuilder sb = new StringBuilder();
        List<CmdOption<?>> options = template.getOptions();
        ArrayList stdOptions = new ArrayList();
        ArrayList parameters = new ArrayList();
        ArrayList mapOptions = new ArrayList();
        for (CmdOption<?> cmdOption : options) {
            if (cmdOption instanceof StdOption) {
                stdOptions.add(cmdOption);
                continue;
            }
            if (cmdOption instanceof Parameter) {
                parameters.add(cmdOption);
                continue;
            }
            if (!(cmdOption instanceof MapOption)) continue;
            mapOptions.add(cmdOption);
        }
        sb.append("Usage: ").append(template.getCmdType().getName()).append(options.size() > 0 ? " [OPTIONS] " : " ");
        for (CmdOption<Object> cmdOption : parameters) {
            if (!(cmdOption instanceof Parameter)) continue;
            sb.append(((Parameter)cmdOption).repr()).append(" ");
        }
        if (!"".equals(template.getCmdType().getDesc())) {
            sb.append("\n\t").append(template.getCmdType().getDesc());
        }
        sb.append(options.size() > 0 ? "\nOptions:\n" : "\n");
        for (CmdOption<Object> cmdOption : stdOptions) {
            sb.append(cmdOption.toString()).append("\n");
        }
        sb.append(options.size() > 0 ? "\nMapOptions:\n" : "\n");
        for (CmdOption<Object> cmdOption : mapOptions) {
            sb.append(cmdOption.toString()).append("\n");
        }
        sb.append(parameters.size() > 0 ? "Parameters:\n" : "\n");
        for (CmdOption<Object> cmdOption : parameters) {
            sb.append(cmdOption.toString()).append("\n");
        }
        return sb.toString();
    }
}

