/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.bml.cleaner.dao;

import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.linkis.monitor.bml.cleaner.entity.CleanedResourceVersion;
import org.apache.linkis.monitor.bml.cleaner.entity.ResourceVersion;
import org.apache.linkis.monitor.bml.cleaner.vo.CleanResourceVo;

public interface VersionDao {
    @Select(value={"select resource_id, count(resource_id) as version_count, max(version) as max_version from linkis_ps_bml_resources_version lpbrv where start_time < #{startTime} GROUP BY resource_id HAVING count(resource_id) > #{maxVersionNum} limit #{limitNum}"})
    public List<CleanResourceVo> getAllNeedCleanResource(@Param(value="maxVersionNum") Integer var1, @Param(value="startTime") Date var2, @Param(value="limitNum") int var3);

    @Select(value={"select * from linkis_ps_bml_resources_version where resource_id = #{resourceId} and version < #{minKeepVersion} and version <> 'v000001'"})
    public List<ResourceVersion> getCleanVersionsByResourceId(@Param(value="resourceId") String var1, @Param(value="minKeepVersion") String var2);

    @Insert(value={"insert into linkis_ps_bml_cleaned_resources_version(`resource_id`,`file_md5`,`version`,`size`,`start_byte`, `end_byte`,`resource`,`description`,`start_time`,`end_time`,`client_ip`,`updator`,`enable_flag`,`old_resource`) values(#{resourceId},#{fileMd5},#{version},#{size},#{startByte},#{endByte},#{resource},#{description},#{startTime},#{endTime},#{clientIp},#{updator},#{enableFlag},#{oldResource})"})
    @Options(useGeneratedKeys=true, keyProperty="id")
    public void insertCleanResourceVersion(CleanedResourceVersion var1);

    @Delete(value={"delete from linkis_ps_bml_resources_version where id=#{id}"})
    public void deleteResourceVersionById(@Param(value="id") long var1);

    @Select(value={"select version from linkis_ps_bml_resources_version where resource_id =#{resourceId} and version <= #{maxVersion} order by version desc limit #{keepNum},1"})
    public String getMinKeepVersion(@Param(value="resourceId") String var1, @Param(value="maxVersion") String var2, @Param(value="keepNum") int var3);
}

