/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.contextcache.cache.guava;

import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.listener.EventListener;
import org.apache.linkis.cs.contextcache.cache.csid.ContextIDValue;
import org.apache.linkis.cs.contextcache.cache.csid.impl.ContextIDValueImpl;
import org.apache.linkis.cs.listener.ListenerBus.ContextAsyncListenerBus;
import org.apache.linkis.cs.listener.event.enumeration.OperateType;
import org.apache.linkis.cs.listener.event.impl.DefaultContextIDEvent;
import org.apache.linkis.cs.listener.manager.imp.DefaultContextListenerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ContextIDRemoveListener
implements RemovalListener<String, ContextIDValue> {
    private static final Logger logger = LoggerFactory.getLogger(ContextIDRemoveListener.class);
    ContextAsyncListenerBus listenerBus = DefaultContextListenerManager.getInstance().getContextAsyncListenerBus();

    public void onRemoval(RemovalNotification<String, ContextIDValue> removalNotification) {
        ContextIDValue value = (ContextIDValue)removalNotification.getValue();
        String contextIDStr = (String)removalNotification.getKey();
        if (StringUtils.isBlank((CharSequence)contextIDStr) || null == value || null == value.getContextID()) {
            return;
        }
        this.listenerBus.removeListener((EventListener)((ContextIDValueImpl)value));
        logger.info("Start to remove ContextID({}) from cache", (Object)contextIDStr);
        DefaultContextIDEvent defaultContextIDEvent = new DefaultContextIDEvent();
        defaultContextIDEvent.setContextID(value.getContextKeyValueContext().getContextID());
        defaultContextIDEvent.setOperateType(OperateType.DELETE);
        this.listenerBus.post((Event)defaultContextIDEvent);
        logger.info("Finished to remove ContextID({}) from cache", (Object)contextIDStr);
    }
}

