/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.highavailable;

import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.HAContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.highavailable.AbstractContextHAManager;
import org.apache.linkis.cs.highavailable.exception.CSErrorCode;
import org.apache.linkis.cs.highavailable.ha.BackupInstanceGenerator;
import org.apache.linkis.cs.highavailable.ha.ContextHAChecker;
import org.apache.linkis.cs.highavailable.ha.ContextHAIDGenerator;
import org.apache.linkis.cs.highavailable.proxy.MethodInterceptorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.stereotype.Component;

@Component
public class DefaultContextHAManager
extends AbstractContextHAManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultContextHAManager.class);
    private static final Gson gson = new Gson();
    @Autowired
    private ContextHAIDGenerator contextHAIDGenerator;
    @Autowired
    private ContextHAChecker contextHAChecker;
    @Autowired
    private BackupInstanceGenerator backupInstanceGenerator;

    @Override
    public <T> T getContextHAProxy(T persistence) throws CSErrorException {
        MethodInterceptorImpl callback = new MethodInterceptorImpl(this, persistence);
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(persistence.getClass());
        Callback[] callbacks = new Callback[]{callback};
        enhancer.setCallbacks(callbacks);
        return (T)enhancer.create();
    }

    @Override
    public HAContextID convertProxyHAID(HAContextID oriHaContextID) throws CSErrorException {
        if (null == oriHaContextID) {
            logger.error("HaContextID cannot be null.");
            throw new CSErrorException(CSErrorCode.INVALID_HAID, "HaContextID cannot be null.");
        }
        HAContextID haContextID = oriHaContextID.copy();
        if (StringUtils.isBlank((CharSequence)haContextID.getContextId())) {
            HAContextID tmpHAID = this.contextHAIDGenerator.generateHAContextID(null);
            haContextID.setContextId(tmpHAID.getContextId());
            haContextID.setInstance(tmpHAID.getInstance());
            haContextID.setBackupInstance(tmpHAID.getBackupInstance());
            return haContextID;
        }
        if (StringUtils.isNotBlank((CharSequence)haContextID.getInstance()) && StringUtils.isNotBlank((CharSequence)haContextID.getBackupInstance())) {
            if (StringUtils.isNumeric((CharSequence)haContextID.getContextId())) {
                String haIdKey = this.contextHAChecker.convertHAIDToHAKey(haContextID);
                haContextID.setContextId(haIdKey);
            } else if (this.contextHAChecker.isHAIDValid(haContextID.getContextId())) {
                String contextID = this.contextHAChecker.parseHAIDFromKey(haContextID.getContextId()).getContextId();
                haContextID.setContextId(contextID);
            } else {
                throw new CSErrorException(CSErrorCode.INVALID_HAID, "Invalid contextID in haContextID : " + gson.toJson((Object)haContextID));
            }
            return haContextID;
        }
        if (StringUtils.isNumeric((CharSequence)haContextID.getContextId())) {
            HAContextID tmpHAID = this.contextHAIDGenerator.generateHAContextID((ContextID)haContextID);
            haContextID.setInstance(tmpHAID.getInstance());
            haContextID.setBackupInstance(tmpHAID.getBackupInstance());
        } else if (this.contextHAChecker.isHAIDValid(haContextID.getContextId())) {
            HAContextID tmpHAID = this.contextHAChecker.parseHAIDFromKey(haContextID.getContextId());
            haContextID.setContextId(tmpHAID.getContextId());
            haContextID.setInstance(tmpHAID.getInstance());
            haContextID.setBackupInstance(tmpHAID.getBackupInstance());
        } else {
            throw new CSErrorException(CSErrorCode.INVALID_HAID, "Invalid contextID in haContextID : " + gson.toJson((Object)haContextID));
        }
        if (this.contextHAChecker.isHAContextIDValid(haContextID)) {
            logger.info("HAID : " + this.contextHAChecker.convertHAIDToHAKey(haContextID));
        }
        return haContextID;
    }

    @Override
    public ContextHAIDGenerator getContextHAIDGenerator() {
        return this.contextHAIDGenerator;
    }

    @Override
    public ContextHAChecker getContextHAChecker() {
        return this.contextHAChecker;
    }

    @Override
    public BackupInstanceGenerator getBackupInstanceGenerator() {
        return this.backupInstanceGenerator;
    }
}

