/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.highavailable.ha.impl;

import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.cs.common.entity.source.CommonHAContextID;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.HAContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.highavailable.exception.CSErrorCode;
import org.apache.linkis.cs.highavailable.ha.BackupInstanceGenerator;
import org.apache.linkis.cs.highavailable.ha.ContextHAIDGenerator;
import org.apache.linkis.cs.highavailable.ha.instancealias.InstanceAliasConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextHAIDGeneratorImpl
implements ContextHAIDGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ContextHAIDGeneratorImpl.class);
    @Autowired
    private BackupInstanceGenerator backupInstanceGenerator;
    @Autowired
    private InstanceAliasConverter instanceAliasConverter;

    @Override
    public HAContextID generateHAContextID(ContextID contextID) throws CSErrorException {
        ServiceInstance mainInstance;
        String mainInstanceAlias;
        String contextIDKey = null;
        if (null != contextID && StringUtils.isNotBlank((CharSequence)contextID.getContextId())) {
            contextIDKey = contextID.getContextId();
        }
        if (StringUtils.isBlank((CharSequence)(mainInstanceAlias = this.instanceAliasConverter.instanceToAlias((mainInstance = DataWorkCloudApplication.getServiceInstance()).getInstance())))) {
            logger.error("MainInstance cannot be null.");
            throw new CSErrorException(CSErrorCode.INVALID_INSTANCE, "MainInstance alias cannot be null.");
        }
        String backupInstance = this.backupInstanceGenerator.chooseBackupInstance(mainInstanceAlias);
        if (StringUtils.isBlank((CharSequence)backupInstance)) {
            logger.error("Generate backupInstance cannot be null.");
            throw new CSErrorException(CSErrorCode.GENERATE_BACKUP_INSTANCE_ERROR, "Generate backupInstance cannot be null.");
        }
        CommonHAContextID haContextID = new CommonHAContextID(mainInstanceAlias, backupInstance, contextIDKey);
        logger.info("Generate a haContextID : {}" + new Gson().toJson((Object)haContextID));
        return haContextID;
    }
}

