/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncLongToDouble;

public class FuncLogWithBaseLongToDouble
extends MathFuncLongToDouble {
    private static final long serialVersionUID = 1L;
    private final double base;

    public FuncLogWithBaseLongToDouble(double scalarVal, int colNum, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.base = scalarVal;
    }

    public FuncLogWithBaseLongToDouble() {
        this.base = -1.0;
    }

    @Override
    protected double func(long l) {
        return Math.log(l) / Math.log(this.base);
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

