/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.service;

import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.ContextClient;
import org.apache.linkis.cs.client.builder.ContextClientFactory;
import org.apache.linkis.cs.client.service.ContextHistoryClientService;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.history.ContextHistory;
import org.apache.linkis.cs.common.entity.source.CombinedNodeIDContextID;
import org.apache.linkis.cs.common.entity.source.CommonContextValue;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextHistoryClientServiceImpl
implements ContextHistoryClientService {
    private static final Logger logger = LoggerFactory.getLogger(ContextHistoryClientServiceImpl.class);
    private ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
    private static ContextHistoryClientService contextHistoryClientService;

    private ContextHistoryClientServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContextHistoryClientService getInstance() {
        if (null != contextHistoryClientService) return contextHistoryClientService;
        Class<ContextHistoryClientServiceImpl> clazz = ContextHistoryClientServiceImpl.class;
        synchronized (ContextHistoryClientServiceImpl.class) {
            if (null != contextHistoryClientService) return contextHistoryClientService;
            contextHistoryClientService = new ContextHistoryClientServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return contextHistoryClientService;
        }
    }

    @Override
    public void createHistory(String contextIDStr, ContextHistory history) throws CSErrorException {
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            CommonContextValue contextValue = new CommonContextValue();
            if (contextID instanceof CombinedNodeIDContextID) {
                contextID = ((CombinedNodeIDContextID)contextID).getLinkisHaWorkFlowContextID();
            }
            this.contextClient.createHistory(contextID, history);
        }
        catch (ErrorException e) {
            throw new CSErrorException(70112, "createHistory error ", (Throwable)e);
        }
    }
}

