/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.common.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.datasourcemanager.common.exception.JsonErrorException;
import org.apache.linkis.datasourcemanager.common.util.json.Json;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"}, ignoreUnknown=true)
public class DatasourceVersion {
    private Long versionId;
    private Long datasourceId;
    private Map<String, Object> connectParams = new HashMap<String, Object>();
    private String parameter;
    private String comment;
    private Date createTime;
    private String createUser;

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(Long datasourceId) {
        this.datasourceId = datasourceId;
    }

    public Map<String, Object> getConnectParams() {
        if (this.connectParams.isEmpty() && StringUtils.isNotBlank((CharSequence)this.parameter)) {
            try {
                this.connectParams.putAll((Map)Objects.requireNonNull(Json.fromJson(this.parameter, Map.class, new Class[0])));
            }
            catch (JsonErrorException jsonErrorException) {
                // empty catch block
            }
        }
        return this.connectParams;
    }

    public void setConnectParams(Map<String, Object> connectParams) {
        this.connectParams = connectParams;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

