/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.io.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineType$;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.entrance.BindEngineLabel;
import org.apache.linkis.manager.label.entity.entrance.LoadBalanceLabel;
import org.apache.linkis.manager.label.utils.EngineTypeLabelCreator;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.orchestrator.Orchestration;
import org.apache.linkis.orchestrator.core.OrchestrationFuture;
import org.apache.linkis.orchestrator.core.OrchestrationResponse;
import org.apache.linkis.orchestrator.core.ResultSet;
import org.apache.linkis.orchestrator.domain.JobReq;
import org.apache.linkis.orchestrator.ecm.conf.ECMPluginConf$;
import org.apache.linkis.orchestrator.execution.ArrayResultSetTaskResponse;
import org.apache.linkis.orchestrator.execution.FailedTaskResponse;
import org.apache.linkis.orchestrator.execution.SucceedTaskResponse;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.apache.linkis.storage.domain.MethodEntity;
import org.apache.linkis.storage.exception.FSNotInitException;
import org.apache.linkis.storage.exception.StorageErrorCode;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.io.client.IOClient;
import org.apache.linkis.storage.io.conf.IOFileClientConf$;
import org.apache.linkis.storage.io.orchestrator.IOFileOrchestratorFactory$;
import org.apache.linkis.storage.io.utils.IOClientUtils$;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0006\r\u0001eAQ\u0001\f\u0001\u0005\u00025Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004>\u0001\u0001\u0006I!\r\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0011\u0019a\u0005\u0001)A\u0005\u0001\")A\u000b\u0001C!+\")\u0001\u000f\u0001C\u0001c\"I\u0011q\u0001\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0002\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011%\ti\u0003AI\u0001\n\u0003\tIAA\bEK\u001a\fW\u000f\u001c;J\u001f\u000ec\u0017.\u001a8u\u0015\tia\"\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u001fA\t!![8\u000b\u0005E\u0011\u0012aB:u_J\fw-\u001a\u0006\u0003'Q\ta\u0001\\5oW&\u001c(BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00015\u0001\"\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\"E5\tA\"\u0003\u0002$\u0019\tA\u0011jT\"mS\u0016tG\u000f\u0005\u0002&U5\taE\u0003\u0002(Q\u0005)Q\u000f^5mg*\u0011\u0011FE\u0001\u0007G>lWn\u001c8\n\u0005-2#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0002\"!\t\u0001\u0002!1|\u0017\r\u001a\"bY\u0006t7-\u001a'bE\u0016dW#A\u0019\u0011\u0005IZT\"A\u001a\u000b\u0005Q*\u0014\u0001C3oiJ\fgnY3\u000b\u0005Y:\u0014AB3oi&$\u0018P\u0003\u00029s\u0005)A.\u00192fY*\u0011!HE\u0001\b[\u0006t\u0017mZ3s\u0013\ta4G\u0001\tM_\u0006$')\u00197b]\u000e,G*\u00192fY\u0006\tBn\\1e\u0005\u0006d\u0017M\\2f\u0019\u0006\u0014W\r\u001c\u0011\u0002\u0017\u0015DHO]1MC\n,Gn]\u000b\u0002\u0001B\u00191$Q\"\n\u0005\tc\"!B!se\u0006L\bG\u0001#K!\r)e\tS\u0007\u0002k%\u0011q)\u000e\u0002\u0006\u0019\u0006\u0014W\r\u001c\t\u0003\u0013*c\u0001\u0001B\u0005L\u000b\u0005\u0005\t\u0011!B\u0001\u001b\n\u0019q\fJ\u0019\u0002\u0019\u0015DHO]1MC\n,Gn\u001d\u0011\u0012\u00059\u000b\u0006CA\u000eP\u0013\t\u0001FDA\u0004O_RD\u0017N\\4\u0011\u0005m\u0011\u0016BA*\u001d\u0005\r\te._\u0001\bKb,7-\u001e;f)\u00111\u0016mY6\u0011\u0005]sfB\u0001-]!\tIF$D\u0001[\u0015\tY\u0006$\u0001\u0004=e>|GOP\u0005\u0003;r\ta\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0019\u0019FO]5oO*\u0011Q\f\b\u0005\u0006E\u001a\u0001\rAV\u0001\u0005kN,'\u000fC\u0003e\r\u0001\u0007Q-\u0001\u0007nKRDw\u000eZ#oi&$\u0018\u0010\u0005\u0002gS6\tqM\u0003\u0002i!\u00051Am\\7bS:L!A[4\u0003\u00195+G\u000f[8e\u000b:$\u0018\u000e^=\t\u000b14\u0001\u0019A7\u0002\u001f\tLg\u000eZ#oO&tW\rT1cK2\u0004\"A\r8\n\u0005=\u001c$a\u0004\"j]\u0012,enZ5oK2\u000b'-\u001a7\u0002\u001b\u0015DXmY;uKJ+7/\u001e7u)\u00151&o\u001d;\u007f\u0011\u0015\u0011w\u00011\u0001W\u0011\u0015!w\u00011\u0001f\u0011\u0015)x\u00011\u0001w\u0003\u0019\u0001\u0018M]1ngB!q\u000f ,\u001b\u001b\u0005A(BA={\u0003\u0011)H/\u001b7\u000b\u0003m\fAA[1wC&\u0011Q\u0010\u001f\u0002\u0004\u001b\u0006\u0004\b\u0002C@\b!\u0003\u0005\r!!\u0001\u0002\u0015I,GO]=MS6LG\u000fE\u0002\u001c\u0003\u0007I1!!\u0002\u001d\u0005\rIe\u000e^\u0001\u0018Kb,7-\u001e;f%\u0016\u001cX\u000f\u001c;%I\u00164\u0017-\u001e7uIQ*\"!a\u0003+\t\u0005\u0005\u0011QB\u0016\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0004\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0005M!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001R\r_3dkR,w+\u001b;i%\u0016$(/\u001f\u000b\n-\u0006\r\u0012QEA\u0014\u0003SAQAY\u0005A\u0002YCQ\u0001Z\u0005A\u0002\u0015DQ\u0001\\\u0005A\u00025D\u0011\"a\u000b\n!\u0003\u0005\r!!\u0001\u0002\u0015I,GK]=MS6LG/\u0001\u000efq\u0016\u001cW\u000f^3XSRD'+\u001a;ss\u0012\"WMZ1vYR$C\u0007K\u0002\u0001\u0003c\u0001B!a\r\u0002>5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016T1!a\u000f\u0017\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017\u0002BA \u0003k\u0011\u0011bQ8na>tWM\u001c;")
public class DefaultIOClient
implements IOClient,
Logging {
    private final LoadBalanceLabel loadBalanceLabel;
    private final Label<?>[] extraLabels;
    private Logger logger;
    private final int defaultRetry;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultIOClient defaultIOClient = this;
        synchronized (defaultIOClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public int defaultRetry() {
        return this.defaultRetry;
    }

    @Override
    public void org$apache$linkis$storage$io$client$IOClient$_setter_$defaultRetry_$eq(int x$1) {
        this.defaultRetry = x$1;
    }

    private LoadBalanceLabel loadBalanceLabel() {
        return this.loadBalanceLabel;
    }

    private Label<?>[] extraLabels() {
        return this.extraLabels;
    }

    @Override
    public String execute(String user, MethodEntity methodEntity, BindEngineLabel bindEngineLabel) {
        HashMap<String, Object> params;
        block0: {
            params = new HashMap<String, Object>();
            if (bindEngineLabel == null) break block0;
            IOClientUtils$.MODULE$.addLabelToParams((Label<?>)bindEngineLabel, (Map<String, Object>)params);
        }
        return this.executeResult(user, methodEntity, params, this.executeResult$default$4());
    }

    public String executeResult(String user, MethodEntity methodEntity, Map<String, Object> params, int retryLimit) {
        String string;
        OrchestrationResponse response;
        OrchestrationResponse orchestrationResponse;
        EngineTypeLabel engineTypeLabel = EngineTypeLabelCreator.createEngineTypeLabel((String)EngineType$.MODULE$.mapFsTypeToEngineType(methodEntity.fsType()));
        IOClientUtils$.MODULE$.addLabelToParams((Label<?>)this.loadBalanceLabel(), params);
        IOClientUtils$.MODULE$.addLabelToParams((Label<?>)engineTypeLabel, params);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.extraLabels())).foreach((Function1 & Serializable & scala.Serializable)label -> {
            IOClientUtils$.MODULE$.addLabelToParams(label, params);
            return BoxedUnit.UNIT;
        });
        long startTime = System.currentTimeMillis();
        JobReq jobReq = IOClientUtils$.MODULE$.buildJobReq(user, methodEntity, params);
        if (jobReq == null) {
            throw new StorageErrorException(IOFileClientConf$.MODULE$.IO_EXECUTE_FAILED_CODE(), new StringBuilder(85).append("Job with id ").append(jobReq.getId()).append(" failed to execute method fs for user : ").append(user).append(", code : ").append(methodEntity).append("\uff0c Because jobReq is null").toString());
        }
        BindEngineLabel bindEngineLabel = LabelUtil$.MODULE$.getBindEngineLabel(jobReq.getLabels());
        if (bindEngineLabel == null) {
            throw new StorageErrorException(IOFileClientConf$.MODULE$.IO_EXECUTE_FAILED_CODE(), new StringBuilder(94).append("Job with id ").append(jobReq.getId()).append(" failed to execute method fs for user : ").append(user).append(", code : ").append(methodEntity).append("\uff0c Because bindEngineLabel is null").toString());
        }
        Orchestration orchestration = IOFileOrchestratorFactory$.MODULE$.getOrchestratorSession().orchestrate(jobReq);
        long orchestrationTime = System.currentTimeMillis();
        if (retryLimit > 0) {
            OrchestrationResponse response2 = orchestration.execute();
            int initCount = 0;
            while (!(response2 instanceof SucceedTaskResponse) && initCount < retryLimit) {
                this.logger().info(new StringBuilder(40).append("JobId ").append(jobReq.getId()).append(" execute method ").append(methodEntity).append(" failed, to retry ").append(++initCount).toString());
                Orchestration reTryOrchestration = IOFileOrchestratorFactory$.MODULE$.getOrchestratorSession().orchestrate(jobReq);
                response2 = reTryOrchestration.execute();
            }
            orchestrationResponse = response2;
        } else {
            OrchestrationFuture future = orchestration.asyncExecute();
            future.waitForCompleted((long)(IOFileClientConf$.MODULE$.IO__JOB_WAIT_S() * 1000));
            orchestrationResponse = future.getResponse();
        }
        OrchestrationResponse orchestrationResponse2 = response = orchestrationResponse;
        if (orchestrationResponse2 instanceof SucceedTaskResponse) {
            SucceedTaskResponse succeedTaskResponse = (SucceedTaskResponse)orchestrationResponse2;
            SucceedTaskResponse succeedTaskResponse2 = succeedTaskResponse;
            if (succeedTaskResponse2 instanceof ArrayResultSetTaskResponse) {
                ArrayResultSetTaskResponse arrayResultSetTaskResponse = (ArrayResultSetTaskResponse)succeedTaskResponse2;
                ResultSet firstResultSet = (ResultSet)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayResultSetTaskResponse.getResultSets())).headOption().orNull(Predef$.MODULE$.$conforms());
                if (firstResultSet != null) {
                    string = firstResultSet.result();
                } else {
                    this.logger().info(new StringBuilder(40).append("JobId ").append(jobReq.getId()).append(" execute method ").append(methodEntity).append(" with null result.").toString());
                    string = IOClientUtils$.MODULE$.SUCCESS();
                }
            } else {
                this.logger().info(new StringBuilder(40).append("JobId ").append(jobReq.getId()).append(" execute method ").append(methodEntity).append(" with null result.").toString());
                string = IOClientUtils$.MODULE$.SUCCESS();
            }
        } else {
            if (orchestrationResponse2 instanceof FailedTaskResponse) {
                FailedTaskResponse failedTaskResponse = (FailedTaskResponse)orchestrationResponse2;
                String msg = new StringBuilder(51).append("IO_FILE job: ").append(jobReq.getId()).append(" failed to execute code : ").append(methodEntity).append(", reason : ").append(failedTaskResponse.getErrorMsg()).append(".").toString();
                this.logger().info(msg);
                if (failedTaskResponse.getErrorMsg().contains(StorageErrorCode.FS_NOT_INIT.getMessage()) || failedTaskResponse.getErrorMsg().contains(Integer.toString(ECMPluginConf$.MODULE$.ECM_MARK_CACHE_ERROR_CODE()))) {
                    throw new FSNotInitException();
                }
                throw new StorageErrorException(IOFileClientConf$.MODULE$.IO_EXECUTE_FAILED_CODE(), msg);
            }
            String msg = new StringBuilder(70).append("IO_FILE job : ").append(jobReq.getId()).append(" failed to execute code : ").append(methodEntity).append(", return a unknown response : ").append(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)orchestrationResponse2)).toString();
            this.logger().warn(msg);
            throw new StorageErrorException(IOFileClientConf$.MODULE$.IO_EXECUTE_UNKNOWN_REASON_CODE(), msg);
        }
        String result = string;
        long executeTime = System.currentTimeMillis();
        this.logger().info(new StringBuilder(55).append(jobReq.getId()).append(" execute method ").append(methodEntity.methodName()).append(", orchestratorTime(").append(orchestrationTime - startTime).append("ms) execute time(").append(executeTime - orchestrationTime).append("ms)").toString());
        return result;
    }

    public int executeResult$default$4() {
        return 0;
    }

    @Override
    public String executeWithRetry(String user, MethodEntity methodEntity, BindEngineLabel bindEngineLabel, int reTryLimit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (bindEngineLabel != null) {
            IOClientUtils$.MODULE$.addLabelToParams((Label<?>)bindEngineLabel, (Map<String, Object>)params);
        }
        String result = this.executeResult(user, methodEntity, params, reTryLimit);
        return result;
    }

    @Override
    public int executeWithRetry$default$4() {
        return this.defaultRetry();
    }

    public DefaultIOClient() {
        IOClient.$init$(this);
        Logging.$init$((Logging)this);
        this.loadBalanceLabel = IOClientUtils$.MODULE$.getDefaultLoadBalanceLabel();
        this.extraLabels = (Label[])Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> IOClientUtils$.MODULE$.getExtraLabels(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().error("Failed to create extraLabels, No extra labels will be used", throwable2);
                return (Label[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Label.class));
            }
            throw new MatchError((Object)throwable);
        });
    }
}

