/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry.rule;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.lease.Lease;
import com.netflix.eureka.registry.rule.InstanceStatusOverrideRule;
import com.netflix.eureka.registry.rule.StatusOverrideResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownOrStartingRule
implements InstanceStatusOverrideRule {
    private static final Logger logger = LoggerFactory.getLogger(DownOrStartingRule.class);

    @Override
    public StatusOverrideResult apply(InstanceInfo instanceInfo, Lease<InstanceInfo> existingLease, boolean isReplication) {
        if (!InstanceInfo.InstanceStatus.UP.equals((Object)instanceInfo.getStatus()) && !InstanceInfo.InstanceStatus.OUT_OF_SERVICE.equals((Object)instanceInfo.getStatus())) {
            logger.debug("Trusting the instance status {} from replica or instance for instance {}", (Object)instanceInfo.getStatus(), (Object)instanceInfo.getId());
            return StatusOverrideResult.matchingStatus(instanceInfo.getStatus());
        }
        return StatusOverrideResult.NO_MATCH;
    }

    public String toString() {
        return DownOrStartingRule.class.getName();
    }
}

