/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.utils.SecurityUtils;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.apache.linkis.metadata.query.service.AbstractSqlConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConnection
extends AbstractSqlConnection {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnection.class);
    private static final CommonVars<String> SQL_DRIVER_CLASS = CommonVars.apply((String)"wds.linkis.server.mdm.service.sql.driver", (Object)"com.mysql.jdbc.Driver");
    private static final CommonVars<String> SQL_CONNECT_URL = CommonVars.apply((String)"wds.linkis.server.mdm.service.sql.url", (Object)"jdbc:mysql://%s:%s/%s");
    private static final CommonVars<Integer> SQL_CONNECT_TIMEOUT = CommonVars.apply((String)"wds.linkis.server.mdm.service.sql.connect.timeout", (Object)3000);
    private static final CommonVars<Integer> SQL_SOCKET_TIMEOUT = CommonVars.apply((String)"wds.linkis.server.mdm.service.sql.socket.timeout", (Object)6000);

    public SqlConnection(String host, Integer port, String username, String password, String database, Map<String, Object> extraParams) throws ClassNotFoundException, SQLException {
        super(host, port, username, password, database, extraParams);
        this.connectMessage.extraParams.put("connectTimeout", SQL_CONNECT_TIMEOUT.getValue());
        this.connectMessage.extraParams.put("socketTimeout", SQL_SOCKET_TIMEOUT.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllDatabases() throws SQLException {
        ArrayList<String> dataBaseName = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SHOW DATABASES");
            while (rs.next()) {
                dataBaseName.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            this.closeResource(null, stmt, rs);
            throw throwable;
        }
        this.closeResource(null, stmt, rs);
        return dataBaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllTables(String database) throws SQLException {
        ArrayList<String> arrayList;
        ArrayList<String> tableNames = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SHOW TABLES FROM `" + database + "`");
            while (rs.next()) {
                tableNames.add(rs.getString(1));
            }
            arrayList = tableNames;
        }
        catch (Throwable throwable) {
            this.closeResource(null, stmt, rs);
            throw throwable;
        }
        this.closeResource(null, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MetaColumnInfo> getColumns(String database, String table) throws SQLException, ClassNotFoundException {
        ArrayList<MetaColumnInfo> columns = new ArrayList<MetaColumnInfo>();
        String columnSql = "SELECT * FROM `" + database + "`.`" + table + "` WHERE 1 = 2";
        PreparedStatement ps = null;
        ResultSet rs = null;
        ResultSetMetaData meta = null;
        try {
            List<String> primaryKeys = this.getPrimaryKeys(table);
            ps = this.conn.prepareStatement(columnSql);
            rs = ps.executeQuery();
            meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            for (int i = 1; i < columnCount + 1; ++i) {
                MetaColumnInfo info = new MetaColumnInfo();
                info.setIndex(i);
                info.setLength(meta.getColumnDisplaySize(i));
                info.setNullable(meta.isNullable(i) == 1);
                info.setName(meta.getColumnName(i));
                info.setType(meta.getColumnTypeName(i));
                if (primaryKeys.contains(meta.getColumnName(i))) {
                    info.setPrimaryKey(true);
                }
                columns.add(info);
            }
        }
        catch (Throwable throwable) {
            this.closeResource(null, ps, rs);
            throw throwable;
        }
        this.closeResource(null, ps, rs);
        return columns;
    }

    @Override
    public Connection getDBConnection(AbstractSqlConnection.ConnectMessage connectMessage, String database) throws ClassNotFoundException, SQLException {
        Class.forName((String)SQL_DRIVER_CLASS.getValue());
        SecurityUtils.checkJdbcConnParams((String)connectMessage.host, (Integer)connectMessage.port, (String)connectMessage.username, (String)connectMessage.password, (String)database, connectMessage.extraParams);
        SecurityUtils.appendMysqlForceParams(connectMessage.extraParams);
        String url = String.format((String)SQL_CONNECT_URL.getValue(), connectMessage.host, connectMessage.port, database);
        if (StringUtils.isBlank((CharSequence)database)) {
            url = url.substring(0, url.length() - 1);
        }
        if (MapUtils.isNotEmpty(connectMessage.extraParams)) {
            String extraParamString = connectMessage.extraParams.entrySet().stream().map(e -> String.join((CharSequence)"=", (CharSequence)e.getKey(), String.valueOf(e.getValue()))).collect(Collectors.joining("&"));
            url = url + "?" + extraParamString;
        }
        LOG.info("jdbc connection url: {}", (Object)url);
        Properties properties = SecurityUtils.getMysqlSecurityParams();
        properties.setProperty("user", connectMessage.username);
        properties.setProperty("password", connectMessage.password);
        return DriverManager.getConnection(url, properties);
    }

    public String getSqlConnectUrl() {
        return (String)SQL_CONNECT_URL.getValue();
    }

    @Override
    public String generateJdbcDdlSql(String database, String table) {
        String columnSql = String.format("SHOW CREATE TABLE %s.%s", database, table);
        PreparedStatement ps = null;
        ResultSet rs = null;
        String ddl = "";
        try {
            ps = this.conn.prepareStatement(columnSql);
            rs = ps.executeQuery();
            if (rs.next()) {
                ddl = rs.getString("Create Table");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeResource(null, ps, rs);
                throw throwable;
            }
        }
        this.closeResource(null, ps, rs);
        return ddl.replaceAll("\n", "\n\t");
    }
}

