/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.conf;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.rpc.RPCReceiveRestful;
import org.apache.linkis.rpc.interceptor.RPCServerLoader;
import org.apache.linkis.rpc.sender.spring.SpringRPCServerLoader;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Configuration
@EnableFeignClients
@ScalaSignature(bytes="\u0006\u0001Q4A\u0001B\u0003\u0001!!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0001I!)Q\u000b\u0001C\u0001-\n1\"\u000bU\"TaJLgnZ\"p]\u001aLw-\u001e:bi&|gN\u0003\u0002\u0007\u000f\u0005!1m\u001c8g\u0015\tA\u0011\"A\u0002sa\u000eT!AC\u0006\u0002\r1Lgn[5t\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!E\f\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g!\tAR$D\u0001\u001a\u0015\tQ2$A\u0003vi&d7O\u0003\u0002\u001d\u0013\u000511m\\7n_:L!AH\r\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\t\t\u0003E\u0001i\u0011!B\u0001\u0016GJ,\u0017\r^3S!\u000e\u001bVM\u001d<fe2{\u0017\rZ3s)\u0005)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\b\u0003-Ig\u000e^3sG\u0016\u0004Ho\u001c:\n\u0005):#a\u0004*Q\u0007N+'O^3s\u0019>\fG-\u001a:)\u0005\ta\u0003CA\u00177\u001b\u0005q#BA\u00181\u0003%\u0019wN\u001c3ji&|gN\u0003\u00022e\u0005i\u0011-\u001e;pG>tg-[4ve\u0016T!a\r\u001b\u0002\t\t|w\u000e\u001e\u0006\u0003k5\tqb\u001d9sS:<gM]1nK^|'o[\u0005\u0003o9\u0012\u0001dQ8oI&$\u0018n\u001c8bY>sW*[:tS:<')Z1oQ\u0011\u0011\u0011\bP\u001f\u0011\u00055R\u0014BA\u001e/\u0005I\u0019uN\u001c3ji&|g.\u00197P]\u000ec\u0017m]:\u0002\u000bY\fG.^3-\u0003y\u001a\u0013a\u0010\t\u0003\u0001\u001ek\u0011!\u0011\u0006\u0003\u0005\u000e\u000b\u0011\u0002Z5tG>4XM]=\u000b\u0005\u0011+\u0015AB2mS\u0016tGO\u0003\u0002Gi\u0005)1\r\\8vI&\u0011\u0001*\u0011\u0002\u0010\t&\u001c8m\u001c<fef\u001cE.[3oi\"\"!A\u0013\u001fS!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0006b]:|G/\u0019;j_:T!a\u0014\u001b\u0002\u000f\r|g\u000e^3yi&\u0011\u0011\u000b\u0014\u0002\u0005\u0005\u0016\fg\u000eL\u0001TC\u0005!\u0016a\u0004:qGN+'O^3s\u0019>\fG-\u001a:\u0002%\r|W\u000e\u001d7fi\u0016Le.\u001b;jC2L'0\u001a\u000b\u0003/j\u0003\"A\u0005-\n\u0005e\u001b\"\u0001B+oSRDQaW\u0002A\u0002q\u000b\u0001$\u00199qY&\u001c\u0017\r^5p]B\u0013X\r]1sK\u0012,e/\u001a8u!\ti\u0016-D\u0001_\u0015\ty\u0006-A\u0003fm\u0016tGO\u0003\u0002Pe%\u0011!M\u0018\u0002\u0019\u0003B\u0004H.[2bi&|g\u000e\u0015:fa\u0006\u0014X\rZ#wK:$\bFA\u0002e!\t)w-D\u0001g\u0015\tyf*\u0003\u0002iM\niQI^3oi2K7\u000f^3oKJD#\u0001\u00016\u0011\u0005-tW\"\u00017\u000b\u00055,\u0015!C8qK:4W-[4o\u0013\tyGN\u0001\nF]\u0006\u0014G.\u001a$fS\u001et7\t\\5f]R\u001c\bF\u0001\u0001r!\tY%/\u0003\u0002t\u0019\ni1i\u001c8gS\u001e,(/\u0019;j_:\u0004")
public class RPCSpringConfiguration
implements Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        RPCSpringConfiguration rPCSpringConfiguration = this;
        synchronized (rPCSpringConfiguration) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Bean(value={"rpcServerLoader"})
    @ConditionalOnClass(value={DiscoveryClient.class})
    @ConditionalOnMissingBean
    public RPCServerLoader createRPCServerLoader() {
        return new SpringRPCServerLoader();
    }

    @EventListener
    public void completeInitialize(ApplicationPreparedEvent applicationPreparedEvent) {
        String restfulClasses = (String)ServerConfiguration$.MODULE$.BDP_SERVER_RESTFUL_REGISTER_CLASSES().getValue();
        String rpcRestfulName = applicationPreparedEvent.getApplicationContext().getBean(RPCReceiveRestful.class).getClass().getName();
        if (StringUtils.isEmpty((CharSequence)restfulClasses)) {
            DataWorkCloudApplication.setProperty((String)ServerConfiguration$.MODULE$.BDP_SERVER_RESTFUL_REGISTER_CLASSES().key(), (String)rpcRestfulName);
        } else {
            DataWorkCloudApplication.setProperty((String)ServerConfiguration$.MODULE$.BDP_SERVER_RESTFUL_REGISTER_CLASSES().key(), (String)new StringBuilder(1).append(restfulClasses).append(",").append(rpcRestfulName).toString());
        }
        this.logger().info("DataWorkCloud RPC need register RPCReceiveRestful, now add it to configuration.");
    }

    public RPCSpringConfiguration() {
        Logging.$init$((Logging)this);
    }
}

