/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.security;

import com.google.gson.Gson;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.Base64;
import org.apache.linkis.common.utils.RSAUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.config.GatewayConfiguration$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.security.AbstractUserRestful;
import org.apache.linkis.gateway.security.GatewaySSOUtils$;
import org.apache.linkis.protocol.usercontrol.RequestLogin;
import org.apache.linkis.protocol.usercontrol.RequestRegister;
import org.apache.linkis.protocol.usercontrol.ResponseLogin;
import org.apache.linkis.protocol.usercontrol.ResponseRegister;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.apache.linkis.server.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055a!\u0002\u000b\u0016\u0003\u0003\u0001\u0003\"B\u0017\u0001\t\u0003q\u0003b\u0002\u0019\u0001\u0005\u0004%I!\r\u0005\u0007q\u0001\u0001\u000b\u0011\u0002\u001a\t\u000fe\u0002!\u0019!C\u0005u!11\t\u0001Q\u0001\nmBq\u0001\u0012\u0001C\u0002\u0013%!\b\u0003\u0004F\u0001\u0001\u0006Ia\u000f\u0005\b\r\u0002\u0011\r\u0011\"\u0003;\u0011\u00199\u0005\u0001)A\u0005w!9\u0001\n\u0001b\u0001\n\u0013Q\u0004BB%\u0001A\u0003%1\bC\u0003K\u0001\u0011%1\nC\u0003e\u0001\u0011\u0005Q\rC\u0003k\u0001\u0011E3\u000eC\u0003t\u0001\u0019EA\u000fC\u0003z\u0001\u0011%!\u0010C\u0003|\u0001\u0011\u0005A\u0010C\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n\tQRk]3s!^$\u0017IY:ue\u0006\u001cG/V:feJ+7\u000f\u001e4vY*\u0011acF\u0001\tg\u0016\u001cWO]5us*\u0011\u0001$G\u0001\bO\u0006$Xm^1z\u0015\tQ2$\u0001\u0004mS:\\\u0017n\u001d\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tS\u0005\u0005\u0002#G5\tQ#\u0003\u0002%+\t\u0019\u0012IY:ue\u0006\u001cG/V:feJ+7\u000f\u001e4vYB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0006kRLGn\u001d\u0006\u0003Ue\taaY8n[>t\u0017B\u0001\u0017(\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0018\u0011\u0005\t\u0002\u0011AB:f]\u0012,'/F\u00013!\t\u0019d'D\u00015\u0015\t)\u0014$A\u0002sa\u000eL!a\u000e\u001b\u0003\rM+g\u000eZ3s\u0003\u001d\u0019XM\u001c3fe\u0002\na\u0002T%O\u000b~#U\tT%N\u0013R+%+F\u0001<!\ta\u0014)D\u0001>\u0015\tqt(\u0001\u0003mC:<'\"\u0001!\u0002\t)\fg/Y\u0005\u0003\u0005v\u0012aa\u0015;sS:<\u0017a\u0004'J\u001d\u0016{F)\u0012'J\u001b&#VI\u0015\u0011\u0002\u0019U\u001bVI\u0015(B\u001b\u0016{6\u000b\u0016*\u0002\u001bU\u001bVI\u0015(B\u001b\u0016{6\u000b\u0016*!\u0003)\u0001\u0016iU*X\t~\u001bFKU\u0001\f!\u0006\u001b6k\u0016#`'R\u0013\u0006%\u0001\nQ\u0003N\u001bv\u000bR0F\u001d\u000e\u0013\u0016\f\u0015+`'R\u0013\u0016a\u0005)B'N;FiX#O\u0007JK\u0006\u000bV0T)J\u0003\u0013!E4fiV\u001bXM\u001d(b[\u0016\fe\u000e\u001a)X\tR\u0011A\n\u0018\t\u0005\u001bB\u0013&+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u0019!V\u000f\u001d7feA\u00111K\u0017\b\u0003)b\u0003\"!\u0016(\u000e\u0003YS!aV\u0010\u0002\rq\u0012xn\u001c;?\u0013\tIf*\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005nS!!\u0017(\t\u000buc\u0001\u0019\u00010\u0002\u001d\u001d\fG/Z<bs\u000e{g\u000e^3yiB\u0011qLY\u0007\u0002A*\u0011\u0011mF\u0001\u0005QR$\b/\u0003\u0002dA\nqq)\u0019;fo\u0006L8i\u001c8uKb$\u0018!E2mK\u0006\u0014X\t\u001f9je\u0016\u001cun\\6jKR\u0011a-\u001b\t\u0003\u001b\u001eL!\u0001\u001b(\u0003\tUs\u0017\u000e\u001e\u0005\u0006;6\u0001\rAX\u0001\tiJLHj\\4j]R\u0011AN\u001d\t\u0003[Bl\u0011A\u001c\u0006\u0003_f\taa]3sm\u0016\u0014\u0018BA9o\u0005\u001diUm]:bO\u0016DQ!\u0018\bA\u0002y\u000bQ\u0001\\8hS:$2\u0001\\;x\u0011\u00151x\u00021\u0001S\u0003!)8/\u001a:OC6,\u0007\"\u0002=\u0010\u0001\u0004\u0011\u0016\u0001\u00039bgN<xN\u001d3\u0002%\u001d,GOU1oI>l\u0007K]8ysV\u001bXM\u001d\u000b\u0002%\u0006\u0001Ro]3s\u0007>tGO]8m\u0019><\u0017N\u001c\u000b\u0005Yvtx\u0010C\u0003w#\u0001\u0007!\u000bC\u0003y#\u0001\u0007!\u000bC\u0003^#\u0001\u0007a,A\u0006uef\u0014VmZ5ti\u0016\u0014Hc\u00017\u0002\u0006!)QL\u0005a\u0001=\u0006\u0019Ro]3s\u0007>tGO]8m%\u0016<\u0017n\u001d;feR\u0019A.a\u0003\t\u000bu\u001b\u0002\u0019\u00010")
public abstract class UserPwdAbstractUserRestful
extends AbstractUserRestful {
    private final Sender sender = Sender$.MODULE$.getSender((String)GatewayConfiguration$.MODULE$.USERCONTROL_SPRING_APPLICATION_NAME().getValue());
    private final String LINE_DELIMITER;
    private final String USERNAME_STR;
    private final String PASSWD_STR;
    private final String PASSWD_ENCRYPT_STR;

    private Sender sender() {
        return this.sender;
    }

    private String LINE_DELIMITER() {
        return this.LINE_DELIMITER;
    }

    private String USERNAME_STR() {
        return this.USERNAME_STR;
    }

    private String PASSWD_STR() {
        return this.PASSWD_STR;
    }

    private String PASSWD_ENCRYPT_STR() {
        return this.PASSWD_ENCRYPT_STR;
    }

    private Tuple2<String, String> getUserNameAndPWD(GatewayContext gatewayContext) {
        String string;
        Tuple2 tuple2;
        Tuple2 tuple22;
        String[] userNameArray = gatewayContext.getRequest().getQueryParams().get(this.USERNAME_STR());
        String[] passwordArray = gatewayContext.getRequest().getQueryParams().get(this.PASSWD_STR());
        String[] passwordArrayEncrypt = gatewayContext.getRequest().getQueryParams().get(this.PASSWD_ENCRYPT_STR());
        if (passwordArray == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])passwordArray)).isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])passwordArray)).head()))) {
            passwordArray = passwordArrayEncrypt;
        }
        if (userNameArray != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])userNameArray)).nonEmpty() && passwordArray != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])passwordArray)).nonEmpty()) {
            tuple22 = new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])userNameArray)).head(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])passwordArray)).head());
        } else if (StringUtils.isNotBlank((CharSequence)gatewayContext.getRequest().getRequestBody())) {
            Map json = (Map)BDPJettyServerHelper$.MODULE$.gson().fromJson(gatewayContext.getRequest().getRequestBody(), Map.class);
            Object tmpUsername = json.getOrDefault(this.USERNAME_STR(), null);
            Object tmpPasswd = json.getOrDefault(this.PASSWD_STR(), null);
            if (tmpPasswd == null) {
                tmpPasswd = json.getOrDefault(this.PASSWD_ENCRYPT_STR(), null);
            }
            tuple22 = new Tuple2(tmpUsername, tmpPasswd);
        } else {
            tuple22 = tuple2 = new Tuple2(null, null);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object userName = tuple2._1();
        Object passwordEncrypt = tuple2._2();
        Tuple2 tuple23 = new Tuple2(userName, passwordEncrypt);
        Object userName2 = tuple23._1();
        Object passwordEncrypt2 = tuple23._2();
        if (userName2 == null || StringUtils.isBlank((CharSequence)userName2.toString())) {
            return new Tuple2(null, null);
        }
        if (passwordEncrypt2 == null || StringUtils.isBlank((CharSequence)passwordEncrypt2.toString())) {
            return new Tuple2((Object)userName2.toString(), null);
        }
        if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.LOGIN_ENCRYPT_ENABLE().getValue())) {
            this.logger().info(new StringBuilder(31).append("passwordEncrypt or : ").append(passwordEncrypt2).append(" username ").append(userName2).toString());
            string = (String)Utils$.MODULE$.tryAndError((Function0 & Serializable & scala.Serializable)() -> {
                this.logger().info(new StringBuilder(50).append("\npasswdEncrypt : ").append(passwordEncrypt2).append("\npublicKeyStr : ").append(RSAUtils$.MODULE$.getDefaultPublicKey()).append("\nprivateKeyStr : ").append(RSAUtils$.MODULE$.getDefaultPrivateKey()).toString());
                byte[] passwdOriObj = RSAUtils$.MODULE$.decrypt(Base64.decodeBase64((byte[])((String)passwordEncrypt2).getBytes(StandardCharsets.UTF_8)));
                return new String(passwdOriObj, StandardCharsets.UTF_8);
            }, this.logger());
        } else {
            string = (String)passwordEncrypt2;
        }
        String password = string;
        return new Tuple2((Object)userName2.toString(), (Object)password);
    }

    public void clearExpireCookie(GatewayContext gatewayContext) {
        Cookie[] cookies = (Cookie[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(gatewayContext.getRequest().getCookies().values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)cookie -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookie)), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Cookie.class));
        Cookie[] expireCookies = (Cookie[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).filter((Function1 & Serializable & scala.Serializable)cookie -> BoxesRunTime.boxToBoolean((boolean)UserPwdAbstractUserRestful.$anonfun$clearExpireCookie$2(cookie)));
        String[] host = gatewayContext.getRequest().getHeaders().get("Host");
        if (host != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])host)).nonEmpty()) {
            int maxDomainLevel = ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])host)).head()).split("\\.").length;
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), maxDomainLevel).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)level -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expireCookies.clone())).foreach((Function1 & Serializable & scala.Serializable)cookie -> {
                UserPwdAbstractUserRestful.$anonfun$clearExpireCookie$4(this, host, level, gatewayContext, cookie);
                return BoxedUnit.UNIT;
            }));
            return;
        }
    }

    @Override
    public Message tryLogin(GatewayContext gatewayContext) {
        Tuple2<String, String> tuple2 = this.getUserNameAndPWD(gatewayContext);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String userName = (String)tuple2._1();
        String password = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)userName, (Object)password);
        String userName2 = (String)tuple22._1();
        String password2 = (String)tuple22._2();
        if (StringUtils.isBlank((CharSequence)userName2)) {
            return Message$.MODULE$.error("Username can not be empty(\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a)\uff01");
        }
        if (StringUtils.isBlank((CharSequence)password2)) {
            return Message$.MODULE$.error("Password can not be blank(\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a)\uff01");
        }
        if (((String)GatewayConfiguration$.MODULE$.ADMIN_USER().getValue()).equals(userName2) && ((String)GatewayConfiguration$.MODULE$.ADMIN_PASSWORD().getValue()).equals(password2)) {
            GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, userName2);
            return package$.MODULE$.ok("login successful(\u767b\u5f55\u6210\u529f)\uff01").data("userName", (Object)userName2).data("isAdmin", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        Message message = Message$.MODULE$.ok();
        if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.USERCONTROL_SWITCH_ON().getValue())) {
            message = this.userControlLogin(userName2, password2, gatewayContext);
        } else {
            String lowerCaseUserName = userName2.toLowerCase(Locale.getDefault());
            message = this.login(lowerCaseUserName, password2);
            this.clearExpireCookie(gatewayContext);
            if (message.getStatus() == 0) {
                GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, lowerCaseUserName);
            }
        }
        Object object = message.getData().containsKey("errmsg") ? message.setMessage(new StringBuilder(0).append(message.getMessage()).append(this.LINE_DELIMITER()).append(message.getData().get("errmsg").toString()).toString()) : BoxedUnit.UNIT;
        return message;
    }

    public abstract Message login(String var1, String var2);

    private String getRandomProxyUser() {
        String name = null;
        String[] userList = GatewayConfiguration$.MODULE$.PROXY_USER_LIST();
        int size = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])userList)).size();
        if (size <= 0) {
            this.logger().warn("Invalid Gateway proxy user list");
        } else {
            Random rand = new Random();
            name = userList[rand.nextInt(size)];
        }
        return name;
    }

    public Message userControlLogin(String userName, String password, GatewayContext gatewayContext) {
        ObjectRef message = ObjectRef.create((Object)Message$.MODULE$.ok());
        RequestLogin requestLogin = new RequestLogin();
        requestLogin.setUserName(userName.toString()).setPassword(password.toString());
        Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            Object object = this.sender().ask((Object)requestLogin);
            if (object instanceof ResponseLogin) {
                ResponseLogin responseLogin = (ResponseLogin)object;
                ((Message)message$1.elem).setStatus(Predef$.MODULE$.Integer2int(responseLogin.getStatus()));
                Object object2 = StringUtils.isNotBlank((CharSequence)responseLogin.getErrMsg()) ? ((Message)message$1.elem).data("errmsg", (Object)responseLogin.getErrMsg()) : BoxedUnit.UNIT;
                if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)0), (Object)responseLogin.getStatus())) {
                    ((Message)message$1.elem).setStatus(0);
                    ((Message)message$1.elem).setMessage("Login successful(\u767b\u5f55\u6210\u529f)");
                    String proxyUser = this.getRandomProxyUser();
                    if (StringUtils.isNotBlank((CharSequence)proxyUser)) {
                        GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, proxyUser);
                        return ((Message)message$1.elem).setMessage("Login successful(\u767b\u5f55\u6210\u529f)").data("userName", (Object)proxyUser).data("isAdmin", (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                    message$1.elem = Message$.MODULE$.error("Invalid proxy user, please contact with administrator(\u4ee3\u7406\u7528\u6237\u65e0\u6548\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458)");
                    return BoxedUnit.UNIT;
                }
                message$1.elem = Message$.MODULE$.error("Invalid username or password, please check and try again later(\u7528\u6237\u540d\u6216\u5bc6\u7801\u65e0\u6548\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5)");
                return BoxedUnit.UNIT;
            }
            throw new MatchError(object);
        }, (Function1 & Serializable & scala.Serializable)t -> {
            this.logger().warn("Login rpc request error, err message ", t);
            ((Message)message$1.elem).setStatus(1);
            ((Message)message$1.elem).setMessage("System error, please try again later(\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5)");
            return ((Message)message$1.elem).data("errmsg", (Object)t.getMessage());
        });
        return (Message)message.elem;
    }

    @Override
    public Message tryRegister(GatewayContext gatewayContext) {
        Message message = Message$.MODULE$.ok();
        message = BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.USERCONTROL_SWITCH_ON().getValue()) ? this.userControlRegister(gatewayContext) : Message$.MODULE$.error("\u8bf7\u81ea\u884c\u5b9e\u73b0\u6ce8\u518c\u65b9\u6cd5\uff01");
        return message;
    }

    private Message userControlRegister(GatewayContext gatewayContext) {
        Message message = Message$.MODULE$.ok();
        Gson gson = new Gson();
        RequestRegister requestRegister = new RequestRegister();
        String requestBody = gatewayContext.getRequest().getRequestBody();
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            requestRegister.setParams(requestBody);
            Object object = this.sender().ask((Object)requestRegister);
            if (object instanceof ResponseRegister) {
                ResponseRegister responseRegister = (ResponseRegister)object;
                message.setStatus(responseRegister.getStatus());
                message.setMessage(responseRegister.getMessage());
                HashMap map = responseRegister.getData();
                message.setData(map);
                message.setMethod(responseRegister.getMethod());
                this.logger().info(new StringBuilder(49).append("Register rpc success. requestRegister=").append(gson.toJson((Object)requestRegister)).append(", response=").append(gson.toJson((Object)responseRegister)).toString());
                return;
            }
            throw new MatchError(object);
        }, (Function1 & Serializable & scala.Serializable)e -> {
            UserPwdAbstractUserRestful.$anonfun$userControlRegister$2(this, message, e);
            return BoxedUnit.UNIT;
        });
        Object object = message.getData().containsKey("errmsg") ? message.setMessage(new StringBuilder(0).append(message.getMessage()).append(this.LINE_DELIMITER()).append(message.getData().get("errmsg").toString()).toString()) : BoxedUnit.UNIT;
        return message;
    }

    public static final /* synthetic */ boolean $anonfun$clearExpireCookie$2(Cookie cookie) {
        return cookie.getName().equals(ServerConfiguration$.MODULE$.LINKIS_SERVER_SESSION_TICKETID_KEY().getValue()) || cookie.getName().equals(ServerConfiguration$.MODULE$.LINKIS_SERVER_SESSION_PROXY_TICKETID_KEY().getValue());
    }

    public static final /* synthetic */ void $anonfun$clearExpireCookie$4(UserPwdAbstractUserRestful $this, String[] host$1, int level$1, GatewayContext gatewayContext$5, Cookie cookie) {
        cookie.setValue(null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        String domain = GatewaySSOUtils$.MODULE$.getCookieDomain((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])host$1)).head(), level$1);
        cookie.setDomain(domain);
        gatewayContext$5.getResponse().addCookie(cookie);
        $this.logger().info(new StringBuilder(31).append("success clear user cookie: ").append($this.getUserNameAndPWD(gatewayContext$5)._1()).append("--").append(ServerConfiguration$.MODULE$.LINKIS_SERVER_SESSION_TICKETID_KEY().getValue()).append("--").append(domain).toString());
    }

    public static final /* synthetic */ void $anonfun$userControlRegister$2(UserPwdAbstractUserRestful $this, Message message$2, Throwable e) {
        $this.logger().warn("Register rpc request error. err message ", e);
        message$2.setStatus(1);
        message$2.setMessage("System, please try again later(\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5)");
    }

    public UserPwdAbstractUserRestful() {
        this.LINE_DELIMITER = "</br>";
        this.USERNAME_STR = "userName";
        this.PASSWD_STR = "password";
        this.PASSWD_ENCRYPT_STR = "passwdEncrypt";
    }
}

