/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.persistence.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.metrics.NodeMetrics;
import org.apache.linkis.manager.common.entity.node.Node;
import org.apache.linkis.manager.common.entity.persistence.PersistenceNode;
import org.apache.linkis.manager.common.entity.persistence.PersistenceNodeMetrics;
import org.apache.linkis.manager.common.entity.persistence.PersistenceNodeMetricsEntity;
import org.apache.linkis.manager.dao.NodeManagerMapper;
import org.apache.linkis.manager.dao.NodeMetricManagerMapper;
import org.apache.linkis.manager.exception.PersistenceErrorException;
import org.apache.linkis.manager.persistence.NodeMetricManagerPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeMetricManagerPersistence
implements NodeMetricManagerPersistence {
    private static Logger logger = LoggerFactory.getLogger(DefaultNodeMetricManagerPersistence.class);
    private NodeManagerMapper nodeManagerMapper;
    private NodeMetricManagerMapper nodeMetricManagerMapper;

    public NodeManagerMapper getNodeManagerMapper() {
        return this.nodeManagerMapper;
    }

    public void setNodeManagerMapper(NodeManagerMapper nodeManagerMapper) {
        this.nodeManagerMapper = nodeManagerMapper;
    }

    public NodeMetricManagerMapper getNodeMetricManagerMapper() {
        return this.nodeMetricManagerMapper;
    }

    public void setNodeMetricManagerMapper(NodeMetricManagerMapper nodeMetricManagerMapper) {
        this.nodeMetricManagerMapper = nodeMetricManagerMapper;
    }

    @Override
    public void addNodeMetrics(NodeMetrics nodeMetrics) throws PersistenceErrorException {
        PersistenceNodeMetrics persistenceNodeMetrics = new PersistenceNodeMetrics();
        persistenceNodeMetrics.setInstance(nodeMetrics.getServiceInstance().getInstance());
        persistenceNodeMetrics.setHealthy(nodeMetrics.getHealthy());
        persistenceNodeMetrics.setHeartBeatMsg(nodeMetrics.getHeartBeatMsg());
        persistenceNodeMetrics.setOverLoad(nodeMetrics.getOverLoad());
        persistenceNodeMetrics.setStatus(nodeMetrics.getStatus());
        persistenceNodeMetrics.setCreateTime(new Date());
        persistenceNodeMetrics.setUpdateTime(new Date());
        this.nodeMetricManagerMapper.addNodeMetrics(persistenceNodeMetrics);
    }

    @Override
    public void addOrupdateNodeMetrics(NodeMetrics nodeMetrics) {
        if (null == nodeMetrics.getServiceInstance()) {
            logger.warn("The request of update node metrics was ignored, because the node metrics service instance is null");
            return;
        }
        String instance = nodeMetrics.getServiceInstance().getInstance();
        PersistenceNode node = this.nodeManagerMapper.getNodeInstance(instance);
        if (node == null) {
            logger.warn("The request of update node metrics was ignored, because the node " + instance + " is not exist.");
            return;
        }
        int isInstanceIdExist = this.nodeMetricManagerMapper.checkInstanceExist(instance);
        PersistenceNodeMetrics persistenceNodeMetrics = new PersistenceNodeMetrics();
        if (isInstanceIdExist == 0) {
            persistenceNodeMetrics.setInstance(nodeMetrics.getServiceInstance().getInstance());
            persistenceNodeMetrics.setHealthy(nodeMetrics.getHealthy());
            persistenceNodeMetrics.setHeartBeatMsg(nodeMetrics.getHeartBeatMsg());
            persistenceNodeMetrics.setOverLoad(nodeMetrics.getOverLoad());
            persistenceNodeMetrics.setStatus(nodeMetrics.getStatus());
            persistenceNodeMetrics.setCreateTime(new Date());
            persistenceNodeMetrics.setUpdateTime(new Date());
            this.nodeMetricManagerMapper.addNodeMetrics(persistenceNodeMetrics);
        } else if (isInstanceIdExist == 1) {
            PersistenceNodeMetrics oldMetrics = this.nodeMetricManagerMapper.getNodeMetricsByInstance(instance);
            boolean isECM = nodeMetrics.getServiceInstance().getApplicationName().equalsIgnoreCase((String)GovernanceCommonConf.ENGINE_CONN_MANAGER_SPRING_NAME().getValue());
            if (!isECM && oldMetrics != null && NodeStatus.ShuttingDown.ordinal() <= oldMetrics.getStatus()) {
                logger.info("ignore update status node:{} from:{} to status:{}", new Object[]{instance, NodeStatus.values()[oldMetrics.getStatus()].name(), NodeStatus.values()[nodeMetrics.getStatus()].name()});
                persistenceNodeMetrics.setStatus(oldMetrics.getStatus());
            } else {
                persistenceNodeMetrics.setStatus(nodeMetrics.getStatus());
            }
            persistenceNodeMetrics.setInstance(nodeMetrics.getServiceInstance().getInstance());
            persistenceNodeMetrics.setHealthy(nodeMetrics.getHealthy());
            persistenceNodeMetrics.setHeartBeatMsg(nodeMetrics.getHeartBeatMsg());
            persistenceNodeMetrics.setOverLoad(nodeMetrics.getOverLoad());
            persistenceNodeMetrics.setUpdateTime(new Date());
            this.nodeMetricManagerMapper.updateNodeMetrics(persistenceNodeMetrics, instance);
        }
    }

    @Override
    public List<NodeMetrics> getNodeMetrics(List<? extends Node> nodes) throws PersistenceErrorException {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NodeMetrics> nodeMetricsList = new ArrayList<NodeMetrics>();
        ArrayList<String> instances = new ArrayList<String>();
        for (Node node : nodes) {
            String instance = node.getServiceInstance().getInstance();
            instances.add(instance);
        }
        List<PersistenceNodeMetrics> persistenceNodeMetricsList = this.nodeMetricManagerMapper.getNodeMetricsByInstances(instances);
        for (PersistenceNodeMetrics persistenceNodeMetric : persistenceNodeMetricsList) {
            for (Node node : nodes) {
                if (!persistenceNodeMetric.getInstance().equals(node.getServiceInstance().getInstance())) continue;
                persistenceNodeMetric.setServiceInstance(node.getServiceInstance());
                nodeMetricsList.add((NodeMetrics)persistenceNodeMetric);
            }
        }
        return nodeMetricsList;
    }

    @Override
    public NodeMetrics getNodeMetrics(Node node) throws PersistenceErrorException {
        PersistenceNodeMetrics persistenceNodeMetrics = this.nodeMetricManagerMapper.getNodeMetricsByInstance(node.getServiceInstance().getInstance());
        if (persistenceNodeMetrics == null) {
            return null;
        }
        persistenceNodeMetrics.setServiceInstance(node.getServiceInstance());
        return persistenceNodeMetrics;
    }

    @Override
    public void deleteNodeMetrics(Node node) throws PersistenceErrorException {
        String instance = node.getServiceInstance().getInstance();
        this.nodeMetricManagerMapper.deleteNodeMetricsByInstance(instance);
    }

    @Override
    public List<NodeMetrics> getAllNodeMetrics() throws PersistenceErrorException {
        List<PersistenceNodeMetricsEntity> allNodeMetrics = this.nodeMetricManagerMapper.getAllNodeMetrics();
        ArrayList<NodeMetrics> persistenceNodeMetricsList = new ArrayList<NodeMetrics>();
        for (PersistenceNodeMetricsEntity persistenceNodeMetricsEntity : allNodeMetrics) {
            PersistenceNodeMetrics persistenceNodeMetrics = new PersistenceNodeMetrics();
            ServiceInstance serviceInstance = new ServiceInstance();
            serviceInstance.setApplicationName(persistenceNodeMetricsEntity.getName());
            serviceInstance.setInstance(persistenceNodeMetricsEntity.getInstance());
            persistenceNodeMetrics.setServiceInstance(serviceInstance);
            persistenceNodeMetrics.setInstance(persistenceNodeMetricsEntity.getHealthy());
            persistenceNodeMetrics.setHeartBeatMsg(persistenceNodeMetricsEntity.getHeartBeatMsg());
            persistenceNodeMetrics.setOverLoad(persistenceNodeMetricsEntity.getOverLoad());
            persistenceNodeMetrics.setStatus(Integer.valueOf(persistenceNodeMetricsEntity.getStatus()));
            persistenceNodeMetrics.setCreateTime(persistenceNodeMetricsEntity.getCreateTime());
            persistenceNodeMetrics.setUpdateTime(persistenceNodeMetricsEntity.getUpdateTime());
            persistenceNodeMetricsList.add((NodeMetrics)persistenceNodeMetrics);
        }
        return persistenceNodeMetricsList;
    }

    @Override
    public void updateNodeMetricDescription(String description, String instance) {
        PersistenceNodeMetrics persistenceNodeMetrics = new PersistenceNodeMetrics();
        persistenceNodeMetrics.setDescription(description);
        this.nodeMetricManagerMapper.updateNodeMetrics(persistenceNodeMetrics, instance);
    }
}

