/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.listener.callback.imp;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Set;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.cs.common.entity.listener.CommonContextKeyListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ListenerDomain;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.listener.CSKeyListener;
import org.apache.linkis.cs.listener.callback.ContextKeyCallbackEngine;
import org.apache.linkis.cs.listener.callback.imp.ContextKeyValueBean;
import org.apache.linkis.cs.listener.event.ContextKeyEvent;
import org.apache.linkis.cs.listener.event.impl.DefaultContextKeyEvent;
import org.apache.linkis.cs.listener.manager.imp.DefaultContextListenerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContextKeyCallbackEngine
implements CSKeyListener,
ContextKeyCallbackEngine {
    private static final Logger logger = LoggerFactory.getLogger(DefaultContextKeyCallbackEngine.class);
    private HashMultimap<String, ContextID> registerCSIDcsClients = HashMultimap.create();
    private HashMultimap<String, ContextKeyValueBean> registerCSIDcsKeyValues = HashMultimap.create();
    private static DefaultContextKeyCallbackEngine singleDefaultContextKeyCallbackEngine = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerClient(ListenerDomain listenerDomain) {
        if (listenerDomain != null && listenerDomain instanceof CommonContextKeyListenerDomain) {
            CommonContextKeyListenerDomain commonContextKeyListenerDomain = (CommonContextKeyListenerDomain)listenerDomain;
            String source = commonContextKeyListenerDomain.getSource();
            ContextID contextID = commonContextKeyListenerDomain.getContextID();
            ContextKey contextKey = commonContextKeyListenerDomain.getContextKey();
            if (source != null && contextID != null) {
                HashMultimap<String, ContextID> hashMultimap = this.registerCSIDcsClients;
                synchronized (hashMultimap) {
                    logger.info("\u8981\u6ce8\u518c\u7684csClient\u548ccontextId: " + source + ":" + contextID);
                    this.registerCSIDcsClients.put((Object)source, (Object)contextID);
                }
            }
            if (contextKey != null) {
                ContextKeyValueBean contextKeyValueBean = new ContextKeyValueBean();
                contextKeyValueBean.setCsKey(contextKey);
                contextKeyValueBean.setCsID(contextID);
                HashMultimap<String, ContextKeyValueBean> hashMultimap = this.registerCSIDcsKeyValues;
                synchronized (hashMultimap) {
                    logger.info("\u8981\u6ce8\u518c\u7684contextId: " + contextID.getContextId());
                    this.registerCSIDcsKeyValues.put((Object)contextID.getContextId(), (Object)contextKeyValueBean);
                }
            }
        }
    }

    @Override
    public ArrayList<ContextKeyValueBean> getListenerCallback(String source) {
        ArrayList<ContextKeyValueBean> arrayContextKeyValueBeans = new ArrayList<ContextKeyValueBean>();
        Set contextIDS = this.registerCSIDcsClients.get((Object)source);
        if (contextIDS.size() > 0) {
            for (ContextID csId : contextIDS) {
                arrayContextKeyValueBeans.addAll(this.registerCSIDcsKeyValues.get((Object)csId.getContextId()));
            }
        }
        return arrayContextKeyValueBeans;
    }

    @Override
    public void onEvent(Event event) {
        DefaultContextKeyEvent defaultContextKeyEvent = null;
        if (event != null && event instanceof DefaultContextKeyEvent) {
            defaultContextKeyEvent = (DefaultContextKeyEvent)event;
        }
        if (null == defaultContextKeyEvent) {
            if (logger.isDebugEnabled()) {
                logger.debug("defaultContextKeyEvent event \u4e3a\u7a7a");
            }
            return;
        }
        logger.info("defaultContextKeyEvent \u8981\u66f4\u65b0\u4e8b\u4ef6\u7684ID: " + defaultContextKeyEvent.getContextID().getContextId());
        logger.info("defaultContextKeyEvent \u8981\u66f4\u65b0\u4e8b\u4ef6\u7684key: " + defaultContextKeyEvent.getContextKeyValue().getContextKey().getKey());
        logger.info("defaultContextKeyEvent \u8981\u66f4\u65b0\u7684value" + defaultContextKeyEvent.getContextKeyValue().getContextValue().getValue());
        switch (defaultContextKeyEvent.getOperateType()) {
            case UPDATE: {
                this.onCSKeyUpdate(defaultContextKeyEvent);
                break;
            }
            case ACCESS: {
                this.onCSKeyAccess(defaultContextKeyEvent);
                break;
            }
            default: {
                logger.info("\u68c0\u67e5defaultContextKeyEvent event\u64cd\u4f5c\u7c7b\u578b: {}", (Object)defaultContextKeyEvent.getOperateType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCSKeyUpdate(ContextKeyEvent cskeyEvent) {
        DefaultContextKeyEvent defaultContextKeyEvent = null;
        if (cskeyEvent != null && cskeyEvent instanceof DefaultContextKeyEvent) {
            defaultContextKeyEvent = (DefaultContextKeyEvent)cskeyEvent;
        }
        if (null == defaultContextKeyEvent) {
            return;
        }
        HashMultimap<String, ContextKeyValueBean> hashMultimap = this.registerCSIDcsKeyValues;
        synchronized (hashMultimap) {
            Set contextKeyValueBeans = this.registerCSIDcsKeyValues.get((Object)defaultContextKeyEvent.getContextID().getContextId());
            for (ContextKeyValueBean contextKeyValueBean : contextKeyValueBeans) {
                if (!contextKeyValueBean.getCsKey().getKey().equals(defaultContextKeyEvent.getContextKeyValue().getContextKey().getKey())) continue;
                contextKeyValueBean.setCsValue(defaultContextKeyEvent.getContextKeyValue().getContextValue());
            }
        }
    }

    @Override
    public void onCSKeyAccess(ContextKeyEvent cskeyEvent) {
    }

    public void onEventError(Event event, Throwable t) {
    }

    private DefaultContextKeyCallbackEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultContextKeyCallbackEngine getInstance() {
        if (singleDefaultContextKeyCallbackEngine != null) return singleDefaultContextKeyCallbackEngine;
        Class<DefaultContextKeyCallbackEngine> clazz = DefaultContextKeyCallbackEngine.class;
        synchronized (DefaultContextKeyCallbackEngine.class) {
            if (singleDefaultContextKeyCallbackEngine != null) return singleDefaultContextKeyCallbackEngine;
            singleDefaultContextKeyCallbackEngine = new DefaultContextKeyCallbackEngine();
            DefaultContextListenerManager instanceContextListenerManager = DefaultContextListenerManager.getInstance();
            instanceContextListenerManager.getContextAsyncListenerBus().addListener(singleDefaultContextKeyCallbackEngine);
            logger.info("add listerner singleDefaultContextKeyCallbackEngine success");
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleDefaultContextKeyCallbackEngine;
        }
    }
}

