/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.springcloud.http;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.gateway.errorcode.LinkisGatewayCoreErrorCodeSummary;
import org.apache.linkis.gateway.exception.GatewayWarnException;
import org.apache.linkis.gateway.http.BaseGatewayContext;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.http.GatewayHttpRequest;
import org.apache.linkis.gateway.http.GatewayHttpResponse;
import org.apache.linkis.gateway.parser.GatewayParser;
import org.apache.linkis.gateway.route.GatewayRouter;
import org.apache.linkis.gateway.security.LinkisPreFilter;
import org.apache.linkis.gateway.security.LinkisPreFilter$;
import org.apache.linkis.gateway.security.SecurityFilter;
import org.apache.linkis.gateway.springcloud.SpringCloudGatewayConfiguration;
import org.apache.linkis.gateway.springcloud.http.SpringCloudGatewayHttpRequest;
import org.apache.linkis.gateway.springcloud.http.SpringCloudGatewayHttpResponse;
import org.apache.linkis.gateway.springcloud.http.SpringCloudHttpUtils;
import org.apache.linkis.server.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GatewayAuthorizationFilter
implements GlobalFilter,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(GatewayAuthorizationFilter.class);
    private GatewayParser parser;
    private GatewayRouter router;
    private GatewayProperties gatewayProperties;
    private final Integer MAX_BUFFER_SIZE = (Integer)CommonVars.apply((String)"wds.linkis.gateway.max.buffer.size", (Object)0x8000000).getValue();
    private List<LinkisPreFilter> linkisPreFilters = LinkisPreFilter$.MODULE$.getLinkisPreFilters();

    public GatewayAuthorizationFilter(GatewayParser parser, GatewayRouter router, GatewayProperties gatewayProperties) {
        this.parser = parser;
        this.router = router;
        this.gatewayProperties = gatewayProperties;
    }

    private String getRequestBody(ServerWebExchange exchange) {
        ServerRequest defaultServerRequest = ServerRequest.create((ServerWebExchange)exchange, (List)HandlerStrategies.withDefaults().messageReaders());
        String requestBody = null;
        try {
            requestBody = (String)defaultServerRequest.bodyToMono(String.class).toFuture().get();
        }
        catch (Exception e) {
            GatewayWarnException exception = new GatewayWarnException(LinkisGatewayCoreErrorCodeSummary.GET_REQUESTBODY_FAILED.getErrorCode(), LinkisGatewayCoreErrorCodeSummary.GET_REQUESTBODY_FAILED.getErrorDesc());
            exception.initCause((Throwable)e);
            throw exception;
        }
        return requestBody;
    }

    private BaseGatewayContext getBaseGatewayContext(ServerWebExchange exchange, Route route) {
        AbstractServerHttpRequest request = (AbstractServerHttpRequest)exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        BaseGatewayContext gatewayContext = new BaseGatewayContext();
        SpringCloudGatewayHttpRequest springCloudGatewayHttpRequest = new SpringCloudGatewayHttpRequest(request);
        gatewayContext.setRequest((GatewayHttpRequest)springCloudGatewayHttpRequest);
        gatewayContext.setResponse((GatewayHttpResponse)new SpringCloudGatewayHttpResponse(response));
        if (route.getUri().toString().startsWith(SpringCloudGatewayConfiguration.ROUTE_URI_FOR_WEB_SOCKET_HEADER())) {
            gatewayContext.setWebSocketRequest();
        }
        return gatewayContext;
    }

    private Route getRealRoute(Route route, ServiceInstance serviceInstance, ServerWebExchange exchange) {
        String routeUri = route.getUri().toString();
        String scheme = route.getUri().getScheme();
        scheme = routeUri.startsWith(SpringCloudGatewayConfiguration.ROUTE_URI_FOR_WEB_SOCKET_HEADER()) ? SpringCloudGatewayConfiguration.ROUTE_URI_FOR_WEB_SOCKET_HEADER() : (routeUri.startsWith(SpringCloudGatewayConfiguration.ROUTE_URI_FOR_HTTP_HEADER()) ? SpringCloudGatewayConfiguration.ROUTE_URI_FOR_HTTP_HEADER() : scheme + "://");
        String uri = scheme + serviceInstance.getApplicationName();
        if (StringUtils.isNotBlank((CharSequence)serviceInstance.getInstance())) {
            exchange.getRequest().mutate().header("FIXED_INSTANCE", new String[]{serviceInstance.getInstance()});
        }
        return ((Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id(route.getId())).filters((Collection)route.getFilters())).order(route.getOrder())).uri(uri)).asyncPredicate(route.getPredicate()).build();
    }

    private Mono<Void> gatewayDeal(ServerWebExchange exchange, GatewayFilterChain chain, BaseGatewayContext gatewayContext) {
        ServiceInstance serviceInstance;
        SpringCloudGatewayHttpResponse gatewayHttpResponse = (SpringCloudGatewayHttpResponse)gatewayContext.getResponse();
        if (!SecurityFilter.doFilter((GatewayContext)gatewayContext)) {
            return gatewayHttpResponse.getResponseMono();
        }
        if (gatewayContext.isWebSocketRequest()) {
            return chain.filter(exchange);
        }
        for (LinkisPreFilter linkisPreFilter : this.linkisPreFilters) {
            if (linkisPreFilter.doFilter((GatewayContext)gatewayContext)) continue;
            return gatewayHttpResponse.getResponseMono();
        }
        try {
            this.parser.parse((GatewayContext)gatewayContext);
            if (gatewayHttpResponse.isCommitted()) {
                return gatewayHttpResponse.getResponseMono();
            }
            serviceInstance = this.router.route((GatewayContext)gatewayContext);
            if (serviceInstance != null) {
                logger.info("Client request ip: " + gatewayContext.getRequest().getRequestRealIpAddr() + " and uri: " + gatewayContext.getRequest().getRequestURI() + "GatewayRouter route requestUri: " + gatewayContext.getGatewayRoute().getRequestURI() + " with parsedService " + gatewayContext.getGatewayRoute().getServiceInstance().getApplicationName() + " to " + serviceInstance);
            } else {
                logger.info("Client request uri: " + gatewayContext.getRequest().getRequestURI());
            }
        }
        catch (Throwable t) {
            logger.warn("", t);
            Message message = Message.error((Throwable)t).$less$less(gatewayContext.getRequest().getRequestURI());
            if (!gatewayContext.isWebSocketRequest()) {
                gatewayHttpResponse.write(Message.response((Message)message));
            } else {
                gatewayHttpResponse.writeWebSocket(Message.response((Message)message));
            }
            gatewayHttpResponse.sendResponse();
            return gatewayHttpResponse.getResponseMono();
        }
        if (gatewayHttpResponse.isCommitted()) {
            return gatewayHttpResponse.getResponseMono();
        }
        Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        if (serviceInstance != null) {
            Route realRoute = this.getRealRoute(route, serviceInstance, exchange);
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, realRoute);
        } else {
            RouteDefinition realRd = null;
            String proxyId = (String)gatewayContext.getGatewayRoute().getParams().get("proxyId");
            for (RouteDefinition rd : this.gatewayProperties.getRoutes()) {
                if ((realRd != null || !rd.getId().equals("dws")) && !rd.getId().equals(proxyId)) continue;
                realRd = rd;
            }
            String uri = realRd.getUri().toString();
            if (uri != null) {
                uri = uri + StringUtils.replace((String)exchange.getRequest().getPath().value(), (String)("/" + realRd.getId() + "/"), (String)"");
                logger.info("Proxy to " + uri);
                Route realRoute = ((Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id(route.getId())).filters((Collection)route.getFilters())).order(route.getOrder())).uri(uri)).asyncPredicate(route.getPredicate()).build();
                exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, realRoute);
            }
        }
        ServerHttpRequest.Builder builder = exchange.getRequest().mutate().headers(SpringCloudHttpUtils::addIgnoreTimeoutSignal);
        if (!((SpringCloudGatewayHttpRequest)gatewayContext.getRequest()).getAddCookies().isEmpty()) {
            builder.headers(httpHeaders -> SpringCloudHttpUtils.addCookies(httpHeaders, ((SpringCloudGatewayHttpRequest)gatewayContext.getRequest()).getAddCookies()));
        }
        if (!((SpringCloudGatewayHttpRequest)gatewayContext.getRequest()).getAddHeaders().isEmpty()) {
            ((SpringCloudGatewayHttpRequest)gatewayContext.getRequest()).getAddHeaders().forEach((arg_0, arg_1) -> ((ServerHttpRequest.Builder)builder).header(arg_0, arg_1));
        }
        return chain.filter(exchange.mutate().request(builder.build()).build());
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        AbstractServerHttpRequest request = (AbstractServerHttpRequest)exchange.getRequest();
        Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        BaseGatewayContext gatewayContext = this.getBaseGatewayContext(exchange, route);
        if (!gatewayContext.isWebSocketRequest() && this.parser.shouldContainRequestBody((GatewayContext)gatewayContext)) {
            ServerRequest defaultServerRequest = ServerRequest.create((ServerWebExchange)exchange, (List)HandlerStrategies.withDefaults().messageReaders());
            defaultServerRequest.messageReaders().stream().filter(reader -> reader instanceof DecoderHttpMessageReader).filter(httpMessageReader -> ((DecoderHttpMessageReader)httpMessageReader).getDecoder() instanceof AbstractDataBufferDecoder).forEach(httpMessageReader -> ((AbstractDataBufferDecoder)((DecoderHttpMessageReader)httpMessageReader).getDecoder()).setMaxInMemorySize(this.MAX_BUFFER_SIZE.intValue()));
            return defaultServerRequest.bodyToMono(String.class).flatMap(requestBody -> {
                ((SpringCloudGatewayHttpRequest)gatewayContext.getRequest()).setRequestBody((String)requestBody);
                ServerHttpRequestDecorator decorator = new ServerHttpRequestDecorator((ServerHttpRequest)request, (String)requestBody, exchange){
                    final /* synthetic */ String val$requestBody;
                    final /* synthetic */ ServerWebExchange val$exchange;
                    {
                        this.val$requestBody = string;
                        this.val$exchange = serverWebExchange;
                        super(x0);
                    }

                    public Flux<DataBuffer> getBody() {
                        if (StringUtils.isBlank((CharSequence)this.val$requestBody)) {
                            return Flux.empty();
                        }
                        DataBufferFactory bufferFactory = this.val$exchange.getResponse().bufferFactory();
                        return Flux.just((Object)bufferFactory.wrap(this.val$requestBody.getBytes(StandardCharsets.UTF_8)));
                    }
                };
                return this.gatewayDeal(exchange.mutate().request((ServerHttpRequest)decorator).build(), chain, gatewayContext);
            });
        }
        return this.gatewayDeal(exchange, chain, gatewayContext);
    }

    public int getOrder() {
        return 1;
    }
}

