/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.client.deployment.crds;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.linkis.engineplugin.spark.client.deployment.crds.RestartPolicy;
import org.apache.linkis.engineplugin.spark.client.deployment.crds.SparkPodSpec;
import org.apache.linkis.engineplugin.spark.client.deployment.crds.Volume;

public class SparkApplicationSpec
implements KubernetesResource {
    private String type;
    private String mode;
    private String image;
    private String imagePullPolicy;
    private String mainClass;
    private String mainApplicationFile;
    private String sparkVersion;
    private RestartPolicy restartPolicy;
    private List<Volume> volumes;
    private SparkPodSpec driver;
    private SparkPodSpec executor;
    private Map<String, String> sparkConf;

    public Map<String, String> getSparkConf() {
        return this.sparkConf;
    }

    public void setSparkConf(Map<String, String> sparkConf) {
        this.sparkConf = sparkConf;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getMainApplicationFile() {
        return this.mainApplicationFile;
    }

    public void setMainApplicationFile(String mainApplicationFile) {
        this.mainApplicationFile = mainApplicationFile;
    }

    public String getSparkVersion() {
        return this.sparkVersion;
    }

    public void setSparkVersion(String sparkVersion) {
        this.sparkVersion = sparkVersion;
    }

    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(RestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<Volume> volumes) {
        this.volumes = volumes;
    }

    public SparkPodSpec getDriver() {
        return this.driver;
    }

    public void setDriver(SparkPodSpec driver) {
        this.driver = driver;
    }

    public SparkPodSpec getExecutor() {
        return this.executor;
    }

    public void setExecutor(SparkPodSpec executor) {
        this.executor = executor;
    }

    public String toString() {
        return "SparkApplicationSpec{type='" + this.type + '\'' + ", mode='" + this.mode + '\'' + ", image='" + this.image + '\'' + ", imagePullPolicy='" + this.imagePullPolicy + '\'' + ", mainClass='" + this.mainClass + '\'' + ", mainApplicationFile='" + this.mainApplicationFile + '\'' + ", sparkVersion='" + this.sparkVersion + '\'' + ", restartPolicy=" + this.restartPolicy + ", volumes=" + this.volumes + ", driver=" + this.driver + ", executor=" + this.executor + ", sparkConf=" + this.sparkConf + '}';
    }

    public static SparkApplicationSpecBuilder Builder() {
        return new SparkApplicationSpecBuilder();
    }

    public static class SparkApplicationSpecBuilder {
        private String type;
        private String mode;
        private String image;
        private String imagePullPolicy;
        private String mainClass;
        private String mainApplicationFile;
        private String sparkVersion;
        private RestartPolicy restartPolicy;
        private List<Volume> volumes;
        private SparkPodSpec driver;
        private SparkPodSpec executor;
        private Map<String, String> sparkConf;

        private SparkApplicationSpecBuilder() {
        }

        public SparkApplicationSpecBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SparkApplicationSpecBuilder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public SparkApplicationSpecBuilder image(String image) {
            this.image = image;
            return this;
        }

        public SparkApplicationSpecBuilder imagePullPolicy(String imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return this;
        }

        public SparkApplicationSpecBuilder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public SparkApplicationSpecBuilder mainApplicationFile(String mainApplicationFile) {
            this.mainApplicationFile = mainApplicationFile;
            return this;
        }

        public SparkApplicationSpecBuilder sparkVersion(String sparkVersion) {
            this.sparkVersion = sparkVersion;
            return this;
        }

        public SparkApplicationSpecBuilder restartPolicy(RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        public SparkApplicationSpecBuilder volumes(List<Volume> volumes) {
            this.volumes = volumes;
            return this;
        }

        public SparkApplicationSpecBuilder driver(SparkPodSpec driver) {
            this.driver = driver;
            return this;
        }

        public SparkApplicationSpecBuilder executor(SparkPodSpec executor) {
            this.executor = executor;
            return this;
        }

        public SparkApplicationSpecBuilder sparkConf(Map<String, String> sparkConf) {
            if (sparkConf == null || sparkConf.size() == 0) {
                return this;
            }
            if (this.sparkConf == null) {
                this.sparkConf = new HashMap<String, String>();
            }
            for (Map.Entry<String, String> entry : sparkConf.entrySet()) {
                this.sparkConf.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public SparkApplicationSpec build() {
            SparkApplicationSpec sparkApplicationSpec = new SparkApplicationSpec();
            sparkApplicationSpec.type = this.type;
            sparkApplicationSpec.mainClass = this.mainClass;
            sparkApplicationSpec.imagePullPolicy = this.imagePullPolicy;
            sparkApplicationSpec.volumes = this.volumes;
            sparkApplicationSpec.driver = this.driver;
            sparkApplicationSpec.sparkVersion = this.sparkVersion;
            sparkApplicationSpec.mode = this.mode;
            sparkApplicationSpec.mainApplicationFile = this.mainApplicationFile;
            sparkApplicationSpec.executor = this.executor;
            sparkApplicationSpec.image = this.image;
            sparkApplicationSpec.restartPolicy = this.restartPolicy;
            sparkApplicationSpec.sparkConf = this.sparkConf;
            return sparkApplicationSpec;
        }
    }
}

