/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.source;

import java.text.MessageFormat;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcPlugin;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSource;
import org.apache.linkis.engineplugin.spark.datacalc.exception.DataSourceNotConfigException;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcDataSource;
import org.apache.linkis.engineplugin.spark.datacalc.model.SourceConfig;
import org.apache.linkis.engineplugin.spark.datacalc.service.LinkisDataSourceService;
import org.apache.linkis.engineplugin.spark.datacalc.source.JdbcSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.JdbcSourceConfig;
import org.apache.linkis.engineplugin.spark.datacalc.source.ManagedJdbcSourceConfig;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}2Aa\u0001\u0003\u0001'!)A\u0006\u0001C\u0001[!)q\u0006\u0001C!a\t\tR*\u00198bO\u0016$'\n\u001a2d'>,(oY3\u000b\u0005\u00151\u0011AB:pkJ\u001cWM\u0003\u0002\b\u0011\u0005AA-\u0019;bG\u0006d7M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\rK:<\u0017N\\3qYV<\u0017N\u001c\u0006\u0003\u001b9\ta\u0001\\5oW&\u001c(BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001)i!\u0003CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rE\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0003;\u0019\t1!\u00199j\u0013\tyBD\u0001\bECR\f7)\u00197d'>,(oY3\u0011\u0005\u0005\u0012S\"\u0001\u0003\n\u0005\r\"!aF'b]\u0006<W\r\u001a&eE\u000e\u001cv.\u001e:dK\u000e{gNZ5h!\t)#&D\u0001'\u0015\t9\u0003&A\u0003vi&d7O\u0003\u0002*\u0019\u000511m\\7n_:L!a\u000b\u0014\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\f\t\u0003C\u0001\tqaZ3u\t\u0006$\u0018\r\u0006\u00022wA\u0019!G\u000e\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0007M\fHN\u0003\u0002\n\u001d%\u0011qg\r\u0002\b\t\u0006$\u0018m]3u!\t\u0011\u0014(\u0003\u0002;g\t\u0019!k\\<\t\u000b%\u0011\u0001\u0019\u0001\u001f\u0011\u0005Ij\u0014B\u0001 4\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0001")
public class ManagedJdbcSource
implements DataCalcSource<ManagedJdbcSourceConfig>,
Logging {
    private Logger logger;
    private ManagedJdbcSourceConfig config;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public Object getConfig() {
        return DataCalcPlugin.getConfig$(this);
    }

    @Override
    public void setConfig(Object config) {
        DataCalcPlugin.setConfig$(this, config);
    }

    @Override
    public void prepare(SparkSession spark) {
        DataCalcPlugin.prepare$(this, spark);
    }

    private Logger logger$lzycompute() {
        ManagedJdbcSource managedJdbcSource = this;
        synchronized (managedJdbcSource) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public ManagedJdbcSourceConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(ManagedJdbcSourceConfig x$1) {
        this.config = x$1;
    }

    @Override
    public Dataset<Row> getData(SparkSession spark) {
        DataCalcDataSource db = LinkisDataSourceService.getDatasource(((ManagedJdbcSourceConfig)this.config()).getDatasource());
        if (db == null) {
            throw new DataSourceNotConfigException(SparkErrorCodeSummary.DATA_CALC_DATASOURCE_NOT_CONFIG.getErrorCode(), MessageFormat.format(SparkErrorCodeSummary.DATA_CALC_DATASOURCE_NOT_CONFIG.getErrorDesc(), ((ManagedJdbcSourceConfig)this.config()).getDatasource()));
        }
        JdbcSourceConfig jdbcConfig = new JdbcSourceConfig();
        jdbcConfig.setUrl(db.getUrl());
        jdbcConfig.setDriver(db.getDriver());
        jdbcConfig.setUser(db.getUser());
        jdbcConfig.setPassword(db.getPassword());
        jdbcConfig.setQuery(((ManagedJdbcSourceConfig)this.config()).getQuery());
        jdbcConfig.setPersist(((SourceConfig)this.config()).getPersist());
        jdbcConfig.setOptions(((SourceConfig)this.config()).getOptions());
        jdbcConfig.setResultTable(((SourceConfig)this.config()).getResultTable());
        JdbcSource sourcePlugin = new JdbcSource();
        sourcePlugin.setConfig(jdbcConfig);
        return sourcePlugin.getData(spark);
    }

    public ManagedJdbcSource() {
        DataCalcPlugin.$init$(this);
        Logging.$init$((Logging)this);
    }
}

