/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.KeywordField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;

public class LineFileDocs
implements Closeable {
    public static final Function<String, LocalDateTime> DATE_FIELD_VALUE_TO_LOCALDATETIME = new Function<String, LocalDateTime>(){
        final DateTimeFormatter euroParl = new DateTimeFormatterBuilder().parseStrict().parseCaseInsensitive().appendPattern("uuuu-MM-dd").toFormatter(Locale.ROOT);
        final DateTimeFormatter enwiki = new DateTimeFormatterBuilder().parseStrict().parseCaseInsensitive().appendPattern("dd-MMM-uuuu HH:mm:ss['.'SSS]").toFormatter(Locale.ROOT);

        @Override
        public LocalDateTime apply(String s) {
            if (s.matches("^[0-9]{4}-[0-9]{2}-[0-9]{2}$")) {
                return this.euroParl.parse((CharSequence)s, LocalDate::from).atStartOfDay();
            }
            return this.enwiki.parse((CharSequence)s, LocalDateTime::from);
        }
    };
    private BufferedReader reader;
    private static final int BUFFER_SIZE = 65536;
    private final AtomicInteger id = new AtomicInteger();
    private final String path;
    private final Random random;
    private static final char SEP = '\t';
    private final CloseableThreadLocal<DocState> threadDocs = new CloseableThreadLocal();

    public LineFileDocs(Random random, String path) throws IOException {
        this.path = path;
        this.random = new Random(random.nextLong());
        this.open();
    }

    public LineFileDocs(Random random) throws IOException {
        this(random, LuceneTestCase.TEST_LINE_DOCS_FILE);
    }

    @Override
    public synchronized void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.reader, this.threadDocs});
        this.reader = null;
    }

    private long randomSeekPos(Random random, long size) {
        if (random == null || size <= 3L) {
            return 0L;
        }
        return (random.nextLong() & Long.MAX_VALUE) % (size / 3L);
    }

    private synchronized void open() throws IOException {
        boolean needSkip;
        InputStream is = this.getClass().getResourceAsStream(this.path);
        long size = 0L;
        long seekTo = 0L;
        if (is == null) {
            Path file = Paths.get(this.path, new String[0]);
            size = Files.size(file);
            if (this.path.endsWith(".gz")) {
                is = Files.newInputStream(file, new OpenOption[0]);
                needSkip = true;
            } else {
                seekTo = this.randomSeekPos(this.random, size);
                SeekableByteChannel channel = Files.newByteChannel(file, new OpenOption[0]);
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: LineFileDocs: file seek to fp=" + seekTo + " on open");
                }
                channel.position(seekTo);
                is = Channels.newInputStream(channel);
                if (seekTo > 0L) {
                    int b;
                    while ((b = is.read()) >= 0 && b != 13 && b != 10) {
                    }
                }
                needSkip = false;
            }
        } else {
            size = is.available();
            needSkip = true;
        }
        if (needSkip) {
            int index = this.path.lastIndexOf(46);
            if (index == -1) {
                throw new IllegalArgumentException("could not determine extension for path \"" + this.path + "\"");
            }
            String seekFilePath = this.path.substring(0, index) + ".seek";
            InputStream seekIS = this.getClass().getResourceAsStream(seekFilePath);
            if (seekIS == null) {
                seekIS = Files.newInputStream(Paths.get(seekFilePath, new String[0]), new OpenOption[0]);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(seekIS, StandardCharsets.UTF_8));){
                String line;
                ArrayList<Long> skipPoints = new ArrayList<Long>();
                skipPoints.add(0L);
                while ((line = reader.readLine()) != null) {
                    skipPoints.add(Long.parseLong(line.trim()));
                }
                seekTo = (Long)skipPoints.get(this.random.nextInt(skipPoints.size()));
                is.skip(seekTo);
                is = new GZIPInputStream(is);
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: LineFileDocs: stream skip to fp=" + seekTo + " on open");
                }
            }
        }
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        this.reader = new BufferedReader(new InputStreamReader(is, decoder), 65536);
    }

    public synchronized void reset() throws IOException {
        this.reader.close();
        this.reader = null;
        this.open();
        this.id.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document nextDoc() throws IOException {
        int spot;
        String line;
        LineFileDocs lineFileDocs = this;
        synchronized (lineFileDocs) {
            line = this.reader.readLine();
            if (line == null) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: LineFileDocs: now rewind file...");
                }
                this.reader.close();
                this.reader = null;
                this.open();
                line = this.reader.readLine();
            }
        }
        DocState docState = (DocState)this.threadDocs.get();
        if (docState == null) {
            docState = new DocState();
            this.threadDocs.set((Object)docState);
        }
        if ((spot = line.indexOf(9)) == -1) {
            throw new RuntimeException("line: [" + line + "] is in an invalid format !");
        }
        int spot2 = line.indexOf(9, 1 + spot);
        if (spot2 == -1) {
            throw new RuntimeException("line: [" + line + "] is in an invalid format !");
        }
        docState.body.setStringValue(line.substring(1 + spot2));
        String title = line.substring(0, spot);
        docState.title.setStringValue(title);
        docState.titleTokenized.setStringValue(title);
        docState.date.setStringValue(line.substring(1 + spot, spot2));
        int i = this.id.getAndIncrement();
        docState.id.setStringValue(Integer.toString(i));
        docState.idNum.setIntValue(i);
        docState.pageViews.setLongValue((long)this.random.nextInt(10000));
        if (this.random.nextInt(5) == 4) {
            Document doc = new Document();
            for (IndexableField field : docState.doc) {
                doc.add(field);
            }
            if (this.random.nextInt(3) == 1) {
                int x = this.random.nextInt(4);
                doc.add((IndexableField)new IntPoint("docLength" + x, new int[]{line.length()}));
            }
            if (this.random.nextInt(3) == 1) {
                int x = this.random.nextInt(4);
                doc.add((IndexableField)new IntPoint("docTitleLength" + x, new int[]{title.length()}));
            }
            if (this.random.nextInt(3) == 1) {
                int x = this.random.nextInt(4);
                doc.add((IndexableField)new NumericDocValuesField("docLength" + x, (long)line.length()));
            }
        }
        return docState.doc;
    }

    private static final class DocState {
        final Document doc = new Document();
        final Field titleTokenized;
        final Field title = new KeywordField("title", "", Field.Store.NO);
        final Field body;
        final Field id;
        final Field idNum;
        final Field date;
        final Field pageViews;

        public DocState() {
            this.doc.add((IndexableField)this.title);
            FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
            ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            ft.setStoreTermVectors(true);
            ft.setStoreTermVectorOffsets(true);
            ft.setStoreTermVectorPositions(true);
            this.titleTokenized = new Field("titleTokenized", (CharSequence)"", (IndexableFieldType)ft);
            this.doc.add((IndexableField)this.titleTokenized);
            this.body = new Field("body", (CharSequence)"", (IndexableFieldType)ft);
            this.doc.add((IndexableField)this.body);
            this.id = new StringField("docid", "", Field.Store.YES);
            this.doc.add((IndexableField)this.id);
            this.idNum = new IntField("docid_int", 0, Field.Store.NO);
            this.doc.add((IndexableField)this.idNum);
            this.date = new StringField("date", "", Field.Store.YES);
            this.doc.add((IndexableField)this.date);
            this.pageViews = new NumericDocValuesField("page_views", 0L);
            this.doc.add((IndexableField)this.pageViews);
        }
    }
}

