/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.util;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.swing.JLabel;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;

public class FontUtils {
    private static final String TTF_RESOURCE_NAME = "ElegantIcons.ttf";

    public static JLabel toLinkText(JLabel label) {
        label.setForeground(StyleConstants.LINK_COLOR);
        Font font = label.getFont();
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        label.setFont(font.deriveFont(attributes));
        return label;
    }

    public static Font createElegantIconFont() throws IOException, FontFormatException {
        InputStream is = FontUtils.class.getResourceAsStream(TTF_RESOURCE_NAME);
        return Font.createFont(0, is);
    }

    public static String elegantIconHtml(String iconRef) {
        return "<html><font face=\"ElegantIcons\">" + iconRef + "</font></html>";
    }

    public static String elegantIconHtml(String iconRef, String text) {
        return "<html><font face=\"ElegantIcons\">" + iconRef + "</font>&nbsp;" + text + "</html>";
    }

    private FontUtils() {
    }
}

