/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.legacy.LegacyNumericUtils;

@Deprecated
public class IntMultiTrieField
extends AnalyticsField
implements IntValueStream.CastingIntValueStream {
    private SortedSetDocValues docValues;
    private int count = 0;
    private int[] values = new int[20];

    public IntMultiTrieField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.fieldName);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.count = 0;
        if (this.docValues.advanceExact(doc)) {
            int term;
            while ((long)(term = (int)this.docValues.nextOrd()) != -1L) {
                if (this.count == this.values.length) {
                    this.resizeValues();
                }
                this.values[this.count++] = LegacyNumericUtils.prefixCodedToInt((BytesRef)this.docValues.lookupOrd((long)term));
            }
        }
    }

    private void resizeValues() {
        int[] newValues = new int[this.values.length * 2];
        for (int i = 0; i < this.count; ++i) {
            newValues[i] = this.values[i];
        }
        this.values = newValues;
    }

    @Override
    public void streamInts(IntConsumer cons) {
        for (int i = 0; i < this.count; ++i) {
            cons.accept(this.values[i]);
        }
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        this.streamInts(value -> cons.accept(value));
    }

    @Override
    public void streamFloats(FloatConsumer cons) {
        this.streamInts(value -> cons.accept(value));
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        this.streamInts(value -> cons.accept(value));
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        this.streamInts(value -> cons.accept(Integer.toString(value)));
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        this.streamInts(value -> cons.accept(value));
    }
}

