/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.Transform;
import java.lang.reflect.Array;

class CharacterArrayTransform
implements Transform {
    private final Class entry;

    public CharacterArrayTransform(Class clazz) {
        this.entry = clazz;
    }

    @Override
    public Object read(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (this.entry == Character.TYPE) {
            return cArray;
        }
        return this.read(cArray, n);
    }

    private Object read(char[] cArray, int n) {
        Object object = Array.newInstance(this.entry, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object, i, Character.valueOf(cArray[i]));
        }
        return object;
    }

    @Override
    public String write(Object object) {
        int n = Array.getLength(object);
        if (this.entry == Character.TYPE) {
            char[] cArray = (char[])object;
            return new String(cArray);
        }
        return this.write(object, n);
    }

    private String write(Object object, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (object2 == null) continue;
            stringBuilder.append(object2);
        }
        return stringBuilder.toString();
    }
}

