/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.bins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.IBinManager;
import org.apache.manifoldcf.crawler.system.Logging;

public class BinManager
extends BaseTable
implements IBinManager {
    public static final String _rcsid = "@(#)$Id$";
    public static final String connectorClassField = "connectorclass";
    public static final String binNameField = "binname";
    public static final String binCounterField = "bincounter";

    public BinManager(IDBInterface database) throws ManifoldCFException {
        super(database, "docbins");
    }

    @Override
    public void install() throws ManifoldCFException {
        block5: {
            HashMap<String, ColumnDescription> map;
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                map = new HashMap<String, ColumnDescription>();
                map.put(connectorClassField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(binNameField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(binCounterField, new ColumnDescription("FLOAT", false, false, null, null, false));
                this.performCreate(map, null);
            } else if (existing.get(connectorClassField) == null) {
                map = new HashMap();
                map.put(connectorClassField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                this.performAlter(map, null, null, null);
            }
            IndexDescription binIndex = new IndexDescription(true, new String[]{connectorClassField, binNameField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (binIndex != null && id.equals((Object)binIndex)) {
                    binIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (binIndex == null) break block5;
            this.performAddIndex(null, binIndex);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    @Override
    public void reset() throws ManifoldCFException {
        this.performDelete("", null, null);
    }

    @Override
    public double[] getIncrementBinValues(String connectorClass, String binName, double newBinValue, int count) throws ManifoldCFException {
        double[] returnValues = new double[count];
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(connectorClassField, (Object)connectorClass), new UnitaryClause(binNameField, (Object)binName)});
        IResultSet result = this.performQuery("SELECT bincounter FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", params, null, null);
        if (result.getRowCount() > 0) {
            IResultRow row = result.getRow(0);
            Double value = (Double)row.getValue(binCounterField);
            double rval = value;
            if (rval < newBinValue) {
                rval = newBinValue;
            }
            for (int i = 0; i < count; ++i) {
                returnValues[i] = rval;
                rval += 1.0;
            }
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put(binCounterField, new Double(rval));
            this.performUpdate(map, " WHERE " + query, params, null);
        } else {
            for (int i = 0; i < count; ++i) {
                returnValues[i] = newBinValue;
                newBinValue += 1.0;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(connectorClassField, connectorClass);
            map.put(binNameField, binName);
            map.put(binCounterField, new Double(newBinValue));
            this.performInsert(map, null);
        }
        return returnValues;
    }

    @Override
    public double[] getIncrementBinValuesInTransaction(String connectorClass, String binName, double newBinValue, int count) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.beginTransaction();
            try {
                double[] dArray = this.getIncrementBinValues(connectorClass, binName, newBinValue, count);
                return dArray;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            catch (RuntimeException e) {
                this.signalRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction obtaining docpriorities: " + e.getMessage()));
                    }
                    sleepAmt = this.getSleepAmt();
                    continue;
                }
                throw e;
            }
            finally {
                this.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }
}

