/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command.process;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.nifi.bootstrap.command.process.ManagementServerAddressProvider;
import org.apache.nifi.bootstrap.command.process.ProcessBuilderProvider;
import org.apache.nifi.bootstrap.configuration.ApplicationClassName;
import org.apache.nifi.bootstrap.configuration.ConfigurationProvider;
import org.apache.nifi.bootstrap.configuration.SystemProperty;

public class StandardProcessBuilderProvider
implements ProcessBuilderProvider {
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final BiPredicate<Path, BasicFileAttributes> JAR_FILE_MATCHER = (path, attributes) -> path.getFileName().toString().endsWith(JAR_FILE_EXTENSION);
    private static final int LIBRARY_JAR_DEPTH = 1;
    private static final String SYSTEM_PROPERTY = "-D%s=%s";
    private static final String CLASS_PATH_ARGUMENT = "--class-path";
    private final ConfigurationProvider configurationProvider;
    private final ManagementServerAddressProvider managementServerAddressProvider;

    public StandardProcessBuilderProvider(ConfigurationProvider configurationProvider, ManagementServerAddressProvider managementServerAddressProvider) {
        this.configurationProvider = Objects.requireNonNull(configurationProvider);
        this.managementServerAddressProvider = Objects.requireNonNull(managementServerAddressProvider);
    }

    @Override
    public ProcessBuilder getApplicationProcessBuilder() {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        List<String> command = this.getCommand();
        processBuilder.command(command);
        return processBuilder;
    }

    private List<String> getCommand() {
        ArrayList<String> command = new ArrayList<String>();
        ProcessHandle.Info currentProcessHandleInfo = ProcessHandle.current().info();
        String currentProcessCommand = this.getCurrentProcessCommand(currentProcessHandleInfo);
        command.add(currentProcessCommand);
        String classPath = this.getClassPath();
        command.add(CLASS_PATH_ARGUMENT);
        command.add(classPath);
        Path logDirectory = this.configurationProvider.getLogDirectory();
        String logDirectoryProperty = SYSTEM_PROPERTY.formatted(SystemProperty.LOG_DIRECTORY.getProperty(), logDirectory);
        command.add(logDirectoryProperty);
        Path applicationProperties = this.configurationProvider.getApplicationProperties();
        String applicationPropertiesProperty = SYSTEM_PROPERTY.formatted(SystemProperty.APPLICATION_PROPERTIES.getProperty(), applicationProperties);
        command.add(applicationPropertiesProperty);
        String managementServerAddress = this.managementServerAddressProvider.getAddress().orElseThrow(() -> new IllegalStateException("Management Server Address not configured"));
        String managementServerAddressProperty = SYSTEM_PROPERTY.formatted(SystemProperty.MANAGEMENT_SERVER_ADDRESS.getProperty(), managementServerAddress);
        command.add(managementServerAddressProperty);
        List<String> additionalArguments = this.configurationProvider.getAdditionalArguments();
        command.addAll(additionalArguments);
        command.add(ApplicationClassName.APPLICATION.getName());
        return command;
    }

    private String getCurrentProcessCommand(ProcessHandle.Info currentProcessHandleInfo) {
        Optional<String> currentProcessHandleCommand = currentProcessHandleInfo.command();
        return currentProcessHandleCommand.orElseThrow(IllegalStateException::new);
    }

    private String getClassPath() {
        String string;
        block8: {
            Path libraryDirectory = this.configurationProvider.getLibraryDirectory();
            Stream<Path> libraryFiles = Files.find(libraryDirectory, 1, JAR_FILE_MATCHER, new FileVisitOption[0]);
            try {
                ArrayList<String> libraryPaths = new ArrayList<String>(libraryFiles.map(Path::toString).toList());
                Path configurationDirectory = this.configurationProvider.getConfigurationDirectory();
                libraryPaths.add(configurationDirectory.toString());
                string = String.join((CharSequence)File.pathSeparator, libraryPaths);
                if (libraryFiles == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (libraryFiles != null) {
                        try {
                            libraryFiles.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Read Library Directory [%s] failed".formatted(libraryDirectory), e);
                }
            }
            libraryFiles.close();
        }
        return string;
    }
}

