/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.catalina.webresources.AbstractSingleArchiveResourceSet;
import org.apache.catalina.webresources.JarResource;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

class NestedJarResourceSet
extends AbstractSingleArchiveResourceSet {
    private static final Attributes.Name MULTI_RELEASE = new Attributes.Name("Multi-Release");
    private final URL url;
    private JarFile archive;
    private long archiveUseCount;
    private boolean useCaches;
    private volatile Boolean multiRelease;

    NestedJarResourceSet(URL url, WebResourceRoot root, String webAppMount, String internalPath) throws IllegalArgumentException {
        this.url = url;
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setInternalPath(internalPath);
        this.setStaticOnly(true);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    protected WebResource createArchiveResource(JarEntry jarEntry, String webAppPath, Manifest manifest) {
        return new JarResource((AbstractArchiveResourceSet)this, webAppPath, this.getBaseUrlString(), jarEntry);
    }

    protected void initInternal() throws LifecycleException {
        try {
            JarURLConnection connection = this.connect();
            try {
                this.setManifest(connection.getManifest());
                this.setBaseUrl(connection.getJarFileURL());
            }
            finally {
                if (!connection.getUseCaches()) {
                    connection.getJarFile().close();
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JarFile openJarFile() throws IOException {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive == null) {
                JarURLConnection connection = this.connect();
                this.useCaches = connection.getUseCaches();
                this.archive = connection.getJarFile();
            }
            ++this.archiveUseCount;
            return this.archive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeJarFile() {
        Object object = this.archiveLock;
        synchronized (object) {
            --this.archiveUseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isMultiRelease() {
        if (this.multiRelease == null) {
            Object object = this.archiveLock;
            synchronized (object) {
                if (this.multiRelease == null) {
                    Manifest manifest = this.getManifest();
                    Attributes attributes = manifest != null ? manifest.getMainAttributes() : null;
                    this.multiRelease = attributes != null && attributes.containsKey(MULTI_RELEASE);
                }
            }
        }
        return this.multiRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive != null && this.archiveUseCount == 0L) {
                try {
                    if (!this.useCaches) {
                        this.archive.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.archive = null;
                this.archiveEntries = null;
            }
        }
    }

    private JarURLConnection connect() throws IOException {
        URLConnection connection = this.url.openConnection();
        ResourceUtils.useCachesIfNecessary((URLConnection)connection);
        Assert.state((boolean)(connection instanceof JarURLConnection), () -> "URL '%s' did not return a JAR connection".formatted(this.url));
        connection.connect();
        return (JarURLConnection)connection;
    }
}

