/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmParameter;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.FunctionImportParameter;
import org.apache.olingo.odata2.api.edm.provider.ReturnType;
import org.apache.olingo.odata2.core.edm.provider.EdmAnnotationsImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmNamedImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmParameterImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmTypedImplProv;

public class EdmFunctionImportImplProv
extends EdmNamedImplProv
implements EdmFunctionImport,
EdmAnnotatable {
    private FunctionImport functionImport;
    private EdmEntityContainer edmEntityContainer;
    private Map<String, EdmParameter> edmParameters;
    private Map<String, FunctionImportParameter> parameters;
    private List<String> parametersList;
    private EdmAnnotations annotations;
    private EdmTyped edmReturnType;

    public EdmFunctionImportImplProv(EdmImplProv edm, FunctionImport functionImport, EdmEntityContainer edmEntityContainer) throws EdmException {
        super(edm, functionImport.getName());
        this.functionImport = functionImport;
        this.edmEntityContainer = edmEntityContainer;
        this.buildFunctionImportParametersInternal();
        this.edmParameters = new HashMap<String, EdmParameter>();
    }

    private void buildFunctionImportParametersInternal() {
        this.parameters = new HashMap<String, FunctionImportParameter>();
        List functionImportParameters = this.functionImport.getParameters();
        if (functionImportParameters != null) {
            for (FunctionImportParameter parameter : functionImportParameters) {
                this.parameters.put(parameter.getName(), parameter);
            }
        }
    }

    public EdmParameter getParameter(String name) throws EdmException {
        EdmParameter parameter = null;
        parameter = this.edmParameters.containsKey(name) ? this.edmParameters.get(name) : this.createParameter(name);
        return parameter;
    }

    private EdmParameter createParameter(String name) throws EdmException {
        EdmParameterImplProv edmParameter = null;
        if (this.parameters.containsKey(name)) {
            FunctionImportParameter parameter = this.parameters.get(name);
            edmParameter = new EdmParameterImplProv(this.edm, parameter);
            this.edmParameters.put(name, edmParameter);
        }
        return edmParameter;
    }

    public List<String> getParameterNames() throws EdmException {
        if (this.parametersList == null) {
            this.parametersList = new ArrayList<String>();
            List functionImportParameters = this.functionImport.getParameters();
            if (functionImportParameters != null) {
                for (FunctionImportParameter parameter : functionImportParameters) {
                    this.parametersList.add(parameter.getName());
                }
            }
        }
        return this.parametersList;
    }

    public EdmEntitySet getEntitySet() throws EdmException {
        return this.edmEntityContainer.getEntitySet(this.functionImport.getEntitySet());
    }

    public String getHttpMethod() throws EdmException {
        return this.functionImport.getHttpMethod();
    }

    public EdmTyped getReturnType() throws EdmException {
        ReturnType returnType;
        if (this.edmReturnType == null && (returnType = this.functionImport.getReturnType()) != null) {
            this.edmReturnType = new EdmTypedImplProv(this.edm, this.functionImport.getName(), returnType.getTypeName(), returnType.getMultiplicity());
        }
        return this.edmReturnType;
    }

    public EdmEntityContainer getEntityContainer() throws EdmException {
        return this.edmEntityContainer;
    }

    public EdmAnnotations getAnnotations() throws EdmException {
        if (this.annotations == null) {
            this.annotations = new EdmAnnotationsImplProv(this.functionImport.getAnnotationAttributes(), this.functionImport.getAnnotationElements());
        }
        return this.annotations;
    }

    public EdmMapping getMapping() throws EdmException {
        return this.functionImport.getMapping();
    }
}

