package org.apache.jetspeed.portlet;

import java.util.Enumeration;

/**
 * The <CODE>PortletData</CODE> contains information about the concrete portlet
 * instance. Also, it is through the data that the portlet has
 * access to the personalized data. The portlet can therefore only read the 
 * personalization data. Only when the portlet is in EDIT mode, it has write 
 * access to the personalization data.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 */
public interface PortletData
{
    /**
     ** Sets the attribute with the given name and value.
     **
     ** @param   name
     **          the attribute name
     ** @param   value
     **          the attribute value
     ** @exception   AccessDeniedException
     **              if the caller isn't authorized to access
     **              this data object
     **/

    public void setAttribute (String name, Object value) throws AccessDeniedException;

    /**
     ** Returns the value of the attribute with the given name,
     ** or <CODE>null</CODE> if no such attribute exists.
     **
     ** @param   name
     **          the attribute name
     **
     ** @return   the attribute value
     **/

    public Object getAttribute (String name);

    /**
     ** Returns an enumeration of all available attributes names.
     **
     ** @return   an enumeration of attribute names
     **
     ** @see   #getAttribute(String)
     **/

    public Enumeration getAttributeNames ();

    /**
     ** Removes the attribute with the given name. If no such
     ** attribute exists, this method does nothing.
     **
     ** @param   name
     **          the attribute name
     ** @exception   AccessDeniedException
     **              if the caller isn't authorized to access
     **              this data object
     **/

    public void removeAttribute (String name) throws AccessDeniedException;

    /**
     * Removes all attributes. If no attributes exist, this method
     * does nothing.
     * 
     * @exception   AccessDeniedException
     *              if the caller isn't authorized to access
     *              this data object
     * @deprecated deprecated since version 1.1
     */
    public void removeAllAttributes () throws AccessDeniedException;

    /**
     ** Stores all attributes.
     **
     ** @exception   AccessDeniedException
     **              if the caller isn't authorized to access
     **              this data object
     ** @exception   java.io.IOException
     **              if the streaming causes an I/O problem
     **/

    public void store () throws AccessDeniedException, java.io.IOException;
}
