package org.apache.jetspeed.portletcontainer.event;

import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portletcontainer.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.invoker.*;
import org.apache.jetspeed.portletcontainer.util.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.PortletInstanceEntry;

import com.ibm.wps.portletcontainer.invoker.*;
import com.ibm.wps.util.ObjectID;

// turbine
import org.apache.turbine.util.Log;

import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * The <CODE>MessageTriggerEvent</CODE> class distributes
 * MessageEvents to each portlet. This class is necessary because
 * the sent message event can be distributed only when
 * the event queue is processed.
 */
public class MessageTriggerEvent extends InstanceEventImpl
{
    private String destinationPortletName = null;
    private PortletMessage message = null;

    public MessageTriggerEvent( PortletInstanceEntry entry,
                                String destinationPortletName, 
                                PortletMessage message )
    {
        super(entry,
              null);
        this.destinationPortletName = destinationPortletName;
        this.message = message;
    }


    /**
     * prepares the stored event and distributes the real message to the clients.
     * Depending on the type of the message it will be sent across applications or
     * only within the same page,
     * 
     * @param evtEnv  the event environment
     */
    public void prepare(EventEnvironment evtEnv) throws PortletException, PortletInvokerException
    {
        if (Log.isDebugEnabled)
            Log.debug( "MessageTriggerEvent.prepare: starting to prepare the message distribution ...");

        // now we read the message trigger event and distribute the 
        // real message event to each portlet
        PortletRequestImpl sourceRequest = 
            (PortletRequestImpl)evtEnv.getPortletRequest(getPortletInstanceEntry());

        PortletConfigImpl sourceConfig = (PortletConfigImpl)evtEnv.getPortletConfig(
            getPortletInstanceEntry().getConcretePortlet());

        if ((sourceRequest==null) || (sourceConfig==null)) return;

        PortletInvokerService invoker = evtEnv.getPortletInvoker();
        HttpServletRequest servletRequest = evtEnv.getServletRequest();
        HttpServletResponse servletResponse = evtEnv.getServletResponse();
        PortalInformationProvider provider = evtEnv.getProvider();
        Collection allPortletsOnPage = evtEnv.getPortletsOnPage();

        // send message across portlet application
        boolean across = false;
        if (message instanceof DefaultPortletMessage) across = true;

        ObjectID sourcePiid = sourceRequest.getPortletInstanceEntry().getPiid();
        ObjectID sourceAid = sourceConfig.getPortletEntry().getApplication().getAid();

        // send to all portlets of the same portlet application on this page
        if (destinationPortletName==null) { 

            // iterate all portlets on the page
            Iterator iterator = allPortletsOnPage.iterator();
            while (iterator.hasNext()) {
                PortletInstanceEntry entry = (PortletInstanceEntry)iterator.next();

                PortletConfigImpl portletConfig = 
                    (PortletConfigImpl)evtEnv.getPortletConfig(entry.getConcretePortlet());

                // check if the portlet is not the same portlet as the sender
                if (!sourcePiid.equals(entry.getPiid())) {
                    // check if the portlet is in the same portlet application or 
                    // the message should be distributed across applications
                    if ((sourceAid.equals(portletConfig.getPortletEntry().getApplication().getAid())) || 
                        (across)) {

                        PortletRequestImpl portletRequest = new PortletRequestImpl( entry,
                                                                                    servletRequest,
                                                                                    portletConfig,
                                                                                    provider,
                                                                                    true );
                        MessageEventImpl messageEvent = new MessageEventImpl(entry,
                                                                             portletRequest,
                                                                             message);
                        messageEvent.prepare(evtEnv);

                    }
                }
            }

        }
        else { // send to the portlet with the same name of the same portlet application on this page
            // iterate all portlets on the page
            Iterator iterator = allPortletsOnPage.iterator();
            while (iterator.hasNext()) {
                PortletInstanceEntry entry = (PortletInstanceEntry)iterator.next();

                PortletConfigImpl portletConfig = 
                    (PortletConfigImpl)evtEnv.getPortletConfig(entry.getConcretePortlet());

                // check if the portlet is the destination portlet, but not the same
                // virtual instance
                if ((portletConfig.getName().equals(destinationPortletName)) &&
                    (!sourcePiid.equals(entry.getPiid()))) {
                    // check if the portlet is in the same portlet application or 
                    // the message should be distributed across applications
                    if ((sourceAid.equals(portletConfig.getPortletEntry().getApplication().getAid())) || 
                        (across)) {

                        PortletRequestImpl portletRequest = new PortletRequestImpl( entry,
                                                                                    servletRequest,
                                                                                    portletConfig,
                                                                                    provider,
                                                                                    true );
                        MessageEventImpl messageEvent = new MessageEventImpl(entry,
                                                                             portletRequest,
                                                                             message);
                        messageEvent.prepare(evtEnv);

                    }
                }
            }
        }
        
        if (Log.isDebugEnabled)
            Log.debug( "MessageTriggerEvent.prepare: finished preparing the message distribution ...");
    }

}