package org.apache.jetspeed.portletcontainer.event;

import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portletcontainer.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.invoker.*;
import org.apache.jetspeed.portletcontainer.util.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.PortletInstanceEntry;

import org.apache.turbine.util.*;

import com.ibm.wps.portletcontainer.invoker.*;

import javax.servlet.http.*;

public class WindowEventImpl extends InstanceEventImpl implements WindowEvent
{
    private int windowEventId = -1;

    public WindowEventImpl(PortletInstanceEntry entry,
                           PortletRequest request, 
                           int windowEventId)
    {
        super(entry, 
              request);
        this.windowEventId = windowEventId;
    }

    public int getEventId ()
    {
        return windowEventId;
    }

    public void prepare(EventEnvironment evtEnv) throws PortletException, PortletInvokerException
    {
        PortletInvokerImpl invoker = (PortletInvokerImpl)evtEnv.getPortletInvoker();

        HttpServletRequest servletRequest = evtEnv.getServletRequest();
        
        HttpServletResponse servletResponse = evtEnv.getServletResponse();

        PortletRequestImpl portletRequest = (PortletRequestImpl)getRequest();

        PortletResponseImpl portletResponse = new PortletResponseImpl( getPortletInstanceEntry(),
                                                                       portletRequest,
                                                                       servletResponse,
                                                                       true );

        PortletConfig portletConfig = evtEnv.getPortletConfig(getPortletInstanceEntry().getConcretePortlet());

        PortletInvokerImpl.InternalPortletData data = 
            ((PortletInvokerImpl.EventEnvironmentImpl)evtEnv).getInternalPortletData(getPortletInstanceEntry().getConcretePortlet());

        try
        {
            portletRequest.setAttribute(org.apache.jetspeed.portlet.spi.Constants.PARAM_WINDOW_EVENT, 
                                        this);

            // include portlet by using request dispatcher
            invoker.include (org.apache.jetspeed.portlet.spi.Constants.METHOD_PERFORM_WINDOW,
                             portletRequest,
                             portletResponse,
                             servletRequest, 
                             servletResponse, 
                             data);
        }
        catch (PortletException e)
        {
            String message = "WindowEventImpl.prepare: The portlet with the name '"+
                             portletConfig.getName()+"' ("+getPortletInstanceEntry()+") failed while processing the window event.";
            Log.error(message, e);
            throw e; // rethrow
        }
        catch (java.io.IOException e)
        {
            String message = "WindowEventImpl.prepare: The portlet with the name '"+
                             portletConfig.getName()+"' ("+getPortletInstanceEntry()+") failed while processing the window event.";
            Log.error(message, e);
            throw new PortletException(e); // rethrow
        }
    }

}