package org.apache.jetspeed.portletcontainer.om.portletregistry;

import org.apache.jetspeed.portletcontainer.om.applicationregistry.ConcreteApplicationEntry;
import org.apache.jetspeed.portletcontainer.om.clientregistry.ClientEntry;
import com.ibm.wps.util.ObjectID;
import java.util.Locale;
import java.util.Map;
import java.util.Enumeration;

/**
 * <P>
 * The <CODE>ConcretePortletEntry</CODE> interface represents
 * one portlet and is accessed by the portlet container to query 
 * information about each portlet stored in the PortletRegistry.
 * </P>
 * <P>
 * This abstraction layer helps to generalize the portlet container from
 * special implementations like data storage and moreover it is not bound
 * to a special Application Server.
 * </P>
 * 
 * @author <a href="shesmer@raleigh.ibm.com">Stephan Hesmer</a>
 */
public interface ConcretePortletEntry
{

    /**
     * Returns the identifier of this portlet.
     * 
     * @return a string containing the portlet identifier
     */
    public ObjectID getPid();

    /**
     * Returns the root portlet
     * 
     * @return the root portlet
     */
    public PortletEntry getRootPortlet();

    /**
     * Returns the parent portlet or null if the parent is
     * the root element and no concrete portlet.
     * 
     * @return the parent portlet
     */
    public ConcretePortletEntry getParentPortlet();

    /**
     * Returns the portlet application that the portlet
     * runs in as a string.
     * 
     * @return the portlet application
     */
    public ConcreteApplicationEntry getConcreteApplication ();

    /**
     * Returns the name of this portlet.
     * 
     * @return a string containing the portlet name
     */
    public String getName();

    /**
     * Sets the name of this portlet.
     * 
     * @param name       a string containing the portlet name
     */
    public void setName(String name);

    /**
     * Returns the default locale of this portlet.
     * 
     * @return the default locale
     */
    public Locale getDefaultLocale();

    /**
     * Sets the default locale of this portlet.
     * 
     * @param locale      the default locale
     */
    public void setDefaultLocale(Locale locale);

    /**
     * Returns the static portlet title of this portlet.
     * 
     * @param locale the locale of the preferred language
     * @param client the client device the user connects to the portal with
     * @return the portlet title
     */
    public String getTitle (Locale locale,
                            ClientEntry client);

    /**
     * Sets the static portlet title of this portlet.
     * 
     * @param title  the portlet title
     * @param locale the locale of the preferred language
     * @param client the client device the user connects to the portal with
     */
    public void setTitle (String title,
                          Locale locale,
                          ClientEntry client);

    /**
     * Returns an enumeration that defines which languages
     * or sub-languages the portlet supports. The enumeration
     * consists of elements of the type <CODE>Locale</CODE>.
     * 
     * @return an enumeration of locales
     */
    public Enumeration getSupportedLanguages ();

    /**
     * Sets an enumeration that defines which languages
     * or sub-languages the portlet supports. The enumeration
     * consists of elements of the type <CODE>Locale</CODE>.
     * 
     * @param languages an enumeration of locales
     */
    public void setSupportedLanguages (Enumeration languages);

    /**
     * Returns a hashtable containing name[string]/value[string] pairs of all parameters
     * of this portlet.
     * 
     * @return a hashtable containing name[string]/value[string] pairs
     */
    public Map getParameters ();

    /**
     * Sets a hashtable containing name[string]/value[string] pairs of all parameters
     * of this portlet.
     * 
     * @param parameters    a hashtable containing name[string]/value[string] pairs
     */
    public void setParameters (Map parameters);

}
