package org.apache.jetspeed.portletcontainer.util;

// jetspeed
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portletcontainer.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.services.portletregistry.PortletRegistryAccess;

// turbine
import org.apache.turbine.util.Log;

// java
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.InputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.Locale;
import java.util.Enumeration;

public class PortletSessionManager
{

    public static void clearPortletSessions( HttpServletRequest request,
                                             PortalInformationProvider provider)
    {
        Log.debug("PortletSessionManager.clearPortletSessions: clearing all portlet application sessions of current user.");

        HttpSession session = request.getSession();
        
        Enumeration attributes = session.getAttributeNames();
        
        while (attributes.hasMoreElements())
        {
            String name = (String)attributes.nextElement();
            if ((PortletNamespaceMapper.isInNamespace(name)) &&
                (name.endsWith("PortletSessionData")))
            {
                // get the session object
                PortletSessionData portletSessionData = (PortletSessionData)session.getAttribute(name);

                // remove portletsession from session
                // logout is done via "valueUnbound" in PortletSessionData
                session.removeAttribute( name );

                // remove all attributes of this portletsession
                PortletSessionImpl portletSession = new PortletSessionImpl( portletSessionData, 
                                                                            session );
                portletSession.removeAttributes();
            }
        }
    }

    public static PortletSessionImpl createPortletSession(String caiid, 
                                                          HttpSession session)
    {
        // create portlet session data (holds serializable data)
        PortletSessionData sessionData = new PortletSessionData( caiid );
        // create portlet session
        PortletSessionImpl portletSession = new PortletSessionImpl(sessionData, session);

        // put portlet session data in http session (holds serializable data)
        session.setAttribute(
            PortletNamespaceMapper.encode( caiid, 
                                           "PortletSessionData" ), sessionData );

        return portletSession;
    }

    public static PortletSessionImpl getPortletSession( String caiid,
                                                        HttpSession session )
    {
        // get portlet session data (holds serializable data)
        PortletSessionData sessionData = getSessionData(caiid, session);
        if (sessionData!=null)
        {
            // create portlet session
            PortletSessionImpl portletSession = new PortletSessionImpl( sessionData, session );

            // touch the session to update internal variables
            portletSession.access( );

            // return portlet session
            return portletSession;
        }
        else return null;
    }
/*
    public static Enumeration getPortletSessions(HttpSession session)
    {
        Vector allSessions = new Vector();
        if (session!=null)
        {
            Enumeration attributes = session.getAttributeNames();
            while (attributes.hasMoreElements()) {
                String name = (String)attributes.nextElement();
                if ((PortletNamespaceMapper.isInNamespace(name)) &&
                    (name.endsWith("PortletSessionData"))) {    
                    PortletSessionImpl portletSession = (PortletSessionImpl) session.getAttribute(name);
                    allSessions.add(portletSession);
                }
            }
        }
        return allSessions.elements();
    }
*/
    /**
     * Checks if the portlet session associated with the given portlet
     * instance identifier, is already created.<BR>
     *
     * @param caiid     the concrete portlet application instance identifier
     * @param request  the http servlet request
     * @return a boolean indicating whether the the portlet session is created or not
     */
    public static boolean isSessionCreated(String caiid,
                                           HttpSession session)
    {
        return getSessionData(caiid,session)!=null;
    }

    public static PortletSessionData getSessionData(String caiid,
                                                    HttpSession session)
    {
        if (session==null) return null;
        return (PortletSessionData)session.getAttribute(
            PortletNamespaceMapper.encode( caiid, 
                                           "PortletSessionData" ) );
    }

    /**
     * Checks if a user is available
     *
     * @param provider the portal information provider
     * @return true if a user exists
     */
    public static boolean isUserLoggedIn( HttpSession session )
    {
        if (UserInformationAccess.getUserInformation( session )==null) return false;
        else return true;
    }

}
