/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.services.beans;

import java.io.Serializable;
import java.util.Collection;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.jetspeed.om.portlet.ContainerRuntimeOption;

/**
 * ContainerRuntimeOptionBean
 * 
 * @version $Id: ContainerRuntimeOptionBean.java 884883 2009-11-27 14:17:56Z woonsan $
 */
@XmlRootElement(name="containerRuntimeOption")
public class ContainerRuntimeOptionBean implements Serializable
{
    private static final long serialVersionUID = 1L;
    
    private String name;
    private Collection<String> values;

    public ContainerRuntimeOptionBean()
    {
        
    }
    
    public ContainerRuntimeOptionBean(final ContainerRuntimeOption containerRuntimeOption)
    {
        name = containerRuntimeOption.getName();
        values = containerRuntimeOption.getValues();
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    @XmlElementWrapper(name="values")
    @XmlElements(@XmlElement(name="value"))
    public Collection<String> getValues()
    {
        return values;
    }

    public void setValues(Collection<String> values)
    {
        this.values = values;
    }

}
