/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.api.kv.impl.op;

import io.netty.util.Recycler;
import java.util.List;
import org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.bookkeeper.api.kv.op.Op;
import org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.bookkeeper.api.kv.op.TxnOp;

class TxnOpImpl<K, V>
implements TxnOp<K, V> {
    private final Recycler.Handle<TxnOpImpl<K, V>> handle;
    private List<CompareOp<K, V>> compareOps;
    private List<Op<K, V>> successOps;
    private List<Op<K, V>> failureOps;

    @Override
    public List<CompareOp<K, V>> compareOps() {
        return this.compareOps;
    }

    @Override
    public List<Op<K, V>> successOps() {
        return this.successOps;
    }

    @Override
    public List<Op<K, V>> failureOps() {
        return this.failureOps;
    }

    @Override
    public OpType type() {
        return OpType.TXN;
    }

    @Override
    public void close() {
        if (null != this.compareOps) {
            this.compareOps.forEach(CompareOp::close);
            this.compareOps = null;
        }
        if (null != this.successOps) {
            this.successOps.forEach(Op::close);
            this.successOps = null;
        }
        if (null != this.failureOps) {
            this.failureOps.forEach(Op::close);
            this.failureOps = null;
        }
        this.handle.recycle((Object)this);
    }

    public Recycler.Handle<TxnOpImpl<K, V>> handle() {
        return this.handle;
    }

    TxnOpImpl<K, V> compareOps(List<CompareOp<K, V>> compareOps) {
        this.compareOps = compareOps;
        return this;
    }

    TxnOpImpl<K, V> successOps(List<Op<K, V>> successOps) {
        this.successOps = successOps;
        return this;
    }

    TxnOpImpl<K, V> failureOps(List<Op<K, V>> failureOps) {
        this.failureOps = failureOps;
        return this;
    }

    TxnOpImpl(Recycler.Handle<TxnOpImpl<K, V>> handle) {
        this.handle = handle;
    }

    public String toString() {
        return "TxnOpImpl(compareOps=" + this.compareOps() + ", successOps=" + this.successOps() + ", failureOps=" + this.failureOps() + ")";
    }
}

